/*
 * @(#)ShopFreightCountReqDto.java 1.0 2020-07-15
 *
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shop.api.dto.request.freight;

import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDirFreightDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.freight.FreightTemplateRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.List;

/**
 *  运费计算
 * @author 简树
 * @since 2.0.0
 */
@ApiModel(value = "ShopFreightCountReqDto", description = "运费计算请求")
public class ShopFreightCountReqDto extends BaseVo {
    @ApiModelProperty(name = "addressId",value = "用户地址id")
    private  Long addressId;
    @ApiModelProperty(name = "shopId",value = "店铺id")
    private Long shopId;
    // todo 确定是否需要外部传入
    @ApiModelProperty(name = "freightTemplateId",value = "运费模板id")
    private Long freightTemplateId;
    @ApiModelProperty(name = "provinceCode",value = "省区编码")
    private String provinceCode;
    @ApiModelProperty(name = "cityCode",value = "市区编码")
    private String cityCode;
    @ApiModelProperty(name = "areaCode",value = "区域编码")
    private String areaCode;
    @ApiModelProperty(name = "orderPayAmount",value = "订单支付金额")
    private BigDecimal orderPayAmount;
    // todo 标清楚哪些需要外部传入
    @ApiModelProperty(name = "itemAttrValues",value = "商品属性值")
    private List<CountFreightItemValue> itemAttrValues;
    // todo 改成一个独立的接口
    @ApiModelProperty(name = "shoppingCart",value = "是否是购物车进来,默认否")
    private boolean shoppingCart = false;
    // todo 理一下逻辑
    @ApiModelProperty(name = "itemAttrValues",value = "店铺类目运费模板属性")
    private List<ShopDirFreightDto> shopDirFreightDtoList;

    @ApiModelProperty(name = "destinationLon", value = "目的地经度")
    private String destinationLon;
    @ApiModelProperty(name = "destinationLat", value = "目的地维度")
    private String destinationLat;

    public String getDestinationLon() {
        return destinationLon;
    }

    public void setDestinationLon(String destinationLon) {
        this.destinationLon = destinationLon;
    }

    public String getDestinationLat() {
        return destinationLat;
    }

    public void setDestinationLat(String destinationLat) {
        this.destinationLat = destinationLat;
    }

    public static class CountFreightItemValue {
        @ApiModelProperty(name = "countType",value = "商品计算属性值类型：0 重量；1 件数；2 体积；3 距离；4金额")
        private Integer countType;
        @ApiModelProperty(name = "countValue",value = "计算总值")
        private BigDecimal countValue;
        @ApiModelProperty(name = "skuId",value = "计算的skuId")
        private String skuId;
        @ApiModelProperty(name = "freightTemplateId",value = "运费模板id")
        private Long freightTemplateId;
        @ApiModelProperty(name = "freightTemplateRespDto",value = "运费模板参数")
        private FreightTemplateRespDto freightTemplateRespDto;
        @ApiModelProperty(name = "类目id")
        private Long backDirId;
        @ApiModelProperty(name = "backDirLabelId", value = "商品标签id(后端类目id)")
        private Long backDirLabelId;
        @ApiModelProperty(name = "backDirLabelName", value = "商品标签id(后端类目名称)")
        private String backDirLabelName;

        @ApiModelProperty(name = "itemNum",value = "商品数量")
        private BigDecimal itemNum;

        @ApiModelProperty(name = "price",value = "商品价格")
        private BigDecimal price;

        public FreightTemplateRespDto getFreightTemplateRespDto() {
            return freightTemplateRespDto;
        }

        public void setFreightTemplateRespDto(FreightTemplateRespDto freightTemplateRespDto) {
            this.freightTemplateRespDto = freightTemplateRespDto;
        }

        public Long getFreightTemplateId() {
            return freightTemplateId;
        }

        public void setFreightTemplateId(Long freightTemplateId) {
            this.freightTemplateId = freightTemplateId;
        }

        public String getSkuId() {
            return skuId;
        }

        public void setSkuId(String skuId) {
            this.skuId = skuId;
        }

        public Integer getCountType() {
            return countType;
        }

        public void setCountType(Integer countType) {
            this.countType = countType;
        }

        public BigDecimal getCountValue() {
            return countValue;
        }

        public void setCountValue(BigDecimal countValue) {
            this.countValue = countValue;
        }

        public Long getBackDirId() {
            return backDirId;
        }

        public void setBackDirId(Long backDirId) {
            this.backDirId = backDirId;
        }

        public Long getBackDirLabelId() {
            return backDirLabelId;
        }

        public void setBackDirLabelId(Long backDirLabelId) {
            this.backDirLabelId = backDirLabelId;
        }

        public String getBackDirLabelName() {
            return backDirLabelName;
        }

        public void setBackDirLabelName(String backDirLabelName) {
            this.backDirLabelName = backDirLabelName;
        }

        public BigDecimal getItemNum() {
            return itemNum;
        }

        public void setItemNum(BigDecimal itemNum) {
            this.itemNum = itemNum;
        }

        public BigDecimal getPrice() {
            return price;
        }

        public void setPrice(BigDecimal price) {
            this.price = price;
        }
    }

    public String getProvinceCode() {
        return provinceCode;
    }

    public void setProvinceCode(String provinceCode) {
        this.provinceCode = provinceCode;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public Long getFreightTemplateId() {
        return freightTemplateId;
    }

    public void setFreightTemplateId(Long freightTemplateId) {
        this.freightTemplateId = freightTemplateId;
    }

    public List<CountFreightItemValue> getItemAttrValues() {
        return itemAttrValues;
    }

    public void setItemAttrValues(List<CountFreightItemValue> itemAttrValues) {
        this.itemAttrValues = itemAttrValues;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public BigDecimal getOrderPayAmount() {
        return orderPayAmount;
    }

    public void setOrderPayAmount(BigDecimal orderPayAmount) {
        this.orderPayAmount = orderPayAmount;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public Long getAddressId() {
        return addressId;
    }

    public void setAddressId(Long addressId) {
        this.addressId = addressId;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public List<ShopDirFreightDto> getShopDirFreightDtoList() {
        return shopDirFreightDtoList;
    }

    public void setShopDirFreightDtoList(List<ShopDirFreightDto> shopDirFreightDtoList) {
        this.shopDirFreightDtoList = shopDirFreightDtoList;
    }

    public boolean getShoppingCart() {
        return shoppingCart;
    }

    public void setShoppingCart(boolean shoppingCart) {
        this.shoppingCart = shoppingCart;
    }
}