/*
 * @(#)FreightCountRespDto.java 1.0 2020-07-15
 *
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shop.api.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * 运费
 *
 * @author 简树
 * @since 2.0.0
 */
@ApiModel(value = "FreightCountRespDto", description = "运费计算结果")
public class FreightCountRespDto extends BaseRespDto{
    @ApiModelProperty(name = "shopId",value = "店铺id")
    private Long shopId;

    @ApiModelProperty(name = "freight",value = "运费")
    private BigDecimal freight;
    @ApiModelProperty(name = "freeFreightDes",value = "免邮计算")
    private String freeFreightDes;
    /**
     * 起送价格
     * 默认为0
     */
    @ApiModelProperty(name = "startingPric", value = "起送价格 默认为0")
    private BigDecimal startingPric = BigDecimal.ZERO;

    public BigDecimal getStartingPric() {
        return startingPric;
    }

    public void setStartingPric(BigDecimal startingPric) {
        this.startingPric = startingPric;
    }

    public String getFreeFreightDes() {
        return freeFreightDes;
    }

    public void setFreeFreightDes(String freeFreightDes) {
        this.freeFreightDes = freeFreightDes;
    }

    public BigDecimal getFreight() {
        return freight;
    }

    public void setFreight(BigDecimal freight) {
        this.freight = freight;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }
}