/*
 * @(#)SellerBusinessScopeDto.java 1.0 2018/9/3
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shop.api.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 商户经营范围响应Dto类
 *
 * @author 华生
 * @since 1.0.0
 */

@ApiModel(value = "SellerBusinessScopeRespDto", description = "商户经营区域响应Dto")
public class SellerBusinessScopeRespDto extends BaseRespDto{

    /**
     * 业务ID
     */
    @ApiModelProperty(name = "id",value = "商户经营范围ID")
    private Long id;

    /**
     * 商户ID
     */
    @ApiModelProperty(name = "sellerId", value = "商户ID")
    private Long sellerId;

    /**
     * 业务ID
     */
    @ApiModelProperty(name = "businessId", value = "业务ID")
    private Long businessId;

    /**
     * 业务类型，区分类目(CATEGORY)，品牌(BRAND)，渠道(CHANNEL)
     */
    @ApiModelProperty(name = "businessType", value = "业务类型")
    private String businessType;

    /**
     * 实例ID
     */
    @ApiModelProperty(name = "instanceId", value = "实例ID")
    private Long instanceId;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public Long getBusinessId() {
        return businessId;
    }

    public void setBusinessId(Long businessId) {
        this.businessId = businessId;
    }

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }
}
