package com.dtyunxi.yundt.cube.center.shop.api.dto.response;

import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerAreaDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;
import java.util.List;

/**
 * 商户查询返回DTO
 *
 * @author wu.tong
 * @since 1.0.0
 */
@ApiModel(value = "SellerRespDto", description = "商户查询返回DTO")
public class SellerRespDto extends BaseRespDto {

    /**
     * 商户ID
     */
    @ApiModelProperty(name = "id", value = "商户ID")
    private Long id;

    @ApiModelProperty(name = "commanderInfoId", value = "分销员id，选填")
    private Long commanderInfoId;
    /**
     * 商户编码
     */
    @ApiModelProperty(name = "code", value = "商户编码")
    private String code;

    /**
     * 商户名称
     */
    @ApiModelProperty(name = "name", value = "商户名称")
    private String name;

    /**
     * 商户类型（PERSONAL 个人 INDIVIDUAL 个体工商户 ENTERPRISE 企业）
     */
    @ApiModelProperty(name = "type", value = "商户类型（PERSONAL 个人 INDIVIDUAL 个体工商户 ENTERPRISE 企业）")
    private String type;

    /**
     * 地址
     */
    @ApiModelProperty(name = "address", value = "地址")
    private String address;

    /**
     * 联系人
     */
    @ApiModelProperty(name = "contactPerson", value = "联系人")
    private String contactPerson;

    /**
     * 移动电话
     */
    @ApiModelProperty(name = "contactMobile", value = "移动电话")
    private String contactMobile;

    /**
     * 固话
     */
    @ApiModelProperty(name = "contactPhone", value = "固话")
    private String contactPhone;

    /**
     * 公司名称
     */
    @ApiModelProperty(name = "companyName", value = "公司名称")
    private String companyName;

    /**
     * 营业执照正面
     */
    @ApiModelProperty(name = "businessLicenseA", value = "营业执照正面")
    private String businessLicenseA;

    /**
     * 营业执照背面
     */
    @ApiModelProperty(name = "businessLicenseB", value = "营业执照背面")
    private String businessLicenseB;

    /**
     * 身份证正面
     */
    @ApiModelProperty(name = "idCardA", value = "身份证正面")
    private String idCardA;

    /**
     * 身份证反面
     */
    @ApiModelProperty(name = "idCardB", value = "身份证反面")
    private String idCardB;

    /**
     * 状态。NORMAL正常 BANNED封禁 CORRECTION整改
     */
    @ApiModelProperty(name = "status", value = "状态。NORMAL正常 BANNED封禁 CORRECTION整改")
    private String status;

    /**
     * 所有人id
     */
    @ApiModelProperty(name = "ownerId", value = "所有人id")
    private Long ownerId;

    /**
     * 分组id
     */
    @ApiModelProperty(name = "groupId", value = "分组id")
    private Long groupId;

    /**
     * 组织id
     */
    @ApiModelProperty(name = "organizationId", value = "组织id")
    private Long organizationId;

    /**
     * 组织名称
     */
    @ApiModelProperty(name = "organizationName", value = "组织名称，选填")
    private String organizationName;

    /**
     * 实例id
     */
    @ApiModelProperty(name = "instanceId", value = "实例id")
    private Long instanceId;
    
    /**
	 * 租户ID
	 */
	@ApiModelProperty(name = "tenantId", value = "租户ID")
	private Long tenantId;

    /**
     * 法人
     */
    @ApiModelProperty(name = "manager", value = "法人")
    private String manager;


    /**
     * 商户经营范围，存放类型，品牌，渠道等信息
     */
    @ApiModelProperty(name = "sellerBusinessScopeRespDtos", value = "商户经营范围，存放类型，品牌，渠道等信息")
    private List<SellerBusinessScopeRespDto> sellerBusinessScopeRespDtos;

    /**
     * 商户经营区域
     */
    @ApiModelProperty(name = "sellerAreaDtoList", value = "商户经营区域")
    private List<SellerAreaDto> sellerAreaDtoList;
    /**
     * 门店Id
     */
    @ApiModelProperty(name = "shopId", value = "门店Id")
    private Long shopId;

    /**
     * 商家认证截止时间
     */
    @ApiModelProperty(name = "sellerCertificationDeadline", value = "商家认证截止时间")
    private Date sellerCertificationDeadline;
//    /**
//     * 开通时间
//     */
//    @ApiModelProperty(name = "开通时间", value = "creatTime")
//    private Date createTime;

    @ApiModelProperty(name = "isFactoryDelivery", value = "是否厂家发货")
    private Integer isFactoryDelivery;

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getContactPerson() {
        return contactPerson;
    }

    public void setContactPerson(String contactPerson) {
        this.contactPerson = contactPerson;
    }

    public String getContactMobile() {
        return contactMobile;
    }

    public void setContactMobile(String contactMobile) {
        this.contactMobile = contactMobile;
    }

    public String getContactPhone() {
        return contactPhone;
    }

    public void setContactPhone(String contactPhone) {
        this.contactPhone = contactPhone;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getBusinessLicenseA() {
        return businessLicenseA;
    }

    public void setBusinessLicenseA(String businessLicenseA) {
        this.businessLicenseA = businessLicenseA;
    }

    public String getBusinessLicenseB() {
        return businessLicenseB;
    }

    public void setBusinessLicenseB(String businessLicenseB) {
        this.businessLicenseB = businessLicenseB;
    }

    public String getIdCardA() {
        return idCardA;
    }

    public void setIdCardA(String idCardA) {
        this.idCardA = idCardA;
    }

    public String getIdCardB() {
        return idCardB;
    }

    public void setIdCardB(String idCardB) {
        this.idCardB = idCardB;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Long getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
    }

    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public List<SellerBusinessScopeRespDto> getSellerBusinessScopeRespDtos() {
        return sellerBusinessScopeRespDtos;
    }

    public void setSellerBusinessScopeRespDtos(List<SellerBusinessScopeRespDto> sellerBusinessScopeRespDtos) {
        this.sellerBusinessScopeRespDtos = sellerBusinessScopeRespDtos;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public Long getTenantId() {
		return tenantId;
	}

	public void setTenantId(Long tenantId) {
		this.tenantId = tenantId;
	}

	public String getManager() {
        return manager;
    }

    public void setManager(String manager) {
        this.manager = manager;
    }

/*    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+08:00"
    )
    public Date getCreateTime() {
        return createTime;
    }

    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+08:00"
    )
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }*/

    public List<SellerAreaDto> getSellerAreaDtoList() {
        return sellerAreaDtoList;
    }

    public void setSellerAreaDtoList(List<SellerAreaDto> sellerAreaDtoList) {
        this.sellerAreaDtoList = sellerAreaDtoList;
    }

    public Long getCommanderInfoId() {
        return commanderInfoId;
    }

    public void setCommanderInfoId(Long commanderInfoId) {
        this.commanderInfoId = commanderInfoId;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public Date getSellerCertificationDeadline() {
        return sellerCertificationDeadline;
    }

    public void setSellerCertificationDeadline(Date sellerCertificationDeadline) {
        this.sellerCertificationDeadline = sellerCertificationDeadline;
    }

    public Integer getIsFactoryDelivery() {
        return isFactoryDelivery;
    }

    public void setIsFactoryDelivery(Integer isFactoryDelivery) {
        this.isFactoryDelivery = isFactoryDelivery;
    }
}
