package com.dtyunxi.yundt.cube.center.shop.api.dto.response;

import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDirFreightDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopTransportPartnerDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

@ApiModel(value = "ShopBaseDto", description = "店铺基本信息Dto")
public class ShopBaseDto extends BaseVo {

    /**
     * 店铺ID
     */
    @ApiModelProperty(name = "id", value = "店铺ID")
    private Long id;

    /**
     * 租户ID
     */
    @ApiModelProperty(name = "tenantId", value = "租户ID")
    private Long tenantId;
    /**
     * 实例ID
     */
    @ApiModelProperty(name = "instanceId", value = "实例ID")
    private Long instanceId;
    /**
     * 商户ID
     */
    @ApiModelProperty(name = "sellerId", value = "商户ID，必填", required = true)
    private Long sellerId;

    /**
     * 店铺编码
     */
    @ApiModelProperty(name = "code", value = "店铺编码，选填。如果没有提供，店铺中心生成分布式ID作为店铺编码")
    private String code;

    /**
     * 店铺名称
     */
    @ApiModelProperty(name = "name", value = "店铺名称，必填", required = true)
    private String name;

    /**
     * 店铺类型：1 线上业务, 2 O2O业务
     */
    @ApiModelProperty(name = "type", value = "店铺类型：1 线上业务, 2 O2O业务")
    private Long type;


    // todo 该属性不应该加在这里
    @ApiModelProperty(name = "shopDirFreightDtoList", value = "按类目统一的类目运费关联list")
    private List<ShopDirFreightDto> shopDirFreightDtoList;
    /**
     * 运营类型：1-直营；2- 加盟
     */
    @ApiModelProperty(name = "manageType", value = "运营类型：1-直营；2- 加盟")
    private Integer manageType;

    /**
     * 业务类型
     */
    @ApiModelProperty(name = "businessType", value = "业务类型: 1 快递 , 2 O2O(同城配送/到店自提)", required = true)
    private Integer businessType;

    /**
     * 店铺等级
     */
    @ApiModelProperty(name = "level", value = "店铺等级，必填")
    private Integer level;

    /**
     * 联系人
     */
    @ApiModelProperty(name = "contactPerson", value = "联系人，选填")
    private String contactPerson;

    /**
     * 联系电话
     */
    @ApiModelProperty(name = "contactPhone", value = "联系电话，选填")
    private String contactPhone;

    /**
     * url地址
     */
    @ApiModelProperty(name = "shopUrl", value = "url地址，必填")
    @NotNull(message = "url地址不允许为空")
    private String shopUrl;

    /**
     * 状态：NORMAL正常 BANNED封禁 CORRECTION整改
     */
    @ApiModelProperty(name = "status", value = "状态，必填：NORMAL正常 BANNED封禁 CORRECTION整改")
    private String status;

    /**
     * 组织code
     */
    @ApiModelProperty(name = "organizationCode", value = "组织code")
    private String organizationCode;

    /**
     * 组织id
     */
    @ApiModelProperty(name = "organizationId", value = "组织id")
    private Long organizationId;

    /**
     * 组织名称
     */
    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;

    /**
     * 省份编码
     */
    @ApiModelProperty(name = "provinceCode", value = "省份编码，选填")
    private String provinceCode;

    /**
     * 地市编码
     */
    @ApiModelProperty(name = "cityCode", value = "地市编码，选填")
    private String cityCode;

    /**
     * 区编码
     */
    @ApiModelProperty(name = "countyCode", value = "区编码，选填")
    private String countyCode;

    /**
     * 街道编码
     */
    @ApiModelProperty(name = "streetCode", value = "街道编码，选填")
    private String streetCode;

    /**
     * 地址
     */
    @ApiModelProperty(name = "address", value = "地址，选填")
    private String address;


    /**
     * 店铺地址坐标：x，y
     */
    @ApiModelProperty(name = "geo", value = "地址坐标：x，y，选填")
    private String geo;

    /**
     * 店铺简介
     */
    @ApiModelProperty(name = "shopIntroduction", value = "店铺简介，选填")
    private String shopIntroduction;

    /**
     * 店铺logo
     */
    @ApiModelProperty(name = "logo", value = "店铺logo，选填")
    private String logo;

    /**
     * 店铺支持的物流方式
     */
    @ApiModelProperty(name = "deliveryType", value = "店铺支持的物流方式")
    private String deliveryType;

    @ApiModelProperty(name = "cityDelivery", value = "是否开启同城配送")
    private Boolean cityDelivery;

    @ApiModelProperty(name = "selfPickUp", value = "是否开启自提")
    private Boolean selfPickUp;

    @ApiModelProperty(name = "autoReceive", value = "是否开启自动接单")
    private Boolean autoReceive;

    /**
     * 工作时间
     */
    @ApiModelProperty(name = "workTime", value = "工作时间，选填")
    private String workTime;

    /**
     * 店铺ID
     */
    @ApiModelProperty(name = "selfId", value = "店铺ID")
    private Long selfId;

    /**
     * 创建时间
     */
    @ApiModelProperty(name = "createTime", value = "创建时间")
    private Date createTime;

    /**
     * 修改人
     */
    @ApiModelProperty(name = "updatePerson", value = "修改人")
    private String updatePerson;

    /**
     * 修改时间
     */
    @ApiModelProperty(name = "updateTime", value = "修改时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;


    /**
     * 扩展字段，存放json
     */
    @ApiModelProperty(name = "extension", value = "扩展字段，存放json，选填")
    private String extension;

    /**
     * 所属人ID
     */
    @ApiModelProperty(name = "owner", value = "所属人ID，选填")
    private Long owner;


    /**
     * 店铺是否已经下载过小程序码：1是，0否
     */
    @ApiModelProperty(name = "isWxacodeDownload", value = "店铺是否已经下载过小程序码：1是，0否")
    private Integer isWxacodeDownload;


    @ApiModelProperty(name = "serviceTel", value = "客服电话")
    private String serviceTel;
    @ApiModelProperty(name = "freightTemplateId", value = "运费模板id")
    private Long freightTemplateId;

    /**
     * 运费模板名称
     */
    @ApiModelProperty(name = "freightTemplateName", value = "运费模板名称")
    private String freightTemplateName;

    /**
     * 优先使用店铺运费模板:0 否1 是
     */
    @ApiModelProperty(name = "isFreightFirst", value = "运费模板id")
    private Integer isFreightFirst;
    @ApiModelProperty(name = "freightMailType", value = "计算邮费类型：")
    private Integer freightMailType;

    /**
     * 运费计算规则: 0 最大值 1 叠加计算
     */
    @ApiModelProperty(name = "freightCountType", value = "运费计算类型")
    private Integer freightCountType;

    /**
     * 身份证号码
     */
    @ApiModelProperty(name = "idCard", value = "身份证号码")
    private String idCard;


    @ApiModelProperty("收款 方式(商家收款:SHOP_RECEIVE)")
    private String collectionTypes;

    @ApiModelProperty(name = "shopWarehouseIds", value = "仓库ID")
    private List<Long> shopWarehouseIds;


    @ApiModelProperty(name = "transportPartnerDtoList", value = "配送方信息")
    private List<ShopTransportPartnerDto> transportPartnerDtoList;

    @ApiModelProperty(name = "isFactoryDelivery", value = "是否厂家发货")
    private Integer isFactoryDelivery;

    public String getCollectionTypes() {
        return collectionTypes;
    }

    public void setCollectionTypes(String collectionTypes) {
        this.collectionTypes = collectionTypes;
    }

    public List<Long> getShopWarehouseIds() {
        return shopWarehouseIds;
    }

    public void setShopWarehouseIds(List<Long> shopWarehouseIds) {
        this.shopWarehouseIds = shopWarehouseIds;
    }

    public List<ShopTransportPartnerDto> getTransportPartnerDtoList() {
        return transportPartnerDtoList;
    }

    public void setTransportPartnerDtoList(List<ShopTransportPartnerDto> transportPartnerDtoList) {
        this.transportPartnerDtoList = transportPartnerDtoList;
    }

    public String getIdCard() {
        return idCard;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }

    public Integer getFreightMailType() {
        return freightMailType;
    }

    public void setFreightMailType(Integer freightMailType) {
        this.freightMailType = freightMailType;
    }

    public Long getFreightTemplateId() {
        return freightTemplateId;
    }

    public void setFreightTemplateId(Long freightTemplateId) {
        this.freightTemplateId = freightTemplateId;
    }

    public String getFreightTemplateName() {
        return freightTemplateName;
    }

    public void setFreightTemplateName(String freightTemplateName) {
        this.freightTemplateName = freightTemplateName;
    }

    public Integer getIsFreightFirst() {
        return isFreightFirst;
    }

    public void setIsFreightFirst(Integer isFreightFirst) {
        this.isFreightFirst = isFreightFirst;
    }

    public Integer getFreightCountType() {
        return freightCountType;
    }

    public void setFreightCountType(Integer freightCountType) {
        this.freightCountType = freightCountType;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getType() {
        return type;
    }

    public void setType(Long type) {
        this.type = type;
    }

    public Integer getManageType() {
        return manageType;
    }

    public void setManageType(Integer manageType) {
        this.manageType = manageType;
    }

    public Integer getBusinessType() {
        return businessType;
    }

    public void setBusinessType(Integer businessType) {
        this.businessType = businessType;
    }

    public Integer getLevel() {
        return level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public String getContactPerson() {
        return contactPerson;
    }

    public void setContactPerson(String contactPerson) {
        this.contactPerson = contactPerson;
    }

    public String getContactPhone() {
        return contactPhone;
    }

    public void setContactPhone(String contactPhone) {
        this.contactPhone = contactPhone;
    }

    public String getShopUrl() {
        return shopUrl;
    }

    public void setShopUrl(String shopUrl) {
        this.shopUrl = shopUrl;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getOrganizationCode() {
        return organizationCode;
    }

    public void setOrganizationCode(String organizationCode) {
        this.organizationCode = organizationCode;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public String getProvinceCode() {
        return provinceCode;
    }

    public void setProvinceCode(String provinceCode) {
        this.provinceCode = provinceCode;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getCountyCode() {
        return countyCode;
    }

    public void setCountyCode(String countyCode) {
        this.countyCode = countyCode;
    }

    public String getStreetCode() {
        return streetCode;
    }

    public void setStreetCode(String streetCode) {
        this.streetCode = streetCode;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getGeo() {
        return geo;
    }

    public void setGeo(String geo) {
        this.geo = geo;
    }

    public String getShopIntroduction() {
        return shopIntroduction;
    }

    public void setShopIntroduction(String shopIntroduction) {
        this.shopIntroduction = shopIntroduction;
    }

    public String getLogo() {
        return logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public String getDeliveryType() {
        return deliveryType;
    }

    public void setDeliveryType(String deliveryType) {
        this.deliveryType = deliveryType;
    }

    public Boolean getCityDelivery() {
        return cityDelivery;
    }

    public void setCityDelivery(Boolean cityDelivery) {
        this.cityDelivery = cityDelivery;
    }

    public Boolean getSelfPickUp() {
        return selfPickUp;
    }

    public void setSelfPickUp(Boolean selfPickUp) {
        this.selfPickUp = selfPickUp;
    }

    public String getWorkTime() {
        return workTime;
    }

    public void setWorkTime(String workTime) {
        this.workTime = workTime;
    }

    public Long getSelfId() {
        return selfId;
    }

    public void setSelfId(Long selfId) {
        this.selfId = selfId;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getUpdatePerson() {
        return updatePerson;
    }

    public void setUpdatePerson(String updatePerson) {
        this.updatePerson = updatePerson;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getExtension() {
        return extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public Long getOwner() {
        return owner;
    }

    public void setOwner(Long owner) {
        this.owner = owner;
    }

    public Integer getIsWxacodeDownload() {
        return isWxacodeDownload;
    }

    public void setIsWxacodeDownload(Integer isWxacodeDownload) {
        this.isWxacodeDownload = isWxacodeDownload;
    }

    public String getServiceTel() {
        return serviceTel;
    }

    public void setServiceTel(String serviceTel) {
        this.serviceTel = serviceTel;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public Boolean getAutoReceive() {
        return autoReceive;
    }

    public void setAutoReceive(Boolean autoReceive) {
        this.autoReceive = autoReceive;
    }

    public List<ShopDirFreightDto> getShopDirFreightDtoList() {
        return shopDirFreightDtoList;
    }

    public void setShopDirFreightDtoList(List<ShopDirFreightDto> shopDirFreightDtoList) {
        this.shopDirFreightDtoList = shopDirFreightDtoList;
    }

    public Integer getIsFactoryDelivery() {
        return isFactoryDelivery;
    }

    public void setIsFactoryDelivery(Integer isFactoryDelivery) {
        this.isFactoryDelivery = isFactoryDelivery;
    }
}
