package com.dtyunxi.yundt.cube.center.shop.api.dto.response.freight;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.List;

/**
 * 运费规则
 *
 * @author 本参
 * @since 3.14.1.0
 */
@ApiModel(value = "FreightRuleRespDto", description = "运费规则")
public class FreightRuleRespDto extends RuleAreaBase {

    /**
     * 起始 重量/件数/体积/距离
     */
    @ApiModelProperty(name = "firstValue", value = "起始 重量/件数/体积/距离")
    private BigDecimal firstValue;

    /**
     * 起始价格
     */
    @ApiModelProperty(name = "firstFreight", value = "起始价格")
    private BigDecimal firstFreight;

    /**
     * 每超出 重量/件数/体积/距离/金额
     */
    @ApiModelProperty(name = "continueValue", value = "每超出 重量/件数/体积/距离/金额")
    private BigDecimal continueValue;

    /**
     * 每超出 价格
     */
    @ApiModelProperty(name = "continueFreight", value = "每超出 价格")
    private BigDecimal continueFreight;

    /**
     * 固定运费
     */
    @ApiModelProperty(name = "fixedCost", value = "固定运费")
    private BigDecimal fixedCost;

    public BigDecimal getFirstValue() {
        return firstValue;
    }

    public void setFirstValue(BigDecimal firstValue) {
        this.firstValue = firstValue;
    }

    public BigDecimal getFirstFreight() {
        return firstFreight;
    }

    public void setFirstFreight(BigDecimal firstFreight) {
        this.firstFreight = firstFreight;
    }

    public BigDecimal getContinueValue() {
        return continueValue;
    }

    public void setContinueValue(BigDecimal continueValue) {
        this.continueValue = continueValue;
    }

    public BigDecimal getContinueFreight() {
        return continueFreight;
    }

    public void setContinueFreight(BigDecimal continueFreight) {
        this.continueFreight = continueFreight;
    }

    public BigDecimal getFixedCost() {
        return fixedCost;
    }

    public void setFixedCost(BigDecimal fixedCost) {
        this.fixedCost = fixedCost;
    }


}
