package com.dtyunxi.yundt.cube.center.shop.api.dto.response.freight;

import com.dtyunxi.yundt.cube.center.shop.api.dto.response.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * 运费模板简要信息
 *
 * @author 本参
 * @since 3.14.1.0
 */
@ApiModel(value = "FreightTemplateSimpleRespDto", description = "运费模板")
public class FreightTemplateSimpleRespDto extends BaseRespDto {

    /**
     * 模板ID
     */
    @ApiModelProperty(name = "id", value = "模板ID，新增时候该字段不需要赋值 修改需要赋值")
    private String id;

    /**
     * 运费模板编号
     */
    @NotEmpty(message = "运费模板编号不能为空")
    @ApiModelProperty(name = "code", value = "运费模板编号")
    private String code;

    /**
     * 运费模板名称
     */
    @NotEmpty(message = "运费模板名称不能为空")
    @ApiModelProperty(name = "name", value = "运费模板名称")
    private String name;

    /**
     * 起送价格
     * 默认为0
     */
    @ApiModelProperty(name = "startingPric", value = "起送价格 默认为0")
    private BigDecimal startingPric = BigDecimal.ZERO;

    /**
     * 计费方式
     * 0 重量；
     * 1 件数；
     * 2 体积；
     * 3 距离；
     * 4 金额【固定运费】
     */
    @NotNull(message = "计费方式不能为空")
    @ApiModelProperty(name = "freightType", value = "计费方式：0 重量；1 件数；2 体积；3 距离；4 金额【固定运费】")
    private Byte freightType;

    /**
     * 是否启用免运费规则
     * 0不启用（默认）
     * 1启用
     */
    @ApiModelProperty(name = "freeFreight", value = "是否启用免运费规则 0不启用（默认）1启用")
    private Byte freeFreight = (byte) 0;

    /**
     * 启用/禁用状态
     * 0 禁用
     * 1 启用
     */
    private Byte state;

    @ApiModelProperty(name = "organizationId", value = "组织ID")
    @NotNull(message = "必须选择一个组织")
    private Long organizationId;

    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;

    /**
     * 备注
     */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BigDecimal getStartingPric() {
        return startingPric;
    }

    public void setStartingPric(BigDecimal startingPric) {
        this.startingPric = startingPric;
    }

    public Byte getFreightType() {
        return freightType;
    }

    public void setFreightType(Byte freightType) {
        this.freightType = freightType;
    }

    public Byte getFreeFreight() {
        return freeFreight;
    }

    public void setFreeFreight(Byte freeFreight) {
        this.freeFreight = freeFreight;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Byte getState() {
        return state;
    }

    public void setState(Byte state) {
        this.state = state;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }
}
