package com.dtyunxi.yundt.cube.center.shop.api.enums;


/**
 * 经营范围类型
 *
 * @author sumo
 * @date 2021/7/23
 */
public enum ScopeBusinessType   {

    /**品牌:2  skuId:3 分类:4  区域:5  排除skuId:6
     * 品牌:2  skuId:3 分类:4
     */
    BRAND(2, "品牌"),
    SKU_ID(3, "skuId"),
    DIR(4, "分类"),
    AREA(5, "区域"),
    EXCEPT_SKU_ID(6, "排除skuId"),
    ;

    private Integer code;
    private String name;

    ScopeBusinessType(Integer code, String name) {
        this.code = code;
        this.name = name;
    }


    public String toName() {
        return name;
    }


    public Integer toCode() {
        return code;
    }

    public static ScopeBusinessType fromCode(String code) {
        for (ScopeBusinessType typeEnum : ScopeBusinessType.values()) {
            if (String.valueOf(typeEnum.toCode()).equals(code)) {
                return typeEnum;
            }
        }
        return null;
    }

}
