package com.dtyunxi.yundt.cube.center.shop.api.enums;

/**
 * 商家申请审核类型
 *
 * @author symo
 * @date 2021/7/20
 */
public enum SellApplyTypeEnum {

    /**
     * 新增
     */
    ADD("ADD", "新增"),
    UPDATE("UPDATE", "修改"),
    ;

    private String code;
    private String name;

    SellApplyTypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String toName() {
        return name;
    }

    public String toCode() {
        return code;
    }

    public static SellApplyTypeEnum fromCode(String code) {
        for (SellApplyTypeEnum typeEnum : SellApplyTypeEnum.values()) {
            if (typeEnum.toCode().equals(code)) {
                return typeEnum;
            }
        }
        return null;
    }

}
