/**
 * @(#)ExampleExceptionCode.java 1.0 2018-08-10
 * <p>
 * Copyright (c) 2017, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shop.api.exception;

/**
 * 描述
 *
 * @author 管春
 * @since 0.6.0
 */
public enum ShopExceptionCode {


    EMPTY_PARAM_ERROR("10010", "参数错误，请检查参数"),

    AUDITDATA_INSERT_DEFULT("3014", "审核信息添加失败"),
    AUDITDATA_DELET_DEFULT("3015", "审核信息删除失败"),
    AUDITDATA_QUERY_DEFULT("3016", "审核信息查询失败"),
    AUDITDATA_UPDATE_DEFULT("3016", "审核信息更新失败"),

    SELLER_ADD_DEFULT("3017", "开通失败"),
    SELLER_QUERY_DEFULT("3018", "查询失败"),
    SELLER_UPDATE_DEFULT("3019", "更新失败"),
    SELLER_DELETE_DEFULT("3020", "删除失败"),
    SELLERBUSINESS_ADD_DEFULT("3021", "经营区域绑定失败,找不到对应的商户"),
    SELLE_DELETE_DEFULT("3022", "商户删除失败，请先删除与商户绑定的店铺信息"),
    SELLERBUSINESS_UPDATE_DEFULT("3021", "绑定的经营区域更新失败"),
    SELLERBUSINESS_DELETE_DEFULT("3022", "删除经营区域失败"),

    SERVICE_NOT_FOUND("5000", "店铺服务不存在"),
    AREA_UPDATE_DEFULT("5001", "经营区域更新失败"),
    AREA_DELETE_DEFULT("5002", "经营区域删除失败"),
    SHOP_ADD_DEFULT("5003", "店铺开通失败"),
    SHOP_UPDATE_DEFULT("5004", "店铺更新失败"),
    SHOP_NOT_EXIST_DEFULT("5005", "店铺不存在"),
    SHOP_AUDIT_ILLEGAL("5006", "审核字段不合法"),
    SHOP_DATA_NOT_EXIST("5007", "审核数据不存在"),
    SHOP_NAME_ISEXIST("5008", "店铺名称已存在"),
    SHOP_CODE_ISEXIST("5009", "店铺编码已存在"),
    SHOP_NAME_CAN_NOT_BE_EMPTY("5010", "店铺名称不能为空"),
    SHOP_CODE_CAN_NOT_BE_EMPTY("5011", "店铺编码不能为空"),
    SHOP_NAME_WORD_ISEXIST("5012", "店铺名称不合法"),

    SHOP_USER_ISEXIST("6000", "店铺用户已经存在关联"),

    SHOP_TEMPLATE_CODE_ISEXIST("7000", "运费模板编号已存在"),
    SHOP_TEMPLATE_RELATION_SHOP("7001", "运费模板已关联店铺,不允许该操作");


    private final String code;

    private final String msg;

    private ShopExceptionCode(String val, String info) {
        this.code = val;
        this.msg = info;

    }

    public String getCode() {
        return code;
    }

    public String getMsg() {
        return msg;

    }
}
