/*
 * *
 *  * @(#)AuditDataFallBack.java 2.0.0 11/19/20, 8:45 PM
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */
package com.dtyunxi.yundt.cube.center.shop.api.fallback;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.shop.api.IAuditDataApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.AuditQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.AuditDataRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IAuditDataQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.springframework.stereotype.Component;

/**
 * @author luo.lei
 * @date 2020-11-19
 * @since 2.0.0
 */
@Component("auditDataFallBack")
public class AuditDataFallBack implements IAuditDataApi, IAuditDataQueryApi {
    @Override
    public RestResponse<Void> removeById(Long auditDataId) {
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<AuditDataRespDto> queryAuditDataByKey(@Valid @NotNull @Min(1) Long id) {
        return new RestResponse<>(null);
    }

    @Override
    public RestResponse<List<AuditDataRespDto>> queryList(AuditQueryReqDto auditQueryReqDto) {
        return new RestResponse<>(Lists.newArrayList());
    }

    @Override
    public RestResponse<PageInfo<AuditDataRespDto>> queryPage(AuditQueryReqDto auditQueryReqDto) {
        return new RestResponse<>(new PageInfo<>());
    }
}
