/*
 * *
 *  * @(#)SellerFallBack.java 2.0.0 11/19/20, 8:45 PM
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */
package com.dtyunxi.yundt.cube.center.shop.api.fallback;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.shop.api.ISellerApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.*;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerBusinessScopeRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.exception.ShopExceptionCode;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.stereotype.Component;

/**
 * @author luo.lei
 * @date 2020-11-19
 * @since 2.0.0
 */
@Component("sellerFallBack")
public class SellerFallBack implements ISellerApi, ISellerQueryApi {
    @Override
    public RestResponse<Long> addSeller(@Valid SellerReqDto sellerReqDto, boolean audit) {
        throw new BizException(ShopExceptionCode.SERVICE_NOT_FOUND.getCode(), ShopExceptionCode.SERVICE_NOT_FOUND.getMsg());
    }

    @Override
    public RestResponse<Void> modifySeller(SellerReqDto sellerReqDto, boolean needAudit) {
        throw new BizException(ShopExceptionCode.SERVICE_NOT_FOUND.getCode(), ShopExceptionCode.SERVICE_NOT_FOUND.getMsg());
    }

    @Override
    public RestResponse<Void> addSellers(@Valid List<SellerBatchReqDto> sellerReqDtos, boolean audit) {
        throw new BizException(ShopExceptionCode.SERVICE_NOT_FOUND.getCode(), ShopExceptionCode.SERVICE_NOT_FOUND.getMsg());
    }

    @Override
    public RestResponse<Long> addSellerBusinessScope(@Valid SellerBusinessScopeReqDto sellerBusinessScopeReqDto) {
        throw new BizException(ShopExceptionCode.SERVICE_NOT_FOUND.getCode(), ShopExceptionCode.SERVICE_NOT_FOUND.getMsg());
    }

    @Override
    public RestResponse<Void> modifySellerBusinessScope(SellerBusinessScopeReqDto sellerBusinessScopeReqDto) {
        throw new BizException(ShopExceptionCode.SERVICE_NOT_FOUND.getCode(), ShopExceptionCode.SERVICE_NOT_FOUND.getMsg());
    }

    @Override
    public RestResponse<Void> removeBusinessById(@NotNull(message = "ID不能为空") Long id) {
        throw new BizException(ShopExceptionCode.SERVICE_NOT_FOUND.getCode(), ShopExceptionCode.SERVICE_NOT_FOUND.getMsg());
    }

    @Override
    public RestResponse<Void> auditSeller(long auditId, long tenantId, String status, String result, String auditPerson) {
        throw new BizException(ShopExceptionCode.SERVICE_NOT_FOUND.getCode(), ShopExceptionCode.SERVICE_NOT_FOUND.getMsg());
    }

    @Override
    public RestResponse<Void> removeSellerById(@NotNull(message = "商户ID不能为空") Long id) {
        throw new BizException(ShopExceptionCode.SERVICE_NOT_FOUND.getCode(), ShopExceptionCode.SERVICE_NOT_FOUND.getMsg());
    }

    @Override
    public RestResponse<Long> addSellerArea(@Valid SellerAreaDto sellerAreaDto) {
        throw new BizException(ShopExceptionCode.SERVICE_NOT_FOUND.getCode(), ShopExceptionCode.SERVICE_NOT_FOUND.getMsg());
    }

    @Override
    public RestResponse<SellerBusinessScopeRespDto> queryBusinessScopeBySellerIdAndBusinessId(Long sellerId, Long businessId) {
        return new RestResponse<>();
    }

    @Override
    public RestResponse<SellerRespDto> queryById(@NotNull(message = "商户ID不允许为空") Long id) {

        return new RestResponse<>(defaultSeller());
    }


    private SellerRespDto defaultSeller() {
        SellerRespDto dto = new SellerRespDto();
        dto.setId(0L);
        dto.setName("默认商家");
        dto.setCode("0");
        return dto;
    }

    @Override
    public RestResponse<List<SellerRespDto>> queryByInstanceId(Long instanceId) {
        return new RestResponse<>(Lists.newArrayList(defaultSeller()));
    }

    @Override
    public RestResponse<List<SellerRespDto>> queryByTenantId(Long tenantId) {
        return new RestResponse<>(Lists.newArrayList(defaultSeller()));
    }

    @Override
    public RestResponse<List<SellerBusinessScopeRespDto>> queryBySellerId(Long sellerId) {
        return new RestResponse<>(Lists.newArrayList());
    }

    @Override
    public RestResponse<PageInfo<SellerRespDto>> queryPageSeller(SellerQueryReqDto sellerQueryReqDto) {
        return new RestResponse<>();
    }

    @Override
    public RestResponse<PageInfo<SellerRespDto>> queryPageSellerByBusinessScope(SellerQueryReqDto sellerQueryReqDto) {
        return new RestResponse<>(new PageInfo<>(Lists.newArrayList(defaultSeller())));
    }

    @Override
    public RestResponse<List<SellerRespDto>> queryList(SellerQueryReqDto sellerQueryReqDto) {
        return new RestResponse<>(Lists.newArrayList(defaultSeller()));
    }

    @Override
    public RestResponse<List<SellerRespDto>> queryByCode(String code) {
        return new RestResponse<>(Lists.newArrayList(defaultSeller()));
    }

    @Override
    public RestResponse<List<SellerRespDto>> queryListByFeign(SellerQueryReqDto sellerQueryReqDto) {
        return new RestResponse<>(Lists.newArrayList(defaultSeller()));
    }

    @Override
    public RestResponse<List<SellerAreaDto>> queryAreaBySellerId(Long sellerId) {
        return new RestResponse<>(Lists.newArrayList());
    }

    @Override
    public RestResponse<List<SellerAreaDto>> queryAreaList(SellerAreaDto sellerAreaDto) {
        return new RestResponse<>(Lists.newArrayList());
    }

    @Override
    public RestResponse<List<SellerRespDto>> queryListOnPost(SellerQueryReqDto sellerQueryReqDto) {
        return new RestResponse<>(Lists.newArrayList(defaultSeller()));
    }

    @Override
    public RestResponse<Boolean> checkSellerName(String  sellerName) {
        return new RestResponse<>(false);
    }

    @Override
    public RestResponse<Void> batchUpdateSellerDeadline(SellerCertificationDeadlineDto sellerCertificationDeadlineDto) {
        return RestResponse.VOID;
    }
}
