/*
 * *
 *  * @(#)ShopFallBack.java 2.0.0 11/19/20, 8:45 PM
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */
package com.dtyunxi.yundt.cube.center.shop.api.fallback;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.shop.api.IShopApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.*;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.FreightCountRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.enums.TransportPartnerEnum;
import com.dtyunxi.yundt.cube.center.shop.api.exception.ShopExceptionCode;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import org.springframework.stereotype.Component;

import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.util.List;
import java.util.Set;

/**
 * @author luo.lei
 * @date 2020-11-19
 * @since 2.0.0
 */
@Component("shopFallBack")
public class ShopFallBack implements IShopApi, IShopQueryApi {
    @Override
    public RestResponse<Long> addShop(ShopDto shopDto, boolean needAudit) {
        throw new BizException(ShopExceptionCode.SERVICE_NOT_FOUND.getCode(), ShopExceptionCode.SERVICE_NOT_FOUND.getMsg());
    }

    @Override
    public RestResponse<Void> addShops(@Valid List<ShopReqDto> shopDtos, boolean needAudit) {
        throw new BizException(ShopExceptionCode.SERVICE_NOT_FOUND.getCode(), ShopExceptionCode.SERVICE_NOT_FOUND.getMsg());
    }

    @Override
    public RestResponse<Void> modifyShop(ShopDto shopDto, boolean needAudit) {
        throw new BizException(ShopExceptionCode.SERVICE_NOT_FOUND.getCode(), ShopExceptionCode.SERVICE_NOT_FOUND.getMsg());
    }

    @Override
    public RestResponse<Void> modifyShopOnly(Long id, ShopReqDto shopReqDto) {
        throw new BizException(ShopExceptionCode.SERVICE_NOT_FOUND.getCode(), ShopExceptionCode.SERVICE_NOT_FOUND.getMsg());
    }

    @Override
    public RestResponse<Void> removeShop(Long id) {
        throw new BizException(ShopExceptionCode.SERVICE_NOT_FOUND.getCode(), ShopExceptionCode.SERVICE_NOT_FOUND.getMsg());
    }

    @Override
    public RestResponse<Long> addShopArea(@Valid ShopAreaDto shopAreaDto) {
        throw new BizException(ShopExceptionCode.SERVICE_NOT_FOUND.getCode(), ShopExceptionCode.SERVICE_NOT_FOUND.getMsg());
    }

    @Override
    public RestResponse<Void> modifyShopArea(@Valid ShopAreaDto shopAreaDto) {
        throw new BizException(ShopExceptionCode.SERVICE_NOT_FOUND.getCode(), ShopExceptionCode.SERVICE_NOT_FOUND.getMsg());
    }

    @Override
    public RestResponse<Void> removeShopAreaById(Long areaId) {
        throw new BizException(ShopExceptionCode.SERVICE_NOT_FOUND.getCode(), ShopExceptionCode.SERVICE_NOT_FOUND.getMsg());
    }

    @Override
    public RestResponse<Long> addShopBusinessScope(@Valid ShopBusinessScopeDto shopBusinessScopeDto) {
        throw new BizException(ShopExceptionCode.SERVICE_NOT_FOUND.getCode(), ShopExceptionCode.SERVICE_NOT_FOUND.getMsg());
    }

    @Override
    public RestResponse<Void> modifyShopBusinessScope(@Valid ShopBusinessScopeDto shopBusinessScopeDto) {
        throw new BizException(ShopExceptionCode.SERVICE_NOT_FOUND.getCode(), ShopExceptionCode.SERVICE_NOT_FOUND.getMsg());
    }

    @Override
    public RestResponse<Void> removeShopBusinessScopeById(Long shopId, Long businessId) {
        throw new BizException(ShopExceptionCode.SERVICE_NOT_FOUND.getCode(), ShopExceptionCode.SERVICE_NOT_FOUND.getMsg());
    }

    @Override
    public RestResponse<Long> addWarehouse(@Valid ShopWarehouseDto shopWarehouseDto) {
        throw new BizException(ShopExceptionCode.SERVICE_NOT_FOUND.getCode(), ShopExceptionCode.SERVICE_NOT_FOUND.getMsg());
    }

    @Override
    public RestResponse<Void> removeWarehouse(Long shopId, Long warehouseId) {
        throw new BizException(ShopExceptionCode.SERVICE_NOT_FOUND.getCode(), ShopExceptionCode.SERVICE_NOT_FOUND.getMsg());
    }

    @Override
    public RestResponse<Boolean> defineShopMemberLevel(long shopId, List<ShopMemberLevelDefineReqDto> dto) {
        throw new BizException(ShopExceptionCode.SERVICE_NOT_FOUND.getCode(), ShopExceptionCode.SERVICE_NOT_FOUND.getMsg());
    }

    @Override
    public RestResponse<Boolean> addShopMember(long shopId, ShopMemberReqDto dto) {
        throw new BizException(ShopExceptionCode.SERVICE_NOT_FOUND.getCode(), ShopExceptionCode.SERVICE_NOT_FOUND.getMsg());
    }

    @Override
    public RestResponse<Boolean> delShopMember(long shopId, long memberId) {
        throw new BizException(ShopExceptionCode.SERVICE_NOT_FOUND.getCode(), ShopExceptionCode.SERVICE_NOT_FOUND.getMsg());
    }

    @Override
    public RestResponse<Long> addShopUser(AddShopUserReqDto addShopUserReqDto) {
        throw new BizException(ShopExceptionCode.SERVICE_NOT_FOUND.getCode(), ShopExceptionCode.SERVICE_NOT_FOUND.getMsg());
    }

    @Override
    public RestResponse<Void> auditShop(@Min(1) long auditId, @Min(1) long tenantId, String status, String result, String auditPerson) {
        throw new BizException(ShopExceptionCode.SERVICE_NOT_FOUND.getCode(), ShopExceptionCode.SERVICE_NOT_FOUND.getMsg());
    }

    @Override
    public RestResponse<Boolean> defineShopLevel(@Min(1) long tenantId, @Min(1) long instanceId, @Valid List<ShopMemberLevelDefineReqDto> dto) {
        throw new BizException(ShopExceptionCode.SERVICE_NOT_FOUND.getCode(), ShopExceptionCode.SERVICE_NOT_FOUND.getMsg());
    }

    @Override
    public RestResponse<Integer> isCheckAddress(String locationX, String locationY, String shopIds) {
        return new RestResponse<>(1);
    }

    @Override
    public RestResponse<List<ShopEsDto>> queryRangeShopListByGeo(String lat, String lon, Boolean isValidRegion) {
        throw new BizException(ShopExceptionCode.SERVICE_NOT_FOUND.getCode(), ShopExceptionCode.SERVICE_NOT_FOUND.getMsg());
    }

    private ShopDto defaultShop() {
        ShopDto dto = new ShopDto();
        dto.setId(0L);
        dto.setName("默认店铺");
        dto.setSellerId(0L);
        dto.setBusinessType(1);
        dto.setCode("0");
        return dto;
    }

    private ShopBaseDto defaultBaseShop() {
        ShopBaseDto dto = new ShopBaseDto();
        dto.setId(0L);
        dto.setName("默认店铺");
        dto.setSellerId(0L);
        dto.setCode("0");
        dto.setBusinessType(1);
        return dto;
    }

    private ShopTransportPartnerDto defaultShopTransportPartner() {
        ShopTransportPartnerDto dto = new ShopTransportPartnerDto();
        dto.setPartnerCode(TransportPartnerEnum.SELF.getCode());
        dto.setPartnerName(TransportPartnerEnum.SELF.getName());
        dto.setpMerchantNo("");
        dto.setpShopNo("");
        return dto;
    }

    @Override
    public RestResponse<PageInfo<ShopDto>> queryBySellerId(long sellerId, int pageSize, int page) {
        return new RestResponse<>(new PageInfo<ShopDto>(Lists.newArrayList(defaultShop())));
    }

    @Override
    public RestResponse<List<ShopAreaDto>> queryShopAreaByShopIds(AddressAreaReqDto reqDto) {
        return new RestResponse(Lists.newArrayList());
    }

    @Override
    public RestResponse<PageInfo<ShopDto>> queryByTenantId(long tenantId, int pageSize, int page) {
        return new RestResponse<>(new PageInfo<ShopDto>(Lists.newArrayList(defaultShop())));
    }

    @Override
    public RestResponse<PageInfo<ShopDto>> queryByConditions(ShopQueryDto queryCondition, int pageSize, int page) {
        return new RestResponse<>(new PageInfo<ShopDto>(Lists.newArrayList(defaultShop())));
    }

    @Override
    public RestResponse<ShopDto> queryById(long shopId, String... enums) {
        return new RestResponse<>(defaultShop());
    }

    @Override
    public RestResponse<ShopDto> queryByCode(String code) {
        return new RestResponse<>(defaultShop());
    }

    @Override
    public RestResponse<ShopBaseDto> queryBaseById(Long shopId) {
        return new RestResponse<>(defaultBaseShop());
    }

    @Override
    public RestResponse<ShopBaseDto> queryBaseDasById(Long shopId) {
        return new RestResponse<>(defaultBaseShop());
    }

    @Override
    public RestResponse<List<ShopBaseDto>> queryBaseListByIds(@NotNull Set<Long> shopIds) {
        return new RestResponse<>(Lists.newArrayList(defaultBaseShop()));
    }

    @Override
    public RestResponse<List<ShopDto>> queryByIds(@NotNull Set<Long> shopIds) {
        return new RestResponse<>(Lists.newArrayList(defaultShop()));
    }

    @Override
    public RestResponse<List<ShopAreaDto>> queryShopAreas(ShopAreaDto shopAreaDto) {
        return new RestResponse(Lists.newArrayList());
    }

    @Override
    public RestResponse<PageInfo<ShopDto>> queryStoreShopList(ShopQueryDto queryCondition, int pageSize, int page) {
        return new RestResponse<>(new PageInfo<ShopDto>(Lists.newArrayList(defaultShop())));
    }

    @Override
    public RestResponse<FreightCountRespDto> countFreight(Long addressId, Long shopId) {
        FreightCountRespDto dto = new FreightCountRespDto();
        return new RestResponse<>(dto);
    }

    @Override
    public RestResponse<List<ShopWarehouseDto>> queryShopWarehouseByShopId(Long shopId, Integer type) {
        return new RestResponse<>(Lists.newArrayList());
    }

    @Override
    public RestResponse<List<ShopDto>> queryShopList(ShopQueryDto queryCondition) {
        return new RestResponse<>(Lists.newArrayList(defaultShop()));
    }

    @Override
    public RestResponse<List<ShopDto>> queryShopListNew(ShopQueryDto queryCondition) {
        return new RestResponse<>(Lists.newArrayList(defaultShop()));
    }

    @Override
    public RestResponse<List<ShopDto>> queryShopByCode(@Valid ShopQueryReqDto dto) {
        return new RestResponse<>(Lists.newArrayList(defaultShop()));
    }

    @Override
    public RestResponse<List<ShopTransportPartnerDto>> queryShopTransportPartner(Long shopId) {
        return new RestResponse<>(Lists.newArrayList(defaultShopTransportPartner()));
    }

    @Override
    public RestResponse<Integer> countByFreightTemplateId(Long freightTemplateId) {
        return new RestResponse<>(1);
    }

    @Override
    public RestResponse<ShopDto> queryEarliestShop() {
        return new RestResponse<>();
    }

    @Override
    public RestResponse<List<ShopDto>> shopList(ShopQueryDto queryCondition) {
        return new RestResponse<>(Lists.newArrayList(defaultShop()));
    }

    @Override
    public RestResponse<List<ShopDto>> queryByIdsOnPost(@NotNull Set<Long> shopIds) {
        return new RestResponse<>(Lists.newArrayList(defaultShop()));
    }

    @Override
    public RestResponse<Boolean> checkShopName(String shopName){
        return new RestResponse<>(false);
    }

    @Override
    public RestResponse<Boolean> checkShopCode(String shopCode){
        return new RestResponse<>(false);
    }

    @Override
    public RestResponse<PageInfo<ShopBaseDto>> queryBaseShopPage(ShopQueryDto shopQueryDto, Integer pageSize, Integer page) {
        return new RestResponse<>(new PageInfo<ShopBaseDto>(Lists.newArrayList(defaultBaseShop())));
    }

    @Override
    public RestResponse<List<ShopBaseDto>> queryBaseShopList(ShopQueryDto shopQueryDto) {
        return new RestResponse<>(Lists.newArrayList(defaultBaseShop()));
    }

    @Override
    public RestResponse<Long> countShop(ShopQueryDto shopQueryDto) {
        return new RestResponse<>(1L);
    }

    @Override
    public RestResponse<Void> modifyShopById(Long id, ShopReqDto shopReqDto) {
        throw new BizException(ShopExceptionCode.SERVICE_NOT_FOUND.getCode(), ShopExceptionCode.SERVICE_NOT_FOUND.getMsg());
    }
}
