/*
 * @(#)Audit.java 1.0 2018/9/3
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.shop.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.AuditQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.AuditDataRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.fallback.AuditDataFallBack;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;

/**
 * 待审核信息查询Api接口
 *
 * @author 华生
 * @since 1.0.0
 */
@FeignClient(contextId="src-main-com-dtyunxi-yundt-cube-center-shop-api-query-IAuditDataQueryApi", name = "${yundt.cube.center.shop.api.name:yundt-cube-center-shop}", path = "/v2/audit/data", url = "${yundt.cube.center.shop.api:}",fallback = AuditDataFallBack.class)
public interface IAuditDataQueryApi {
    /**
     * 根据ID查找审核信息
     *
     * @param id ID
     * @return {@linkplain com.dtyunxi.yundt.cube.center.shop.api.dto.response.AuditDataRespDto}
     */

    @GetMapping(value = "/query/{id}", produces = "application/json")
    @ApiOperation(value = "根据ID查找审核信息", notes = "根据ID查找审核信息")
    RestResponse<AuditDataRespDto> queryAuditDataByKey(@Valid @NotNull @Min(1) @PathVariable("id") Long id);

    /**
     * 根据条件查询审核信息列表
     *
     * @param auditQueryReqDto 查询条件请求DTO(businessId:业务ID
     *                         businessType:业务类型
     *                         status:状态(PENDING：待审核；PASS：审核通过；REFUSE：审核拒绝))
     * @return List&lt;{@linkplain com.dtyunxi.yundt.cube.center.shop.api.dto.response.AuditDataRespDto}&gt;
     */
    @GetMapping("/list")
    @ApiOperation(value = "根据条件查询审核信息列表", notes = "根据条件查询审核信息列表")
    RestResponse<List<AuditDataRespDto>> queryList(@ModelAttribute AuditQueryReqDto auditQueryReqDto);

    /**
     * 根据条件分页查询审核列表
     *
     * @param auditQueryReqDto 查询条件请求DTO(businessId:业务ID
     *                         businessType:业务类型
     *                         status:状态(PENDING：待审核；PASS：审核通过；REFUSE：审核拒绝))
     * @return PageInfo&lt;{@linkplain com.dtyunxi.yundt.cube.center.shop.api.dto.response.AuditDataRespDto}&gt;
     */
    @GetMapping("/page")
    @ApiModelProperty(value = "根据条件分页查询审核列表", notes = "根据条件分页查询审核列表")
    RestResponse<PageInfo<AuditDataRespDto>> queryPage(@ModelAttribute AuditQueryReqDto auditQueryReqDto);
}
