package com.dtyunxi.yundt.cube.center.shop.api.query;


import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.freight.FreightTemplatePageReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.freight.ShopFreightCountReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.FreightCountRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.freight.FreightTemplateRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.freight.FreightTemplateSimpleRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.fallback.FreightTemplateFallBack;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;

@FeignClient(contextId = "src-main-com-dtyunxi-yundt-cube-center-shop-api-query-IFreightTemplateQueryApi", name = "${yundt.cube.center.shop.api.name:yundt-cube-center-shop}", path = "/v1/freight/template", url = "${yundt.cube.center.shop.api:}", fallback = FreightTemplateFallBack.class)
public interface IFreightTemplateQueryApi {

    @GetMapping("/page")
    @ApiOperation(value = "根据条件分页查询运费模板基本信息列表", notes = "根据条件分页查询运费模板基本信息列表")
    RestResponse<PageInfo<FreightTemplateSimpleRespDto>> page(@ModelAttribute FreightTemplatePageReqDto pageReqDto);

    @PostMapping(value = "/freight/count")
    @ApiOperation(value = "计算运费信息", notes = "计算运费信息")
    RestResponse<FreightCountRespDto> queryCountFreight(@RequestBody ShopFreightCountReqDto shopFreightCountReqDto);

    @GetMapping("/{id}")
    @ApiOperation(value = "根据ID查询费用模板详情", notes = "根据ID查询费用模板详情")
    RestResponse<FreightTemplateRespDto> queryById(@PathVariable("id") Long id);

    @GetMapping("/more/{id}")
    @ApiOperation(value = "根据ID查询费用模板详情", notes = "根据ID查询费用模板详情")
    RestResponse<FreightTemplateRespDto> queryMoreById(@PathVariable("id") Long id);

    @GetMapping("/ids")
    @ApiOperation(value = "根据ID列表查询费用模板详情", notes = "根据ID列表查询费用模板详情")
    RestResponse<List<FreightTemplateRespDto>> queryByIds(@RequestBody List<Long> ids);


    @PostMapping(value = "batch/freight/count")
    @ApiOperation(value = "批量计算运费信息", notes = "批量计算运费信息")
    RestResponse<List<FreightCountRespDto>> queryCountFreightList(@RequestBody List<ShopFreightCountReqDto> shopFreightCountReqList);
}
