/**
 * @(#)IShopAddressQueryApi 1.0 2019/3/26
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.shop.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopAddressRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.fallback.ShopAddressFallBack;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 店铺地址管理查询接口
 *
 * @author shuangqing  2019/3/26
 */
@FeignClient(contextId="src-main-com-dtyunxi-yundt-cube-center-shop-api-query-IShopAddressQueryApi", name = "${yundt.cube.center.shop.api.name:yundt-cube-center-shop}", path = "/v2/shop/address", url = "${yundt.cube.center.shop.api:}",fallback = ShopAddressFallBack.class)
public interface IShopAddressQueryApi {
    /**
     * 根据Id查询地址信息
     *
     * @param id 主键id
     * @return 地址信息响应dto
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据Id查询地址信息", notes = "根据Id查询地址信息")
    RestResponse<ShopAddressRespDto> queryAddressById(@PathVariable("id") Long id);

    /**
     * 分页查询地址信息列表
     *
     * @param filter   ShopAddressReqDto json对象字符串
     * @param pageNum  分页页码
     * @param pageSize 分页行数
     * @return 地址信息分页列表
     */
    @GetMapping("/page")
    @ApiOperation(value = "分页查询地址信息列表", notes = "分页查询地址信息列表\n" +
            "filter对应ShopAddressReqDto,格式:\n" +
            "\n" +
            "{\n" +
            "\"shopId\":1,\n" +
            "\"sellerId\":2,\n" +
            "\"address\":\"xxx\",\n" +
            "\"instanceId\":1,\n" +
            "\"tenantId\":1\n" +
            "}")
    RestResponse<PageInfo<ShopAddressRespDto>> queryAddressByPage(@RequestParam(name = "filter", required = false) String filter,
                                                                  @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                  @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 根据shopId查询地址信息
     *
     * @param shopId 店铺id
     * @return 地址列表dto
     */
    @GetMapping("/shop/{shopId}")
    @ApiOperation(value = "根据shopId查询地址信息", notes = "根据shopId查询地址信息")
    RestResponse<List<ShopAddressRespDto>> queryAddressByShopId(@PathVariable("shopId") Long shopId);
}
