package com.dtyunxi.yundt.cube.center.shop.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDirFreightDto;
import com.dtyunxi.yundt.cube.center.shop.api.fallback.ShopFallBack;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 店铺类目运费模板关联表
 *
 * @author cijian
 * @since 1.0.0
 */
@FeignClient(contextId = "src-main-com-dtyunxi-yundt-cube-center-shop-api-query-IShopDirFreightQueryApi",
        name = "${yundt.cube.center.shop.api.name:yundt-cube-center-shop}",
        path = "/v1/shopDirFreight",
        url = "${yundt.cube.center.shop.api:}")
public interface IShopDirFreightQueryApi {

    /**
     * 根据店铺id集合查询店铺类目运费模板信息
     * @param shopIds 店铺id集合
     * @return
     */
    @PostMapping(value = "/queryByShopIds")
    @ApiOperation(value = "根据店铺id集合查询店铺类目运费模板信息", notes = "根据店铺id集合查询店铺类目运费模板信息")
    RestResponse<List<ShopDirFreightDto>> queryByShopIds(@RequestBody List<Long> shopIds);
}
