/*
 * @(#)ISubStationQueryApi.java 1.0 2020-06-01
 *
 * Copyright (c) 2017, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.shop.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SubStationDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SubStationQueryDto;
import com.dtyunxi.yundt.cube.center.shop.api.fallback.SubStationFallBack;
import com.github.pagehelper.PageInfo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 子站查询接口
 *
 * @author luo.lei
 * @since 2.0.0
 */
@FeignClient(contextId="src-main-com-dtyunxi-yundt-cube-center-shop-api-query-ISubStationQueryApi",
		name = "${yundt.cube.center.shop.api.name:yundt-cube-center-shop}", path = "/v2/sub-station", url = "${yundt.cube.center.shop.api:}",fallback = SubStationFallBack.class)
public interface ISubStationQueryApi {

    /**
     * 根据查询条件获取子站列表
     *
     * @param queryCondition 查询条件
     * @param pageSize       分页参数-页大小 不得小于1
     * @param page           分页参数-当前页 不得小于1
     * @return 带分页的子站信息，结果为空时返回空列表 {@linkplain SubStationDto}
     */
    @GetMapping("/conditions")
    RestResponse<PageInfo<SubStationDto>> queryByConditions(@ModelAttribute SubStationQueryDto queryCondition,
			@RequestParam(name = "pageSize", defaultValue = "10")      int pageSize,
			@RequestParam(name = "page",     defaultValue = "1")       int page);



	/**
	 * 根据ID查询子站信息
	 *
	 * @param id 子站ID
	 * @return   子站信息 {@linkplain SubStationDto}
	 */
	@GetMapping("/{id}")
	RestResponse<SubStationDto> queryById(@PathVariable("id") long id);
}
