/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shop.svr.rest;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.shop.api.IShopApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.AddShopUserReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopAreaDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopBusinessScopeDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopEsDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopMemberLevelDefineReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopMemberReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopWarehouseDto;
import io.swagger.annotations.Api;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5e97\u94fa\u4e2d\u5fc3\uff1a\u5e97\u94fa\u7ba1\u7406Api\u63a5\u53e3\u670d\u52a1"})
@RestController
@RequestMapping(value={"/v2/shop"})
public class ShopRest
implements IShopApi {
    @Resource(name="shopApi")
    private IShopApi shopApi;

    public RestResponse<Long> addShop(@RequestBody ShopDto shopDto, @RequestParam(value="audit") boolean needAudit) {
        return this.shopApi.addShop(shopDto, needAudit);
    }

    public RestResponse<Void> addShops(@Valid @RequestBody List<ShopReqDto> shopDtos, @RequestParam(value="audit") boolean needAudit) {
        return this.shopApi.addShops(shopDtos, needAudit);
    }

    public RestResponse<Void> modifyShop(@RequestBody ShopDto shopDto, @RequestParam(value="audit") boolean needAudit) {
        return this.shopApi.modifyShop(shopDto, needAudit);
    }

    public RestResponse<Void> modifyShopOnly(@PathVariable(value="id") Long id, @RequestBody ShopReqDto shopReqDto) {
        return this.shopApi.modifyShopOnly(id, shopReqDto);
    }

    public RestResponse<Long> addShopArea(@RequestBody ShopAreaDto shopAreaDto) {
        return this.shopApi.addShopArea(shopAreaDto);
    }

    public RestResponse<Void> modifyShopArea(@RequestBody ShopAreaDto shopAreaDto) {
        return this.shopApi.modifyShopArea(shopAreaDto);
    }

    public RestResponse<Void> removeShopAreaById(@PathVariable Long areaId) {
        return this.shopApi.removeShopAreaById(areaId);
    }

    public RestResponse<Long> addShopBusinessScope(@RequestBody ShopBusinessScopeDto shopBusinessScopeDto) {
        return this.shopApi.addShopBusinessScope(shopBusinessScopeDto);
    }

    public RestResponse<Void> modifyShopBusinessScope(@RequestBody ShopBusinessScopeDto shopBusinessScopeDto) {
        return this.shopApi.modifyShopBusinessScope(shopBusinessScopeDto);
    }

    public RestResponse<Void> removeShopBusinessScopeById(@PathVariable Long shopId, @PathVariable Long businessId) {
        return this.shopApi.removeShopBusinessScopeById(shopId, businessId);
    }

    public RestResponse<Long> addWarehouse(@RequestBody ShopWarehouseDto shopWarehouseDto) {
        return this.shopApi.addWarehouse(shopWarehouseDto);
    }

    public RestResponse<Void> removeWarehouse(@PathVariable Long shopId, @PathVariable Long warehouseId) {
        return this.shopApi.removeWarehouse(shopId, warehouseId);
    }

    public RestResponse<Void> removeShop(@PathVariable Long id) {
        return this.shopApi.removeShop(id);
    }

    public RestResponse<Long> addShopUser(@RequestBody AddShopUserReqDto addShopUserReqDto) {
        return this.shopApi.addShopUser(addShopUserReqDto);
    }

    public RestResponse<Void> auditShop(@PathVariable long auditId, @RequestParam long tenantId, @RequestParam String status, @RequestParam String result, @RequestParam String auditPerson) {
        return this.shopApi.auditShop(auditId, tenantId, status, result, auditPerson);
    }

    public RestResponse<Boolean> defineShopMemberLevel(@PathVariable long shopId, @RequestBody List<ShopMemberLevelDefineReqDto> dto) {
        return this.shopApi.defineShopMemberLevel(shopId, dto);
    }

    public RestResponse<Boolean> addShopMember(@PathVariable long shopId, @RequestBody ShopMemberReqDto dto) {
        return this.shopApi.addShopMember(shopId, dto);
    }

    public RestResponse<Boolean> delShopMember(@PathVariable long shopId, @PathVariable long memberId) {
        return this.shopApi.delShopMember(shopId, memberId);
    }

    public RestResponse<Boolean> defineShopLevel(@RequestParam(value="tenantId") long tenantId, @RequestParam(value="instanceId") long instanceId, @RequestBody List<ShopMemberLevelDefineReqDto> dtos) {
        return this.shopApi.defineShopLevel(tenantId, instanceId, dtos);
    }

    public RestResponse<Integer> isCheckAddress(@RequestParam(value="locationX") String locationX, @RequestParam(value="locationY") String locationY, @RequestParam(value="shopIds") String shopIds) {
        return this.shopApi.isCheckAddress(locationX, locationY, shopIds);
    }

    public RestResponse<List<ShopEsDto>> queryRangeShopListByGeo(@RequestParam(value="lat") String lat, @RequestParam(value="lon") String lon, @RequestParam(value="isValidRegion", required=false) Boolean isValidRegion) {
        return this.shopApi.queryRangeShopListByGeo(lat, lon, isValidRegion);
    }

    public RestResponse<Boolean> checkShopName(String shopName) {
        return this.shopApi.checkShopName(shopName);
    }

    public RestResponse<Boolean> checkShopCode(String shopCode) {
        return this.shopApi.checkShopCode(shopCode);
    }

    public RestResponse<Void> modifyShopById(Long id, ShopReqDto shopReqDto) {
        return this.shopApi.modifyShopById(id, shopReqDto);
    }
}

