/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.apiimpl.query;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.trade.api.constants.DefaultValue;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OrderTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderQueryReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.TradeItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.DeliverysItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderAddressRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderCountRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderCountTobRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDeliveryInfoRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDeliveryLogisticRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDeliveryRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderInvoiceRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.PayRecordRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.TradeItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.IOrderQueryApi;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IChannelService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderAddressService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderDeliveryInfoService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderDeliveryService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderInvoiceService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IPayService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.ITradeItemService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.imkevent.FirstPurchaseEvent;
import com.dtyunxi.yundt.cube.center.trade.biz.util.Assert;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.ChannelEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.DeliveryItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdOrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.TradeItemEo;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="orderQueryApiImpl")
public class OrderQueryApiImpl
implements IOrderQueryApi {
    @Resource
    private IOrderService orderService;
    @Resource
    private IChannelService channelService;
    @Resource
    private IOrderAddressService orderAddressService;
    @Resource
    private IOrderInvoiceService orderInvoiceService;
    @Resource
    private ITradeItemService tradeItemService;
    @Resource
    private IPayService payService;
    @Resource
    private FirstPurchaseEvent firstPurchaseEvent;
    @Autowired
    private IOrderDeliveryInfoService orderDeliveryInfoService;
    @Resource
    private IOrderDeliveryService orderDeliveryService;

    public RestResponse<OrderDetailRespDto> getOrderDetail(String tradeNo) {
        OrderEo orderEo = this.orderService.getByOrderNo(tradeNo);
        OrderDetailRespDto orderDetailRespDto = new OrderDetailRespDto();
        if (orderEo != null) {
            DtoHelper.eo2Dto((BaseEo)orderEo, (BaseVo)orderDetailRespDto);
            List<PayRecordRespDto> payRecordRespDtos = this.payService.getPayRecordRespSuccessByOrderNo(orderEo.getOrderNo());
            if (!CollectionUtils.isEmpty(payRecordRespDtos)) {
                orderDetailRespDto.setPayRecord(payRecordRespDtos.get(0));
            }
            orderDetailRespDto.setPayRecordList(payRecordRespDtos);
            List<OrderAddressRespDto> orderAddressRespDtos = this.orderAddressService.queryDtoByTradeNo(this.getOrderNo(orderEo));
            if (!CollectionUtils.isEmpty(orderAddressRespDtos)) {
                orderDetailRespDto.setDeliveryAddress(JSON.toJSONString((Object)orderAddressRespDtos.get(0)));
                orderDetailRespDto.setOrderAddress(orderAddressRespDtos.get(0));
            }
            List<OrderInvoiceRespDto> orderInvoiceRespDtos = this.orderInvoiceService.queryDtoByOrderNo(orderEo.getThirdParentOrderNo());
            orderDetailRespDto.setOrderInvoiceRespDtos(orderInvoiceRespDtos);
            List<TradeItemRespDto> tradeItemRepDtos = this.tradeItemService.queryDtoByTradeNo(orderEo.getOrderNo());
            orderDetailRespDto.setOrderItems(tradeItemRepDtos);
            if (!StringUtils.isEmpty((Object)orderEo.getSaleChannel())) {
                ChannelEo channelEo = this.channelService.queryByCode(orderEo.getSaleChannel());
                orderDetailRespDto.setSaleChannel(channelEo != null ? channelEo.getName() : orderEo.getSaleChannel());
            }
        }
        return new RestResponse((Object)orderDetailRespDto);
    }

    private String getOrderNo(OrderEo orderEo) {
        if (!StringUtils.isEmpty((Object)orderEo.getThirdParentOrderNo()) && !orderEo.getThirdParentOrderNo().equals("0")) {
            return orderEo.getThirdParentOrderNo();
        }
        if (!StringUtils.isEmpty((Object)orderEo.getParentOrderNo()) && !orderEo.getParentOrderNo().equals("0")) {
            return orderEo.getParentOrderNo();
        }
        return orderEo.getOrderNo();
    }

    public RestResponse<Integer> count(String filter) {
        Integer count = this.orderService.count(filter);
        return new RestResponse((Object)count);
    }

    public RestResponse<List<TradeItemRespDto>> countItem(OrderItemReqDto orderItemReqDto) {
        return new RestResponse(this.orderService.countItem(orderItemReqDto));
    }

    public RestResponse<BigDecimal> sumPayAmount(String filter) {
        BigDecimal bigDecimal = this.orderService.sumPayAmount(filter);
        return new RestResponse((Object)bigDecimal);
    }

    public RestResponse<Set<String>> queryRefererIdNoReply(String filter) {
        Set<String> sets = this.orderService.queryRefererIdNoReply(filter);
        return new RestResponse(sets);
    }

    public RestResponse<List<OrderRespDto>> queryAllList(String filter) {
        OrderQueryReqDto orderReqDto = (OrderQueryReqDto)JSON.parseObject((String)filter, OrderQueryReqDto.class);
        Assert.notNull((Object)orderReqDto, "filter\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)orderReqDto.getTenantId(), "\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        if (null == orderReqDto.getOrderType()) {
            orderReqDto.setIsSplit(DefaultValue.NO);
        } else if (OrderTypeEnum.CHILDREN_ORDER.getType().equals(orderReqDto.getOrderType()) || OrderTypeEnum.PARENT_ORDER.getType().equals(orderReqDto.getOrderType())) {
            orderReqDto.setIsSplit(orderReqDto.getOrderType());
        }
        List<OrderEo> orderEos = this.orderService.queryList(orderReqDto);
        ArrayList res = new ArrayList();
        DtoHelper.eoList2DtoList(orderEos, res, OrderRespDto.class);
        for (OrderRespDto order : res) {
            List<TradeItemRespDto> tradeItemRepDtos = this.tradeItemService.queryDtoByTradeNo(order.getTradeNo());
            order.setOrderItems(tradeItemRepDtos);
        }
        return new RestResponse(res);
    }

    public RestResponse<List<TradeItemReqDto>> queryOrderItemsByTradeNo(String orderNo) {
        List<TradeItemEo> tradeItemEos = this.tradeItemService.queryByTradeNo(orderNo);
        List supplierReturnList = tradeItemEos.stream().map(this::buildTradeItemReqDto).collect(Collectors.toList());
        return new RestResponse(supplierReturnList);
    }

    private TradeItemReqDto buildTradeItemReqDto(TradeItemEo tradeItemEo) {
        TradeItemReqDto tradeItemReqDto = new TradeItemReqDto();
        BeanUtils.copyProperties((Object)tradeItemEo, (Object)tradeItemReqDto);
        String extensionStr = tradeItemEo.getExtension();
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)extensionStr)) {
            JSONObject json = JSON.parseObject((String)extensionStr);
            Object imgPath = json.get((Object)"imgPath");
            tradeItemReqDto.setPath((String)imgPath);
        }
        return tradeItemReqDto;
    }

    public RestResponse<List<OrderRespDto>> queryList(Long tenantId, Long instanceId, String userSrc, String userId, String bizStatus) {
        OrderEo orderEo = new OrderEo();
        orderEo.setUserSrc(userSrc);
        orderEo.setUserId(userId);
        orderEo.setBizStatus(bizStatus);
        orderEo.setIsSplit(DefaultValue.NO);
        List<OrderEo> orderEos = this.orderService.queryList(orderEo);
        ArrayList res = new ArrayList();
        DtoHelper.eoList2DtoList(orderEos, res, OrderRespDto.class);
        for (OrderRespDto order : res) {
            List<TradeItemRespDto> tradeItemRepDtos = this.tradeItemService.queryDtoByTradeNo(order.getTradeNo());
            order.setOrderItems(tradeItemRepDtos);
        }
        return new RestResponse(res);
    }

    public RestResponse<PageInfo<OrderRespDto>> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        OrderQueryReqDto orderQueryReq = (OrderQueryReqDto)JSON.parseObject((String)filter, OrderQueryReqDto.class);
        return new RestResponse(this.orderService.queryByPageForResp(orderQueryReq, pageNum, pageSize));
    }

    public RestResponse<Boolean> isFirstPurchase(Long userId, String tradeNo) {
        String firstTradeNo = this.firstPurchaseEvent.getFirstPurchaseTradeNo(userId.toString());
        return new RestResponse((Object)tradeNo.equals(firstTradeNo));
    }

    public RestResponse<OrderCountRespDto> queryOrderCount(String filter) {
        OrderCountRespDto orderCountRespDto = new OrderCountRespDto();
        OrderQueryReqDto orderQueryReq = (OrderQueryReqDto)JSON.parseObject((String)filter, OrderQueryReqDto.class);
        if (orderQueryReq != null) {
            orderCountRespDto = this.orderService.queryOrderCount(orderQueryReq);
        }
        return new RestResponse((Object)orderCountRespDto);
    }

    public RestResponse<OrderCountTobRespDto> queryOrderCountTob(String filter) {
        OrderCountTobRespDto orderCountTobRespDto = new OrderCountTobRespDto();
        OrderQueryReqDto orderQueryReq = (OrderQueryReqDto)JSON.parseObject((String)filter, OrderQueryReqDto.class);
        if (orderQueryReq != null) {
            orderCountTobRespDto = this.orderService.queryOrderCountTob(orderQueryReq);
        }
        return new RestResponse((Object)orderCountTobRespDto);
    }

    public RestResponse<OrderCountTobRespDto> queryOrderCountTobPost(OrderQueryReqDto orderQueryReq) {
        return new RestResponse((Object)this.orderService.queryOrderCountTob(orderQueryReq));
    }

    public RestResponse<Integer> countUserOrderItem(OrderItemReqDto orderItemReqDto) {
        Integer count = 0;
        List<OrderItemRespDto> orderItemRespDtoList = this.tradeItemService.queryUserOrderItem(orderItemReqDto);
        if (!CollectionUtils.isEmpty(orderItemRespDtoList)) {
            List<String> orderNoList = orderItemRespDtoList.stream().map(OrderItemRespDto::getOrderNo).distinct().collect(Collectors.toList());
            List paidOrderNoList = this.orderService.queryByTradeNos(orderNoList).stream().filter(order -> !Arrays.asList("WAIT_PAY", "CANCEL").contains(order.getOrderTradeStatus())).map(StdOrderEo::getOrderNo).collect(Collectors.toList());
            List list = orderItemRespDtoList.stream().filter(dto -> paidOrderNoList.contains(dto.getOrderNo())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(list)) {
                count = list.stream().mapToInt(OrderItemRespDto::getItemNum).sum();
            }
        }
        return new RestResponse((Object)count);
    }

    public RestResponse<OrderDeliveryInfoRespDto> queryOrderDeliveryInfo(String orderNo) {
        OrderDeliveryInfoRespDto orderDeliveryInfoRespDto = this.orderDeliveryInfoService.queryOrderDeliveryInfo(orderNo);
        return new RestResponse((Object)orderDeliveryInfoRespDto);
    }

    public RestResponse<List<OrderDeliveryLogisticRespDto>> queryOrderDeliveryLogistic(String orderNo) {
        return new RestResponse(this.orderDeliveryInfoService.queryOrderDeliveryLogistic(orderNo));
    }

    public RestResponse<List<DeliverysItemRespDto>> queryDeliveryItemsByOrderNo(String orderNo) {
        List<String> deliveryNos;
        List<DeliveryItemEo> deliveryItemEos;
        ArrayList deliverysItemRespDtos = new ArrayList();
        List<OrderDeliveryRespDto> orderDeliveryRespDtos = this.orderDeliveryService.queryOrderDeliveryByOrderNo(orderNo);
        if (!CollectionUtils.isEmpty(orderDeliveryRespDtos) && !CollectionUtils.isEmpty(deliveryItemEos = this.orderDeliveryService.queryListByDeliveryNos(deliveryNos = orderDeliveryRespDtos.stream().map(OrderDeliveryRespDto::getDeliveryNo).collect(Collectors.toList())))) {
            DtoHelper.eoList2DtoList(deliveryItemEos, deliverysItemRespDtos, DeliverysItemRespDto.class);
        }
        return new RestResponse(deliverysItemRespDtos);
    }

    public RestResponse<Date> getFirstPlaceOrderByCustomerId(Long customerId) {
        return new RestResponse((Object)this.orderService.getFirstPlaceOrderByCustomerId(customerId));
    }
}

