/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.apiimpl.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.TrolleyItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.TrolleyReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.TrolleyItemRepDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.TrolleyRepDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.ITrolleyQueryApi;
import com.dtyunxi.yundt.cube.center.trade.biz.service.ITrolleyItemService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.ITrolleyService;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.TrolleyEo;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestParam;

@Service(value="trolleyQueryApiImpl")
public class TrolleyQueryApiImpl
implements ITrolleyQueryApi {
    @Resource
    private ITrolleyService trolleyService;
    @Resource
    private ITrolleyItemService trolleyItemService;

    public RestResponse<List<TrolleyItemRepDto>> queryTrolleyItems(TrolleyReqDto trolleyReqDto) {
        return new RestResponse(this.trolleyItemService.queryTrolleyItems(trolleyReqDto));
    }

    public RestResponse<PageInfo<TrolleyItemRepDto>> queryTrolleyItems(Long trolleyId, Integer pageNum, Integer pageSize) {
        PageInfo<TrolleyItemRepDto> pageInfo = this.trolleyItemService.queryTrolleyItems(trolleyId, pageNum, pageSize);
        return new RestResponse(pageInfo);
    }

    public RestResponse<List<TrolleyRepDto>> getTrolleyList(@RequestParam(name="tenantId") Long tenantId, @RequestParam(name="instanceId", required=false) Long instanceId, @RequestParam(name="userSrc") String userSrc, @RequestParam(name="userSerial") String userSerial, @RequestParam(name="trolleyType") String trolleyType, @RequestParam(name="isCreate") Integer isCreate) {
        TrolleyEo trolley = new TrolleyEo();
        trolley.setUserSrc(userSrc);
        trolley.setUserSerial(userSerial);
        trolley.setTrolleyType(trolleyType);
        return new RestResponse(this.trolleyService.getTrolleyList(trolley, isCreate));
    }

    public RestResponse<TrolleyRepDto> getTrolley(Long tenantId, Long instanceId, String userSrc, String userSerial, String trolleyType, Integer isCreate) {
        TrolleyEo trolley = new TrolleyEo();
        trolley.setUserSrc(userSrc);
        trolley.setUserSerial(userSerial);
        trolley.setTrolleyType(trolleyType);
        TrolleyEo result = this.trolleyService.get(trolley, isCreate);
        TrolleyRepDto trolleyRepDto = new TrolleyRepDto();
        if (result == null) {
            return new RestResponse(null);
        }
        BeanUtils.copyProperties((Object)result, (Object)trolleyRepDto);
        return new RestResponse((Object)trolleyRepDto);
    }

    public RestResponse<List<TrolleyItemRepDto>> queryTrolleyItems(TrolleyItemReqDto trolleyItemReqDto) {
        return new RestResponse(this.trolleyItemService.queryTrolleyItems(trolleyItemReqDto));
    }

    public RestResponse<TrolleyItemRepDto> queryTrolleyItem(Long id) {
        return new RestResponse((Object)this.trolleyItemService.queryTrolleyItem(id));
    }
}

