/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.flow.action;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.enhance.flow.ActionNode;
import com.dtyunxi.cube.enhance.flow.ActionNodeComponent;
import com.dtyunxi.cube.enhance.flow.ActionResult;
import com.dtyunxi.cube.enhance.flow.IFlowEntity;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.yundt.cube.center.payment.dto.notify.PayOrderNotifyRequest;
import com.dtyunxi.yundt.cube.center.trade.api.constants.PayStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.PayTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.PayMethodReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.PayReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SubOrderPayReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.exception.TradeExceptionCode;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.action.IOrderAction;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.utils.TradeUtil;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.OrderPayedEvent;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.PayNotifyResultInput;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.producer.IntegralOrderPayProducer;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.producer.MarketOrderTradeStatusProducer;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.vo.IntegralOrderPayMessageVo;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IPayService;
import com.dtyunxi.yundt.cube.center.trade.biz.util.Assert;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.PayRecordDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.PayRecordEo;
import com.dtyunxi.yundt.cube.center.trade.engine.TradeEngine;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ActionNodeComponent
@Deprecated
public class PayRecordAction {
    private static final Logger logger = LoggerFactory.getLogger(PayRecordAction.class);
    private static final String PAY_NOTIFY_STATUS_SUCC = "S";
    @Resource
    private IOrderService orderService;
    @Resource
    private IPayService payService;
    @Resource
    private PayRecordDas payRecordDas;
    @Autowired
    OrderDas orderDas;
    @Resource
    private IOrderAction iOrderAction;
    @Resource
    private MarketOrderTradeStatusProducer marketOrderTradeStatusProducer;
    @Resource
    private IntegralOrderPayProducer integralOrderPayProducer;
    private final String CLASS_FULL_NAME = this.getClass().getCanonicalName();

    @ActionNode(entity=PayRecordEo.class, name="\u521b\u5efa\u652f\u4ed8\u5355", isStart=true, results={@ActionResult(code="ACCEPT", desc="\u5df2\u63a5\u53d7"), @ActionResult(code="SUCCESS", desc="\u6210\u529f"), @ActionResult(code="FAIL", desc="\u5931\u8d25"), @ActionResult(code="ERROR", desc="\u7cfb\u7edf\u5f02\u5e38")})
    public String create(PayMethodReqDto payMethodReqDto) {
        String string;
        Object subOrderPayReqDtoList;
        List<OrderEo> orderEoList;
        String curActionNode = this.CLASS_FULL_NAME + "#create";
        if ("2".equals(payMethodReqDto.getIsDefined())) {
            Assert.notNull((Object)payMethodReqDto.getStoreId(), "storeId\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.notNull((Object)payMethodReqDto.getAppId(), "appId\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.notNull((Object)payMethodReqDto.getAppName(), "appName\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OrderEo orderEo = null;
        BigDecimal payAmount = BigDecimal.ZERO;
        Integer integral = 0;
        String orderNo = payMethodReqDto.getOrderNo();
        if (StringUtils.isNotEmpty((CharSequence)orderNo)) {
            orderEo = this.orderService.queryByOrderNo(payMethodReqDto.getOrderNo());
            payMethodReqDto.setInstanceId(orderEo.getInstanceId());
            payMethodReqDto.setTenantId(orderEo.getTenantId());
            TradeEngine.validate((IFlowEntity)orderEo, curActionNode);
            if (payMethodReqDto.getIsAgent() == null) {
                payMethodReqDto.setIsAgent(Integer.valueOf(0));
            }
            if (StringUtils.isEmpty((CharSequence)payMethodReqDto.getUserId())) {
                if (payMethodReqDto.getIsAgent().equals(0)) {
                    payMethodReqDto.setUserId(orderEo.getUserId());
                } else {
                    payMethodReqDto.setUserId("");
                }
                if (StringUtils.isEmpty((CharSequence)payMethodReqDto.getUserSrc())) {
                    if (payMethodReqDto.getIsAgent().equals(0)) {
                        payMethodReqDto.setUserSrc(orderEo.getUserSrc());
                    } else {
                        payMethodReqDto.setUserSrc("");
                    }
                }
            }
            payAmount = orderEo.getPayAmount();
            integral = orderEo.getIntegral();
        }
        if (CollectionUtils.isNotEmpty(orderEoList = this.orderService.getByParentOrderNo(orderNo))) {
            payAmount = BigDecimal.ZERO;
            subOrderPayReqDtoList = new ArrayList(orderEoList.size());
            for (OrderEo orderEo2 : orderEoList) {
                SubOrderPayReqDto subOrderPayReqDto3 = new SubOrderPayReqDto();
                subOrderPayReqDto3.setTradeNo(orderEo2.getTradeNo());
                subOrderPayReqDto3.setCloseTime(payMethodReqDto.getCloseTime());
                subOrderPayReqDtoList.add(subOrderPayReqDto3);
            }
            payMethodReqDto.setSubOrderPayReqDtos((List)subOrderPayReqDtoList);
        }
        if (CollectionUtils.isNotEmpty((Collection)payMethodReqDto.getSubOrderPayReqDtos())) {
            this.orderService.validateCompPay(payMethodReqDto.getSubOrderPayReqDtos());
            for (SubOrderPayReqDto subOrderPayReqDto2 : payMethodReqDto.getSubOrderPayReqDtos()) {
                if (!this.orderService.checkOrderExpireAndCloseTime(subOrderPayReqDto2.getTradeNo(), new Date(), subOrderPayReqDto2.getCloseTime()).booleanValue()) continue;
                throw new BizException(TradeExceptionCode.ORDER_EXPIRE.getCode(), TradeExceptionCode.ORDER_EXPIRE.getMsg());
            }
            subOrderPayReqDtoList = payMethodReqDto.getSubOrderPayReqDtos();
            StringBuilder orderNos = new StringBuilder();
            Iterator iterator = subOrderPayReqDtoList.iterator();
            while (iterator.hasNext()) {
                SubOrderPayReqDto subOrderPayReqDto = (SubOrderPayReqDto)iterator.next();
                orderNos.append("'").append(subOrderPayReqDto.getTradeNo()).append("'").append(",");
            }
            OrderEo orderEo3 = OrderEo.newInstance();
            ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
            sqlFilterList.add(SqlFilter.in((String)"order_no", (Object)orderNos.substring(0, orderNos.length() - 1)));
            orderEo3.setSqlFilters(sqlFilterList);
            List orders = this.orderDas.select((BaseEo)orderEo3);
            for (OrderEo order : orders) {
                payAmount = payAmount.add(order.getPayAmount());
                integral = integral + order.getIntegral();
            }
            payAmount.setScale(2);
        }
        PayReqDto payBo = new PayReqDto();
        payBo.setIsAgent(payMethodReqDto.getIsAgent());
        payBo.setInstanceId(payBo.getInstanceId());
        payBo.setTenantId(payBo.getTenantId());
        payBo.setPayMethod(payMethodReqDto.getPayMethod());
        payBo.setUserId(payMethodReqDto.getUserId());
        payBo.setStoreId(payMethodReqDto.getStoreId());
        payBo.setAppName(payMethodReqDto.getAppName());
        payBo.setAppId(payMethodReqDto.getAppId());
        payBo.setIsDefined(payMethodReqDto.getIsDefined());
        payBo.setUserSrc(payMethodReqDto.getUserSrc());
        payBo.setPayAmount(payAmount.setScale(2, 1));
        payBo.setIntegral(integral);
        payBo.setBackUrl(payMethodReqDto.getBackUrl());
        payBo.setOpenId(payMethodReqDto.getOpenId());
        payBo.setUserDeviceIp(payMethodReqDto.getUserDeviceIp());
        payBo.setSceneInfo(payMethodReqDto.getSceneInfo());
        payBo.setGoodsTag(payMethodReqDto.getGoodsTag());
        payBo.setCloseTime(payMethodReqDto.getCloseTime());
        payBo.setMemberId(payMethodReqDto.getMemberId());
        payBo.setGiftCardCode(payMethodReqDto.getGiftCardCode());
        payBo.setTradeNo(TradeUtil.generateTradeNo(payMethodReqDto.getOrderNo()));
        payBo.setOrderNo(payMethodReqDto.getOrderNo());
        PayRecordEo payRecordEo = new PayRecordEo();
        payRecordEo.setFlowDefId(orderEo.getFlowDefId());
        payRecordEo.setTenantId(payBo.getTenantId());
        payRecordEo.setSellerId(payBo.getSellerId());
        payRecordEo.setInstanceId(payBo.getInstanceId());
        payRecordEo.setTradeNo(payBo.getTradeNo());
        payRecordEo.setOrderNo(payMethodReqDto.getOrderNo());
        payRecordEo.setPayNo(payBo.getTradeNo());
        payRecordEo.setPayMethod(payBo.getPayMethod());
        payRecordEo.setPayAmount(payBo.getPayAmount());
        payRecordEo.setIntegral(payBo.getIntegral());
        payRecordEo.setRefundAmount(BigDecimal.ZERO);
        payRecordEo.setUserSrc(payBo.getUserSrc());
        payRecordEo.setUserId(payBo.getUserId());
        payRecordEo.setIsAgent(payBo.getIsAgent());
        payRecordEo.setMemberId(payBo.getMemberId());
        payRecordEo.setExtlPayAccount(payBo.getGiftCardCode());
        payRecordEo.setExtension(JSON.toJSONString((Object)payMethodReqDto));
        payRecordEo = this.payService.saveInitPayRecord(payRecordEo);
        if (CollectionUtils.isNotEmpty((Collection)payMethodReqDto.getSubOrderPayReqDtos())) {
            for (SubOrderPayReqDto subOrderPayReqDto : payMethodReqDto.getSubOrderPayReqDtos()) {
                OrderEo childrenOrder = this.orderService.getByOrderNo(subOrderPayReqDto.getTradeNo());
                PayRecordEo childrenPay = new PayRecordEo();
                BeanUtils.copyProperties((Object)payRecordEo, (Object)childrenPay);
                childrenPay.setParentPayNo(payRecordEo.getPayNo());
                childrenPay.setTradeNo(TradeUtil.generateTradeNo(payRecordEo.getOrderNo()));
                childrenPay.setPayNo(childrenPay.getTradeNo());
                childrenPay.setOrderNo(subOrderPayReqDto.getTradeNo());
                childrenPay.setInstanceId(childrenOrder.getInstanceId());
                childrenPay.setTenantId(childrenOrder.getTenantId());
                childrenPay.setUserId(childrenOrder.getUserId());
                childrenPay.setUserSrc(childrenOrder.getUserSrc());
                childrenPay.setPayAmount(childrenOrder.getPayAmount());
                childrenPay.setIntegral(childrenOrder.getIntegral());
                childrenPay.setId(null);
                childrenPay.setPayStatus(PayStatusEnum.INIT.getName());
                this.payService.saveInitPayRecord(childrenPay);
            }
        }
        try {
            string = this.payService.doPay4flow(payBo, payRecordEo.getPayNo(), curActionNode);
        }
        catch (Exception e) {
            logger.warn("\u5f80\u6e20\u9053\u4e0b\u5355\u5931\u8d25, \u5220\u9664PayRecord\u8bb0\u5f55,id={}", (Object)payRecordEo.getId());
            logger.error("\u652f\u4ed8\u6e20\u9053\u4e0b\u5355\u5931\u8d25, orderNo={}, payNo={}: " + e.getMessage(), new Object[]{orderNo, payRecordEo, e});
            throw new BizException("\u652f\u4ed8\u6e20\u9053\u4e0b\u5355\u5931\u8d25");
        }
        return string;
    }

    @ActionNode(entity=PayRecordEo.class, name="\u521b\u5efa\u5408\u5e76\u652f\u4ed8\u5355", isStart=true)
    public String create4combinePay(PayMethodReqDto payMethodReqDto) {
        String curActionNode = this.CLASS_FULL_NAME + "#create";
        List subOrderPayReqDtoList = payMethodReqDto.getSubOrderPayReqDtos();
        if (CollectionUtils.isEmpty((Collection)subOrderPayReqDtoList)) {
            throw new BizException(TradeExceptionCode.ORDER_NO_EXIT.getCode(), TradeExceptionCode.ORDER_NO_EXIT.getMsg());
        }
        if ("2".equals(payMethodReqDto.getIsDefined())) {
            Assert.notNull((Object)payMethodReqDto.getStoreId(), "storeId\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.notNull((Object)payMethodReqDto.getAppName(), "appName\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.notNull((Object)payMethodReqDto.getAppId(), "appId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.orderService.validateCompPay(subOrderPayReqDtoList);
        for (SubOrderPayReqDto subOrderPayReqDto : subOrderPayReqDtoList) {
            if (!this.orderService.checkOrderExpireAndCloseTime(subOrderPayReqDto.getTradeNo(), new Date(), subOrderPayReqDto.getCloseTime()).booleanValue()) continue;
            throw new BizException(TradeExceptionCode.ORDER_EXPIRE.getCode(), TradeExceptionCode.ORDER_EXPIRE.getMsg());
        }
        String orderNo = payMethodReqDto.getOrderNo();
        OrderEo orderEo = this.orderService.getByOrderNo(orderNo);
        PayReqDto pay = this.packPayReqDto(payMethodReqDto, orderEo);
        PayRecordEo payRecordEo = this.packPayRecordEo(orderEo, pay);
        payRecordEo.setFlowDefId(orderEo.getFlowDefId());
        TradeEngine.setFlowStatus(payRecordEo, "succ", curActionNode);
        payRecordEo.setPayStartTime(new Date());
        this.payRecordDas.insert((BaseEo)payRecordEo);
        String payResult = this.payService.doPay(pay);
        for (SubOrderPayReqDto subOrderPayReqDto : subOrderPayReqDtoList) {
            if (subOrderPayReqDto.getCloseTime() == null) continue;
            this.orderService.modifyOrderCloseTime(subOrderPayReqDto.getTradeNo(), subOrderPayReqDto.getCloseTime());
        }
        return payResult;
    }

    private PayRecordEo packPayRecordEo(OrderEo orderEo, PayReqDto pay) {
        PayRecordEo payRecordEo = new PayRecordEo();
        payRecordEo.setTenantId(pay.getTenantId());
        payRecordEo.setSellerId(pay.getSellerId());
        payRecordEo.setInstanceId(pay.getInstanceId());
        payRecordEo.setTradeNo(orderEo.getTradeNo());
        payRecordEo.setPayNo(orderEo.getOrderNo());
        payRecordEo.setPayMethod(pay.getPayMethod());
        payRecordEo.setPayAmount(pay.getPayAmount());
        payRecordEo.setRefundAmount(BigDecimal.ZERO);
        payRecordEo.setUserSrc(pay.getUserSrc());
        payRecordEo.setUserId(pay.getUserId());
        payRecordEo.setIsAgent(pay.getIsAgent());
        payRecordEo.setMemberId(pay.getMemberId());
        payRecordEo.setExtlPayAccount(pay.getGiftCardCode());
        return payRecordEo;
    }

    private PayReqDto packPayReqDto(PayMethodReqDto payMethodReqDto, OrderEo orderEo) {
        PayReqDto payBo = new PayReqDto();
        payBo.setTradeNo(payMethodReqDto.getTradeNo());
        payBo.setOrderNo(orderEo.getOrderNo());
        payBo.setIsAgent(payMethodReqDto.getIsAgent());
        payBo.setInstanceId(orderEo.getInstanceId());
        payBo.setTenantId(orderEo.getTenantId());
        payBo.setPayMethod(payMethodReqDto.getPayMethod());
        payBo.setUserId(payMethodReqDto.getUserId());
        payBo.setStoreId(payMethodReqDto.getStoreId());
        payBo.setAppName(payMethodReqDto.getAppName());
        payBo.setAppId(payMethodReqDto.getAppId());
        payBo.setSellerId(orderEo.getSellerId());
        payBo.setIsDefined(payMethodReqDto.getIsDefined());
        payBo.setUserSrc(payMethodReqDto.getUserSrc());
        payBo.setPayAmount(orderEo.getPayAmount().setScale(2, 1));
        payBo.setBackUrl(payMethodReqDto.getBackUrl());
        payBo.setOpenId(payMethodReqDto.getOpenId());
        payBo.setUserDeviceIp(payMethodReqDto.getUserDeviceIp());
        payBo.setSceneInfo(payMethodReqDto.getSceneInfo());
        payBo.setGoodsTag(payMethodReqDto.getGoodsTag());
        payBo.setCloseTime(payMethodReqDto.getCloseTime());
        return payBo;
    }

    @ActionNode(entity=PayRecordEo.class, name="\u652f\u4ed8\u56de\u8c03", results={@ActionResult(code="succ", desc="\u652f\u4ed8\u6210\u529f", call={"com.dtyunxi.yundt.cube.center.trade.biz.flow.action.OrderAction#payOrder"}), @ActionResult(code="fail", desc="\u652f\u4ed8\u5931\u8d25")})
    @Transactional
    public PayNotifyResultInput handleNotify(PayOrderNotifyRequest notifyReq) {
        logger.info("\u8ba2\u5355\u652f\u4ed8\u56de\u8c03\u901a\u77e5: {}", JSON.toJSON((Object)notifyReq));
        String curActionCode = this.CLASS_FULL_NAME + "#handleNotify";
        String extlPaySerial = notifyReq.getTradeId();
        PayRecordEo payRecordEo = this.payRecordDas.selectByPayNo(notifyReq.getStoreOrderId());
        payRecordEo = this.payRecordDas.lockById(payRecordEo.getId());
        TradeEngine.validate((IFlowEntity)payRecordEo, curActionCode);
        boolean paySucc = PAY_NOTIFY_STATUS_SUCC.equals(notifyReq.getOrderStatus());
        Date finishTime = DateUtil.parseDate((String)notifyReq.getFinishTime(), (String)"yyyy-MM-dd HH:mm:ss");
        Integer integral = payRecordEo.getIntegral();
        BigDecimal payAmount = payRecordEo.getPayAmount();
        if (paySucc) {
            if (!PayTypeEnum.INTEGRAL.getCode().equals(payRecordEo.getPayMethod()) && integral != null && integral > 0) {
                IntegralOrderPayMessageVo integralOrderPayMessageVo = new IntegralOrderPayMessageVo(payRecordEo.getOrderNo(), payRecordEo.getPayNo(), PayTypeEnum.INTEGRAL.getCode());
                logger.info("\u79ef\u5206\u8ba2\u5355\u7b2c\u4e8c\u6b21\u79ef\u5206\u652f\u4ed8: {}", (Object)JSON.toJSONString((Object)integralOrderPayMessageVo));
                this.integralOrderPayProducer.sendPayMsg(integralOrderPayMessageVo);
            }
            if (PayTypeEnum.INTEGRAL.getCode().equals(payRecordEo.getPayMethod()) && payAmount != null && payAmount.compareTo(BigDecimal.ZERO) > 0) {
                logger.info("\u79ef\u5206\u91d1\u989d\u6df7\u5408\u8ba2\u5355\u7b2c\u4e8c\u6b21\u79ef\u5206\u652f\u4ed8\u6210\u529f: orderNo={}, integral={}", (Object)payRecordEo.getOrderNo(), (Object)integral);
                return new PayNotifyResultInput(PayStatusEnum.SUCCESS, payRecordEo, "succ");
            }
            OrderPayedEvent orderPayedEvent = new OrderPayedEvent();
            orderPayedEvent.setOrderNo(payRecordEo.getOrderNo()).setPayNo(payRecordEo.getPayNo()).setFinishTime(finishTime);
            TradeEngine.setFlowStatus(payRecordEo, "succ", curActionCode);
            payRecordEo.setExtlPaySerial(extlPaySerial);
            payRecordEo.setPayFinishTime(finishTime);
            this.payRecordDas.updateSelective((BaseEo)payRecordEo);
            PayRecordEo query = new PayRecordEo();
            query.setParentPayNo(payRecordEo.getPayNo());
            List list = this.payRecordDas.select((BaseEo)query);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                for (PayRecordEo payRecord : list) {
                    payRecord.setExtlPaySerial(extlPaySerial);
                    payRecord.setPayStatus(payRecordEo.getPayStatus());
                    this.payRecordDas.updateSelective((BaseEo)payRecord);
                    OrderPayedEvent childrenPayEvent = new OrderPayedEvent();
                    childrenPayEvent.setOrderNo(payRecord.getOrderNo()).setPayNo(payRecord.getPayNo());
                }
            }
            return new PayNotifyResultInput(PayStatusEnum.SUCCESS, payRecordEo, "succ");
        }
        TradeEngine.setFlowStatus(payRecordEo, "fail", curActionCode);
        payRecordEo.setExtlPaySerial(extlPaySerial);
        this.payRecordDas.updateSelective((BaseEo)payRecordEo);
        return new PayNotifyResultInput(PayStatusEnum.FAIL, payRecordEo, "fail");
    }
}

