/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.flow.base.ext;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.ds.BaseMapper;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.FlowStatusAdapter;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.FlowStatusEntity;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.FlowStatusMap;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.StatusFlowInstanceInfo;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.StatusMap;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.ext.StatusEO;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.node.StatusNode;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.utils.FlowRefectionUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStatusAdapter
implements FlowStatusAdapter {
    private static Logger logger = LoggerFactory.getLogger(AbstractStatusAdapter.class);
    protected FlowStatusMap flowStatusMap = new FlowStatusMap();
    protected FlowStatusMap reloadFlowStatusMap = new FlowStatusMap();
    @Resource
    private Map<String, BaseMapper> mappers;
    private BaseMapper baseMapper;
    private boolean isInit = false;

    private BaseMapper findMapper(StatusEO annotation) {
        Class<? extends BaseEo> entity = annotation.entity();
        String tClassName = entity.getName();
        tClassName = tClassName.substring(tClassName.lastIndexOf(".") + 1, tClassName.length());
        String firstSearchMapperName = tClassName.substring(0, 1).toLowerCase() + tClassName.substring(1, tClassName.length() - 2) + "Mapper";
        BaseMapper mapper = this.mappers.get(firstSearchMapperName);
        String secondSearchMapperName = null;
        if (null == mapper) {
            secondSearchMapperName = tClassName.substring(0, tClassName.length() - 2) + "Mapper";
            mapper = this.mappers.get(secondSearchMapperName);
        }
        if (mapper == null) {
            throw new RuntimeException(tClassName + "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684mapper:" + firstSearchMapperName + "/" + secondSearchMapperName);
        }
        return mapper;
    }

    @Override
    public boolean isActionExecSave() {
        return false;
    }

    @Override
    public boolean isStatusChangeSave() {
        return true;
    }

    @Override
    public void save(String flowName, Object saveEntity, boolean isStartCreate) {
        if (saveEntity == null) {
            return;
        }
        StatusEO annotation = this.getClass().getAnnotation(StatusEO.class);
        if (this.baseMapper == null) {
            this.baseMapper = this.findMapper(annotation);
        }
        try {
            BaseEo baseEo = (BaseEo)saveEntity;
            if (baseEo.getId() != null) {
                if (isStartCreate) {
                    this.baseMapper.updateSelective(baseEo);
                } else {
                    this.baseMapper.update(baseEo);
                }
            } else {
                this.baseMapper.insert((Object)baseEo);
            }
        }
        catch (Exception e) {
            logger.error(flowName + "\u4fdd\u5b58\u6d41\u7a0b\u5b9e\u4f8b\u51fa\u9519");
            throw e;
        }
    }

    @Override
    public Object getEntity(String flowName, String flowNo) {
        StatusEO annotation = this.getClass().getAnnotation(StatusEO.class);
        if (annotation == null) {
            return null;
        }
        if (this.baseMapper == null) {
            this.baseMapper = this.findMapper(annotation);
        }
        Class<? extends BaseEo> entity = annotation.entity();
        try {
            BaseEo baseEo = entity.newInstance();
            FlowRefectionUtil.setValueByFiled(baseEo, annotation.flowNoField(), flowNo);
            List list = this.baseMapper.findList(baseEo);
            if (CollectionUtils.isEmpty((Collection)list)) {
                throw new BizException("flowName=" + flowName + ",flowNo=" + flowNo + ",field=" + annotation.flowNoField() + "\u67e5\u8be2\u4e0d\u5230\u6d41\u7a0b\u8bb0\u5f55");
            }
            if (list.size() > 1) {
                throw new BizException("flowName=" + flowName + ",flowNo=" + flowNo + "field=" + annotation.flowNoField() + "\u67e5\u8be2\u8bb0\u5f55\u4e0d\u80fd\u5927\u4e8e1");
            }
            Object result = list.get(0);
            return result;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public FlowStatusEntity getFlowStatusEntity(String flowName, String flowNo) {
        FlowStatusEntity flowStatusEntity = new FlowStatusEntity();
        Object entity = this.getEntity(flowName, flowNo);
        if (entity == null) {
            throw new BizException("flowName=" + flowName + ",flowNo=" + flowNo + "\u67e5\u8be2\u4e0d\u5230\u5b9e\u4f53\u6570\u636e");
        }
        flowStatusEntity.setEntity(entity);
        StatusMap statusMap = this.flowStatusMap.getAndCreateStatusMap(flowName);
        List<StatusNode> statusNodes = statusMap.getStatusByEntity(flowNo, flowStatusEntity.getEntity());
        flowStatusEntity.setStatusNodes(statusNodes);
        return flowStatusEntity;
    }

    @Override
    public void addStatus(String flowName, StatusNode statusNode) {
        this.flowStatusMap.addStatus(flowName, statusNode);
    }

    @Override
    public void addReloadStatus(String flowName, StatusNode statusNode) {
        this.reloadFlowStatusMap.addStatus(flowName, statusNode);
    }

    @Override
    public void finishReload() {
        this.flowStatusMap.clear();
        this.flowStatusMap = this.reloadFlowStatusMap;
        this.reloadFlowStatusMap = new FlowStatusMap();
    }

    @Override
    public void statusChangeListen(StatusFlowInstanceInfo statusFlowInstanceInfo, Object inputParam, Object returnParam) {
    }

    @Override
    public void clear() {
        this.flowStatusMap.clear();
    }

    @Override
    public String getGroupName() {
        StatusEO annotation = this.getClass().getAnnotation(StatusEO.class);
        return annotation.groupName();
    }

    @Override
    public Class<? extends BaseEo> getEntityClass() {
        StatusEO annotation = this.getClass().getAnnotation(StatusEO.class);
        return annotation.entity();
    }

    @Override
    public String getEntityField() {
        StatusEO annotation = this.getClass().getAnnotation(StatusEO.class);
        return annotation.entityField();
    }

    @Override
    public String getGroup() {
        StatusEO annotation = this.getClass().getAnnotation(StatusEO.class);
        return annotation.entity().getName();
    }
}

