/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.flow.base.image;

import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.IFlowEngine;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.image.ActionNodeResult;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.image.BaseNodeInfo;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.node.ActionNode;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.node.ForActionNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ActionNodeInfo
extends BaseNodeInfo {
    private String beanMethod;
    private ActionNode actionNode;
    private Map<String, ActionNodeResult> resultMap = new HashMap<String, ActionNodeResult>();

    public List<ActionNodeResult> getActionResultList() {
        return this.resultMap.values().stream().collect(Collectors.toList());
    }

    public static ActionNodeInfo buildActionNodeInfo(ActionNode actionNode) {
        ActionNodeInfo actionNodeInfo = new ActionNodeInfo();
        actionNodeInfo.setBeanMethod(actionNode.getBeanMethod());
        actionNodeInfo.setName(actionNode.getName());
        actionNodeInfo.setDocType(actionNode.getEntityClass());
        actionNodeInfo.setInputCode("_");
        actionNodeInfo.setOutputCode("_");
        actionNodeInfo.setCode(actionNode.getBeanMethod());
        actionNodeInfo.actionNode = actionNode;
        for (ForActionNode forActionNode : actionNode.getForActionNoteList()) {
            forActionNode.setNextForField(actionNode.getNextForProperty());
            actionNodeInfo.addNextFor(forActionNode);
        }
        return actionNodeInfo;
    }

    public ActionNodeInfo fetchSubFlowActionInfo(IFlowEngine flowEngine) {
        for (ForActionNode forActionNode : this.actionNode.getForActionNoteList()) {
            if (!StringUtils.isNotEmpty((CharSequence)forActionNode.getFlowName())) continue;
            ActionNodeInfo actionNodeInfo = new ActionNodeInfo();
            if (StringUtils.isNotEmpty((CharSequence)forActionNode.getFlowNoField())) {
                actionNodeInfo.setCode("sub_" + forActionNode.getFlowNoField() + "_" + forActionNode.getFlowAction());
            } else {
                actionNodeInfo.setCode("sub__" + forActionNode.getFlowAction());
            }
            String group = flowEngine.getFlow(forActionNode.getFlowName()).getFlowStatusAdapter().getGroupName();
            actionNodeInfo.setName(group + ":" + forActionNode.getFlowAction());
            actionNodeInfo.setDocType(this.actionNode.getEntityClass());
            actionNodeInfo.setInputCode("_");
            actionNodeInfo.setOutputCode("_");
            return actionNodeInfo;
        }
        return null;
    }

    public void replenishActionInfo(ActionNode actionNode) {
        for (ForActionNode forActionNode : actionNode.getForActionNoteList()) {
            forActionNode.setNextForField(actionNode.getNextForProperty());
            this.addNextFor(forActionNode);
        }
    }

    public void addNextFor(ForActionNode forActionNode) {
        ActionNodeResult actionNodeResult = new ActionNodeResult();
        actionNodeResult.setFlowNodeCode(this.beanMethod);
        if (StringUtils.isNotEmpty((CharSequence)forActionNode.getNextForField())) {
            actionNodeResult.setCode(forActionNode.getNextForField() + "=" + forActionNode.getForName());
            actionNodeResult.setName(forActionNode.getNextForField() + "=" + forActionNode.getForName());
        } else {
            actionNodeResult.setCode(forActionNode.getForName());
            actionNodeResult.setName(forActionNode.getForName());
        }
        this.resultMap.put(actionNodeResult.getCode(), actionNodeResult);
    }

    public String getBeanMethod() {
        return this.beanMethod;
    }

    public void setBeanMethod(String beanMethod) {
        this.beanMethod = beanMethod;
    }
}

