/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.flow.base.image;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.ext.FlowBindData;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.ext.FlowSchemeData;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.image.GroupFlowImage;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.image.style.ImageFlow;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FlowSchemeFactory {
    protected static Logger logger = LoggerFactory.getLogger(FlowSchemeFactory.class);
    private Map<Long, GroupFlowImage> groupFlowImageMap = new ConcurrentHashMap<Long, GroupFlowImage>();
    private Map<Long, FlowSchemeData> flowSchemeMap = new ConcurrentHashMap<Long, FlowSchemeData>();
    private Map<String, FlowSchemeData> flowNameSchemeMap = new ConcurrentHashMap<String, FlowSchemeData>();
    private Map<String, FlowBindData> flowNameMap = new ConcurrentHashMap<String, FlowBindData>();

    public void bind(Long flowSchemeId, String flowName, String flowAdapter, String entityClass, String entityName) {
        FlowBindData addFlowBindData = new FlowBindData();
        addFlowBindData.setFlowName(flowName);
        addFlowBindData.setFlowSchemeId(flowSchemeId);
        addFlowBindData.setAdapterName(flowAdapter);
        addFlowBindData.setEntityClass(entityClass);
        addFlowBindData.setEntityName(entityName);
        this.flowNameMap.put(flowName, addFlowBindData);
        FlowSchemeData flowSchemeData = this.flowSchemeMap.get(flowSchemeId);
        if (flowSchemeData == null) {
            flowSchemeData = new FlowSchemeData(flowSchemeId);
            this.flowSchemeMap.put(flowSchemeId, flowSchemeData);
        }
        flowSchemeData.addFlowBindData(addFlowBindData);
        this.flowNameSchemeMap.put(flowName, flowSchemeData);
    }

    public boolean refresh(ImageFlow imageFlow) {
        logger.info("\u6b63\u5728\u5237\u65b0\u6d41\u7a0b{},JSON={}", (Object)imageFlow.getFlowId(), (Object)JSON.toJSONString((Object)imageFlow));
        FlowSchemeData flowSchemeData = this.flowNameSchemeMap.get(imageFlow.fetchFlowCode());
        FlowBindData flowBindData = this.flowNameMap.get(imageFlow.fetchFlowCode());
        if (flowSchemeData == null) {
            logger.error("\u65e0\u6cd5\u5237\u65b0\u6d41\u7a0bid=" + imageFlow.fetchFlowCode() + "\uff0c\u627e\u4e0d\u5230\u7ed1\u5b9a\u4fe1\u606f");
            return false;
        }
        GroupFlowImage groupFlowImage = this.groupFlowImageMap.get(flowSchemeData.getFlowSchemeId());
        imageFlow.setFlowStatusAdapter(flowBindData.getAdapterName());
        if (groupFlowImage == null) {
            groupFlowImage = new GroupFlowImage(flowSchemeData);
            this.groupFlowImageMap.put(flowSchemeData.getFlowSchemeId(), groupFlowImage);
        }
        groupFlowImage.addImageFlow(imageFlow);
        return true;
    }

    public List<GroupFlowImage> getGroupImageList() {
        return this.groupFlowImageMap.values().stream().collect(Collectors.toList());
    }

    public FlowBindData getByFlowName(String flowName) {
        return this.flowNameMap.get(flowName);
    }
}

