/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.flow.base.image;

import com.dtyunxi.cube.enhance.flow.StatusNodeInfo;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.FlowStatusAdapter;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.IFlowEngine;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.image.ActionNodeInfo;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.image.ActionNodeResult;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.image.EntityInfo;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.image.StatusNodeInfoMti;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.node.ActionNode;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.node.FlowNode;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.node.FlowsNode;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.node.StatusNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class NodeDataBuilder {
    private FlowsNode flowsNode;
    private Map<String, ActionNodeInfo> actionNodeInfoMap = new HashMap<String, ActionNodeInfo>();
    private Map<String, StatusNodeInfo> statusNodeInfoHashMap = new HashMap<String, StatusNodeInfo>();
    private List<ActionNodeInfo> actionNodeInfos = new ArrayList<ActionNodeInfo>();
    private List<StatusNodeInfo> statusNodeInfos = new ArrayList<StatusNodeInfo>();
    private List<ActionNodeResult> actionNodeResults = new ArrayList<ActionNodeResult>();
    private List<FlowStatusAdapter> flowStatusAdapters;
    private Map<String, EntityInfo> entityInfoMap = new HashMap<String, EntityInfo>();
    private List<EntityInfo> entityInfoList = new ArrayList<EntityInfo>();
    private IFlowEngine flowEngine;

    public NodeDataBuilder(FlowsNode flowsNode, List<FlowStatusAdapter> flowStatusAdapters, IFlowEngine flowEngine) {
        this.flowsNode = flowsNode;
        this.flowStatusAdapters = flowStatusAdapters;
        this.flowEngine = flowEngine;
    }

    public void buildNodes() {
        for (FlowNode flowNode : this.flowsNode.getFlowNodes()) {
            for (ActionNode actionNode : flowNode.getActionNodes()) {
                ActionNodeInfo addSubFlowActionNode;
                ActionNodeInfo subFlowActionNode;
                ActionNodeInfo actionNodeInfo = this.actionNodeInfoMap.get(actionNode.getBeanMethod());
                if (actionNodeInfo == null) {
                    actionNodeInfo = ActionNodeInfo.buildActionNodeInfo(actionNode);
                    this.actionNodeInfoMap.put(actionNode.getBeanMethod(), actionNodeInfo);
                    this.actionNodeInfos.add(actionNodeInfo);
                } else {
                    actionNodeInfo.replenishActionInfo(actionNode);
                }
                if ((subFlowActionNode = actionNodeInfo.fetchSubFlowActionInfo(this.flowEngine)) == null || (addSubFlowActionNode = this.actionNodeInfoMap.get(subFlowActionNode.getCode())) != null) continue;
                this.actionNodeInfoMap.put(subFlowActionNode.getCode(), subFlowActionNode);
                this.actionNodeInfos.add(subFlowActionNode);
            }
            for (StatusNode statusNode : flowNode.getStatusNodes()) {
                StatusNodeInfo statusNodeInfo2 = StatusNodeInfoMti.buildStatusNodeInfo(statusNode);
                String key = statusNodeInfo2.getDocType() + statusNodeInfo2.getStatusField() + statusNodeInfo2.getStatusValue();
                if (this.statusNodeInfoHashMap.get(key) != null) continue;
                this.statusNodeInfoHashMap.put(key, statusNodeInfo2);
                this.statusNodeInfos.add(statusNodeInfo2);
            }
        }
        for (ActionNodeInfo actionNodeInfo : this.actionNodeInfos) {
            this.actionNodeResults.addAll(actionNodeInfo.getActionResultList());
        }
        for (FlowStatusAdapter flowStatusAdapter : this.flowStatusAdapters) {
            Class<? extends BaseEo> entityClass = flowStatusAdapter.getEntityClass();
            EntityInfo entityInfo = this.entityInfoMap.get(entityClass.getName());
            if (entityInfo != null) continue;
            entityInfo = new EntityInfo();
            entityInfo.setCode(entityClass.getName());
            entityInfo.setName(flowStatusAdapter.getGroupName());
            entityInfo.setDomain("all");
            this.entityInfoMap.put(entityClass.getName(), entityInfo);
            this.entityInfoList.add(entityInfo);
        }
        for (EntityInfo entityInfo : this.entityInfoList) {
            List<StatusNodeInfo> entityStatus = this.statusNodeInfos.stream().filter(statusNodeInfo -> statusNodeInfo.getDocType().equals(entityInfo.getCode())).collect(Collectors.toList());
            entityInfo.setStatusNodeInfos(entityStatus);
        }
    }

    public List<EntityInfo> getEntityInfoList() {
        return this.entityInfoList;
    }

    public List<ActionNodeInfo> getActionNodeInfos() {
        return this.actionNodeInfos;
    }

    public List<StatusNodeInfo> getStatusNodeInfos() {
        return this.statusNodeInfos;
    }

    public List<ActionNodeResult> getActionNodeResults() {
        return this.actionNodeResults;
    }
}

