/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.flow.base.image;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.enhance.flow.NameCodePair;
import com.dtyunxi.cube.enhance.flow.StatusNodeInfo;
import com.dtyunxi.cube.starter.bundle.dto.response.BundleFlowDto;
import com.dtyunxi.cube.starter.bundle.dto.response.BundleFlowsRespDto;
import com.dtyunxi.cube.starter.bundle.enums.BundleDataTypeEnum;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.flow.api.IFlowApi;
import com.dtyunxi.yundt.cube.center.flow.api.dto.request.FlowUploadRepDto;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.FlowStatusAdapter;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.IFlowEngine;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.image.IReport;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.image.NodeDataBuilder;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.node.FlowsNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReportImpl
implements IReport {
    private Logger logger = LoggerFactory.getLogger(ReportImpl.class);
    @Autowired
    private IFlowApi flowApi;
    @Autowired
    private List<FlowStatusAdapter> flowStatusAdapters;

    @Override
    public void reportFlowToMpc(FlowsNode flowsNode, IFlowEngine flowEngine) {
        this.logger.info("\u6b63\u5728\u6784\u5efa\u4e0a\u62a5\u4fe1\u606f");
        NodeDataBuilder nodeDataBuildFactory = new NodeDataBuilder(flowsNode, this.flowStatusAdapters, flowEngine);
        nodeDataBuildFactory.buildNodes();
        List actionList = nodeDataBuildFactory.getActionNodeInfos().stream().map(actionNodeInfo -> {
            BundleFlowDto.FlowNode flowNode = new BundleFlowDto.FlowNode();
            BeanUtils.copyProperties((Object)actionNodeInfo, (Object)flowNode);
            List results = actionNodeInfo.getActionResultList().stream().map(actionNodeResult -> {
                BundleFlowDto.FlowNode.Result result = new BundleFlowDto.FlowNode.Result();
                result.setCode(actionNodeResult.getCode());
                result.setName(actionNodeResult.getName());
                result.setDesc(actionNodeResult.getName());
                return result;
            }).collect(Collectors.toList());
            flowNode.setResults(results);
            return flowNode;
        }).collect(Collectors.toList());
        List flowDocs = nodeDataBuildFactory.getEntityInfoList().stream().map(entityInfo -> {
            BundleFlowDto.FlowDoc doc = new BundleFlowDto.FlowDoc();
            BeanUtils.copyProperties((Object)entityInfo, (Object)doc);
            HashMap<String, BundleFlowDto.FlowDoc.BundleStatusValueInfoDto> statusPropDesc = new HashMap<String, BundleFlowDto.FlowDoc.BundleStatusValueInfoDto>();
            Map<String, List<StatusNodeInfo>> statusMap = entityInfo.getStatusNodeInfos().stream().collect(Collectors.groupingBy(StatusNodeInfo::getStatusField));
            for (String key : statusMap.keySet()) {
                BundleFlowDto.FlowDoc.BundleStatusValueInfoDto bundleStatusValueInfoDto = new BundleFlowDto.FlowDoc.BundleStatusValueInfoDto();
                List<StatusNodeInfo> statusNodeInfos = statusMap.get(key);
                ArrayList<NameCodePair> pairs = new ArrayList<NameCodePair>();
                for (StatusNodeInfo statusNodeInfo : statusNodeInfos) {
                    NameCodePair nameCodePair = new NameCodePair();
                    nameCodePair.setCode(statusNodeInfo.getStatusValue());
                    nameCodePair.setName(statusNodeInfo.getNodeName());
                    pairs.add(nameCodePair);
                }
                bundleStatusValueInfoDto.setStatusDesc(key);
                bundleStatusValueInfoDto.setPairs(pairs);
                statusPropDesc.put(key, bundleStatusValueInfoDto);
            }
            doc.setStatusPropDesc(statusPropDesc);
            return doc;
        }).collect(Collectors.toList());
        BundleFlowsRespDto bundleFlowsRespDto = new BundleFlowsRespDto();
        bundleFlowsRespDto.setFlowNodes(actionList);
        bundleFlowsRespDto.setFlowDocs(flowDocs);
        bundleFlowsRespDto.setArtifactId("bundle-base-center-trade");
        bundleFlowsRespDto.setGroupId("com.dtyunxi.yundt.icom");
        bundleFlowsRespDto.setVersion("0");
        bundleFlowsRespDto.setType(BundleDataTypeEnum.FLOW.getKey());
        ArrayList<BundleFlowsRespDto> bundleFlows = new ArrayList<BundleFlowsRespDto>();
        bundleFlows.add(bundleFlowsRespDto);
        FlowUploadRepDto flowUploadRepDto = new FlowUploadRepDto();
        flowUploadRepDto.setBundleFlows(bundleFlows);
        this.logger.info("\u4e0a\u62a5\u8282\u70b9={}", (Object)JSON.toJSONString((Object)flowUploadRepDto));
        RestResponse restResponse = this.flowApi.uploadFlow(flowUploadRepDto);
        if ("0".equals(restResponse.getResultCode())) {
            this.logger.info("\u4e0a\u62a5\u6210\u529f\u6570\u636e\u6210\u529f");
        } else {
            this.logger.info("\u4e0a\u62a5\u6210\u529f\u6570\u636e\u5931\u8d25");
        }
        this.logger.info("\u4e0a\u62a5\u4fe1\u606f\u6784\u5efa\u5b8c\u6210={}", (Object)JSON.toJSONString((Object)nodeDataBuildFactory));
    }
}

