/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.flow.base.image.style;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.image.style.Edge;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.image.style.ImageNode;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class ImageFlow {
    private String statusColor;
    private String actionColor;
    private Long flowId;
    private Long flowDefId;
    private String docType;
    private String flowName;
    private String entityName;
    private String flowStatusAdapter;
    private List<Edge> edges = new ArrayList<Edge>();
    private List<ImageNode> nodes = new ArrayList<ImageNode>();

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    private ImageNode getStartNode() {
        for (ImageNode imageNode : this.nodes) {
            if (!imageNode.getType().equals("start-node")) continue;
            return imageNode;
        }
        return null;
    }

    private Edge getStartEdge(ImageNode startNode) {
        for (Edge edge : this.edges) {
            if (!edge.getSource().contains(startNode.getId())) continue;
            return edge;
        }
        return null;
    }

    private ImageNode fetchStartLinkNode(Edge startEdge) {
        try {
            for (ImageNode imageNode : this.nodes) {
                if (imageNode == null) {
                    // empty if block
                }
                if (!startEdge.getTarget().contains(imageNode.getId())) continue;
                return imageNode;
            }
        }
        catch (Exception e) {
            throw new BizException("\u65e0\u6cd5\u67e5\u8be2\u5f00\u59cb\u8282\u70b9");
        }
        return null;
    }

    public ImageNode fetchStartLinkNode() {
        ImageNode startNode = this.getStartNode();
        Edge startEdge = this.getStartEdge(startNode);
        return this.fetchStartLinkNode(startEdge);
    }

    public Long getFlowDefId() {
        return this.flowDefId;
    }

    public void setFlowDefId(Long flowDefId) {
        this.flowDefId = flowDefId;
    }

    public String getFlowStatusAdapter() {
        return this.flowStatusAdapter;
    }

    public void setFlowStatusAdapter(String flowStatusAdapter) {
        this.flowStatusAdapter = flowStatusAdapter;
    }

    public String getDocType() {
        return this.docType;
    }

    public void setDocType(String docType) {
        this.docType = docType;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public void setFlowName(String flowName) {
        this.flowName = flowName;
    }

    public String fetchFlowCode() {
        if (this.flowId == null || this.flowId.equals(0L)) {
            return this.flowName;
        }
        return this.flowId.toString();
    }

    public Long getFlowId() {
        return this.flowId;
    }

    public void setFlowId(Long flowId) {
        this.flowId = flowId;
    }

    public ImageNode queryByName(String name) {
        for (ImageNode imageNode : this.nodes) {
            if (!imageNode.getLabel().equals(name)) continue;
            return imageNode;
        }
        return null;
    }

    public String getStatusColor() {
        if (this.statusColor == null) {
            this.statusColor = ImageFlow.randomHexStr();
        }
        return this.statusColor;
    }

    public void setStatusColor(String statusColor) {
        this.statusColor = statusColor;
    }

    public String getActionColor() {
        if (this.actionColor == null) {
            this.actionColor = ImageFlow.randomHexStr();
        }
        return this.actionColor;
    }

    public void setActionColor(String actionColor) {
        this.actionColor = actionColor;
    }

    public List<ImageNode> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<ImageNode> nodes) {
        this.nodes = nodes;
    }

    public List<Edge> getEdges() {
        return this.edges;
    }

    public void setEdges(List<Edge> edges) {
        this.edges = edges;
    }

    public static String randomHexStr() {
        Random rand = new Random();
        Float r = Float.valueOf((float)((double)(rand.nextFloat() / 2.0f) + 0.5));
        Float g = Float.valueOf((float)((double)(rand.nextFloat() / 2.0f) + 0.5));
        Float b = Float.valueOf((float)((double)(rand.nextFloat() / 2.0f) + 0.5));
        Color randomColor = new Color(r.floatValue(), g.floatValue(), b.floatValue());
        return "#" + ImageFlow.toHexFromColor(randomColor);
    }

    private static String toHexFromColor(Color color) {
        StringBuilder su = new StringBuilder();
        String r = Integer.toHexString(color.getRed());
        String g = Integer.toHexString(color.getGreen());
        String b = Integer.toHexString(color.getBlue());
        r = r.length() == 1 ? "0" + r : r;
        g = g.length() == 1 ? "0" + g : g;
        b = b.length() == 1 ? "0" + b : b;
        r = r.toUpperCase();
        g = g.toUpperCase();
        b = b.toUpperCase();
        su.append(r);
        su.append(g);
        su.append(b);
        return su.toString();
    }
}

