/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.flow.base.impl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.IFlow;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.IFlowEngine;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.IParamAdapter;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.Task;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.exception.FlowException;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.impl.ActionImpl;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.impl.MethodExeInfo;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.impl.MethodExecute;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.load.FlowOrgBeanFactory;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.node.ActionNode;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.node.FlowActionNode;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.node.FlowNode;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.node.StatusNode;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.node.StatusValue;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.utils.FlowRefectionUtil;
import com.dtyunxi.yundt.cube.center.trade.biz.service.ITradeService;
import java.lang.reflect.Field;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ActionInstanceCreator {
    protected static Logger logger = LoggerFactory.getLogger(ActionInstanceCreator.class);
    @Autowired
    private ITradeService tradeService;
    @Autowired
    private IParamAdapter paramAdapter;
    @Autowired
    private MethodExecute methodExecute;

    public Task buildAction(IFlowEngine flowEngine, ActionNode actionNode, FlowNode flowNode) {
        IFlow flow = (IFlow)flowNode.getBaseAction();
        try {
            Object orgBean = FlowOrgBeanFactory.getOrgBean(actionNode.fetchBeanMethodBeanName());
            if (orgBean == null) {
                throw new FlowException("beanName=" + actionNode.fetchBeanMethodBeanName() + "\u4e0d\u5b58\u5728");
            }
            MethodExeInfo methodExeInfo = FlowRefectionUtil.getAndCheckParamMethodExeInfo(actionNode, orgBean.getClass(), flow);
            methodExeInfo.setOrgBean(orgBean);
            methodExeInfo.setMethodExecute(this.methodExecute);
            for (ActionNode nextAction : actionNode.getNextActionNoteList()) {
                if (!(nextAction instanceof FlowActionNode)) continue;
                Class<?> outPutClass = methodExeInfo.getOutPutClass();
                FlowActionNode flowActionNode = (FlowActionNode)nextAction;
                String flowNoFieldName = flowActionNode.getFlowNoFieldName();
                if (StringUtils.isEmpty((Object)flowNoFieldName)) continue;
                Field field = ReflectionUtils.findField(outPutClass, (String)flowNoFieldName);
                if (field == null) {
                    throw new BizException("\u89e3\u6790\u6d41\u7a0b=" + flowNode.getName() + ",\u52a8\u4f5c=" + actionNode.getName() + " \u51fa\u9519\uff0cnext\u7684flowNoField\u6709\u8bef\uff0cbeanMethod\u8f93\u51fa\u53c2\u6570\u67e5\u8be2\u4e0d\u5230flowNoField=" + flowNoFieldName + "\u6587\u4ef6" + flowNode.getResource());
                }
                field.setAccessible(true);
                flowActionNode.setFlowNoField(field);
            }
            ActionImpl action = new ActionImpl(this.tradeService, flowEngine, this.paramAdapter, actionNode, methodExeInfo);
            return action;
        }
        catch (BizException e) {
            logger.error("\u89e3\u6790\u8282\u70b9\u51fa\u9519", (Throwable)e);
            throw new BizException("\u89e3\u6790\u6d41\u7a0b=" + flowNode.getName() + ",\u52a8\u4f5c=" + actionNode.getName() + " \u51fa\u9519\u6587\u4ef6" + flowNode.getResource());
        }
    }

    public void initStatusNode(StatusNode statusNode, FlowNode flowNode) {
        List<StatusValue> statusValueList = statusNode.getStatusValueList();
        IFlow flow = (IFlow)flowNode.getBaseAction();
        Class<? extends BaseEo> entityClass = flow.getFlowStatusAdapter().getEntityClass();
        for (StatusValue statusValue : statusValueList) {
            Field field = ReflectionUtils.findField(entityClass, (String)statusValue.getFieldName());
            if (field == null) {
                throw new BizException("\u89e3\u6790\u6d41\u7a0b=" + flowNode.getName() + ",\u72b6\u6001=" + statusNode.getName() + " \u51fa\u9519," + entityClass.getName() + "\u627e\u4e0d\u5230field=" + statusValue.getFieldName());
            }
            field.setAccessible(true);
            statusValue.setField(field);
        }
    }
}

