/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.flow.base.load;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.yundt.cube.center.trade.api.flow.BaseAction;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.FlowStatusAdapter;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.IFlow;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.IFlowEngine;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.IFlowLockService;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.image.FlowSchemeFactory;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.image.style.ImageFlow;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.impl.ActionInstanceCreator;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.impl.FlowEngineImpl;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.impl.FlowImpl;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.load.ILoadFlow;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.mq.FlowMqMessage;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.node.ActionNode;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.node.FlowActionNode;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.node.FlowNode;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.node.FlowsNode;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.node.StatusNode;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.parse.IParseNote;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.utils.SpringBootBeanUtil;
import com.dtyunxi.yundt.cube.center.trade.biz.service.ITradeService;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class LoadFlowImpl
implements ILoadFlow {
    protected static Logger logger = LoggerFactory.getLogger(LoadFlowImpl.class);
    @Autowired
    private IFlowEngine flowFactory;
    @Autowired
    private ITradeService tradeService;
    @Autowired
    IParseNote parseNote;
    @Autowired
    SpringBootBeanUtil springBootBeanUtil;
    @Resource
    protected ICacheService cacheService;
    @Autowired
    protected FlowMqMessage flowMqMessage;
    @Autowired
    private ActionInstanceCreator actionInstanceCreator;
    @Autowired
    private IFlowLockService flowLockService;
    @Autowired
    private FlowSchemeFactory flowSchemeFactory;
    @Autowired
    private List<FlowStatusAdapter> flowStatusAdapters;

    @Override
    public void load() {
        logger.info("\u52a0\u8f7d\u6d41\u7a0bbean\u4e2d");
        FlowsNode flowsNode = (FlowsNode)this.parseNote.pareNote();
        this.initFlow(this.flowFactory, false, flowsNode);
        this.initAction(this.flowFactory, flowsNode);
        logger.info("\u52a0\u8f7d\u6d41\u7a0bbean\u7ed3\u675f");
    }

    @Override
    public IFlowEngine bindFlowDefFromXml() {
        IFlowEngine flowEngine = this.fetchFlowEngineFromXml();
        this.bindXmlBaseFlow(flowEngine);
        return flowEngine;
    }

    @Override
    public IFlowEngine fetchFlowEngineFromXml() {
        FlowsNode flowsNode = (FlowsNode)this.parseNote.pareNote();
        FlowEngineImpl flowEngine = new FlowEngineImpl();
        flowEngine.setRootNode(flowsNode);
        this.initFlow(flowEngine, false, flowsNode);
        this.initAction(flowEngine, flowsNode);
        return flowEngine;
    }

    private void bindXmlBaseFlow(IFlowEngine flowEngine) {
        List<IFlow> flows = flowEngine.getFlows();
        for (IFlow flow : flows) {
            this.flowSchemeFactory.bind(Long.valueOf(flow.getFlowNode().getFlowId()), flow.getFlowName(), flow.getFlowNode().getFlowStatusAdapter(), flow.getFlowStatusAdapter().getGroup(), flow.getFlowStatusAdapter().getGroupName());
        }
    }

    @Override
    public void reLoad(String fileName) {
        logger.info("\u91cd\u65b0\u52a0\u8f7d\u6d41\u7a0bbean\u4e2d");
        logger.info("\u91cd\u65b0\u52a0\u8f7d\u6d41\u7a0bbean\u7ed3\u675f");
    }

    @Override
    public void reLoad(List<ImageFlow> imageFlows) {
        logger.info("\u91cd\u65b0\u52a0\u8f7d\u6d41\u7a0bbean\u4e2d");
        FlowsNode flowsNode = (FlowsNode)this.parseNote.pareNote(imageFlows);
        FlowEngineImpl flowEngine = new FlowEngineImpl();
        this.initFlow(flowEngine, true, flowsNode);
        this.initAction(flowEngine, flowsNode);
        this.clearOldData();
        for (FlowStatusAdapter flowStatusAdapter : this.flowStatusAdapters) {
            flowStatusAdapter.finishReload();
        }
        for (IFlow flow : flowEngine.getFlows()) {
            this.flowFactory.addFlow(flow.getFlowName(), flow);
        }
        logger.info("\u91cd\u65b0\u52a0\u8f7d\u6d41\u7a0bbean\u4e2d");
    }

    public void clearOldData() {
        this.flowFactory.clear();
    }

    private void initFlow(IFlowEngine flowEngine, boolean ifReload, FlowsNode flowsNode) {
        for (FlowNode flowNode : flowsNode.getFlowNodes()) {
            FlowStatusAdapter flowStatusAdapter = (FlowStatusAdapter)SpringBootBeanUtil.getBean(flowNode.getFlowStatusAdapter());
            FlowImpl flow = new FlowImpl(flowStatusAdapter, this.tradeService, flowEngine, this.flowLockService);
            for (ActionNode actionNode : flowNode.getActionNodeMap().values()) {
                if (!(actionNode instanceof StatusNode)) continue;
                if (ifReload) {
                    flowStatusAdapter.addReloadStatus(flowNode.getName(), (StatusNode)actionNode);
                    continue;
                }
                flowStatusAdapter.addStatus(flowNode.getName(), (StatusNode)actionNode);
            }
            flowNode.setEntityClass(flowStatusAdapter.getEntityClass().getName());
            flowNode.setBaseAction(flow);
            flow.setFlowNode(flowNode);
            if (flowNode.getVersion() == null) {
                flowNode.setVersion("0");
            }
            flowEngine.addFlow(flowNode.getName(), flow);
            if (flowNode.getEnable().booleanValue()) {
                flowEngine.addFlow(flowNode.getName(), flow);
            }
            for (ActionNode actionNode : flowNode.getActionNodeMap().values()) {
                flow.addActionNote(actionNode.getName(), actionNode);
            }
            flow.setStartActionNote(flowNode.getStartActionNote());
        }
        List<IFlow> flows = flowEngine.getFlows();
        for (IFlow flowCheck : flows) {
            FlowNode checkFlowNode = flowCheck.getFlowNode();
            for (ActionNode actionNode : checkFlowNode.getActionNodeMap().values()) {
                for (ActionNode nextActionNote : actionNode.getNextActionNoteList()) {
                    if (!(nextActionNote instanceof FlowActionNode)) continue;
                    FlowActionNode flowActionNode = (FlowActionNode)nextActionNote;
                    IFlow refFlow = flowEngine.getFlow(flowActionNode.getFlowName());
                    ActionNode startActionNote = refFlow.getStartActionNote();
                    if (startActionNote.getName().equals(flowActionNode.getFlowActionName())) {
                        if (StringUtils.isEmpty((Object)flowActionNode.getFlowNoFieldName())) continue;
                        throw new BizException(flowCheck.getFlowName() + "actionNote=" + nextActionNote.getName() + ",next flowAction =" + flowActionNode.getFlowActionName() + ",flowNoField \u4e0d\u80fd\u6709\u503c\uff0c\u56e0\u4e3a\u5f15\u7528\u7684\u662f\u542f\u52a8start_action");
                    }
                    if (!StringUtils.isEmpty((Object)flowActionNode.getFlowNoFieldName())) continue;
                    throw new BizException("flowNote=" + flowCheck.getFlowName() + "actionNote=" + nextActionNote.getName() + ",next flowAction =" + flowActionNode.getFlowActionName() + "\uff0cflowNoField \u4e0d\u80fd\u4e3a\u7a7a\uff0c\u56e0\u4e3a\u5f15\u7528\u7684\u4e0d\u662fstart_action");
                }
            }
        }
    }

    private void initAction(IFlowEngine flowEngine, FlowsNode flowsNode) {
        for (FlowNode flowNode : flowsNode.getFlowNodes()) {
            for (ActionNode actionNode : flowNode.getActionNodeMap().values()) {
                actionNode.setEntityClass(flowNode.getEntityClass());
                if (!(actionNode instanceof StatusNode)) {
                    BaseAction baseAction;
                    if (!StringUtils.isEmpty((Object)actionNode.getNodeBeanName())) {
                        baseAction = (BaseAction)SpringBootBeanUtil.getBean(actionNode.getNodeBeanName());
                        if (baseAction == null) {
                            throw new BizException("[" + flowNode.getName() + "][" + actionNode.getName() + "] \u7684 bean \u65e0\u6548");
                        }
                    } else {
                        baseAction = this.actionInstanceCreator.buildAction(flowEngine, actionNode, flowNode);
                    }
                    actionNode.setBaseAction(baseAction);
                    continue;
                }
                this.actionInstanceCreator.initStatusNode((StatusNode)actionNode, flowNode);
            }
        }
    }
}

