/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.flow.base.node;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.node.ActionNode;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.node.ForActionNode;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.node.StatusValue;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusNode
extends ActionNode {
    private static final Logger logger = LoggerFactory.getLogger(StatusNode.class);
    private String bizStatus;
    private List<StatusValue> statusValues = new ArrayList<StatusValue>();
    private Map<String, ForActionNode> canDoMap = new HashMap<String, ForActionNode>();
    private Map<String, ActionNode> canDoActionMap = new HashMap<String, ActionNode>();

    public void setFieldValue(Object entity) {
        for (StatusValue statusValue : this.statusValues) {
            try {
                statusValue.getField().set(entity, statusValue.getValue());
            }
            catch (IllegalAccessException e) {
                logger.error("\u8bbe\u7f6e\u72b6\u6001\u503c\u53d1\u751f\u9519\u8bef", (Throwable)e);
                throw new BizException("\u6d41\u7a0b\u8bbe\u7f6e\u72b6\u6001\u503c\u53d1\u751f\u9519\u8bef");
            }
        }
    }

    public String getCode() {
        String code = "";
        int i = 0;
        for (StatusValue statusValue : this.statusValues) {
            code = i == 0 ? statusValue.getValue() : code + ";" + statusValue.getValue();
            ++i;
        }
        return code;
    }

    public String getStatusType() {
        String type = "";
        int i = 0;
        for (StatusValue statusValue : this.statusValues) {
            type = i == 0 ? statusValue.getFieldName() : type + ";" + statusValue.getFieldName();
            ++i;
        }
        return type;
    }

    public List<StatusValue> getStatusValues() {
        return this.statusValues;
    }

    public boolean valid(ActionNode nextAction) {
        ForActionNode forActionNode = this.canDoMap.get(nextAction.getName());
        return forActionNode != null;
    }

    @Override
    public void addNextAction(String forName, ActionNode actionNode) {
        this.canDoActionMap.put(actionNode.getName(), actionNode);
        super.addNextAction(forName, actionNode);
    }

    @Override
    public List<ForActionNode> getForActionNoteList() {
        return this.canDoMap.values().stream().collect(Collectors.toList());
    }

    @Override
    public List<ActionNode> getNextActionNoteList() {
        return this.canDoActionMap.values().stream().collect(Collectors.toList());
    }

    @Override
    public void addNextForAction(String forName, ForActionNode forActionNode) {
        this.canDoMap.put(forActionNode.getActionName(), forActionNode);
        super.addNextForAction(forName, forActionNode);
    }

    @Override
    public void init() {
        String[] statusList;
        if (StringUtils.isEmpty((CharSequence)this.bizStatus)) {
            return;
        }
        for (String status : statusList = this.bizStatus.split(";")) {
            String[] keyValue = status.split("->");
            StatusValue statusValue = new StatusValue();
            if (keyValue.length <= 1) {
                throw new BizException("\u5f53\u524d\u72b6\u6001\u8282\u70b9" + this.getName() + "bizStatus\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
            statusValue.setFieldName(keyValue[0]);
            statusValue.setValue(keyValue[1]);
            this.statusValues.add(statusValue);
        }
        this.statusValues.sort(Comparator.comparing(StatusValue::getFieldName));
        super.init();
    }

    public static String getSortKey(List<StatusValue> statusValues) {
        String statusKey = "";
        for (StatusValue statusValue : statusValues) {
            statusKey = statusKey + "_field_" + statusValue.getFieldName() + "_" + statusValue.getValue();
        }
        return statusKey;
    }

    public List<StatusValue> getStatusValueList() {
        return this.statusValues;
    }

    public String getBizStatus() {
        return this.bizStatus;
    }

    public void setBizStatus(String bizStatus) {
        this.bizStatus = bizStatus;
    }

    public String getStatusKey() {
        return StatusNode.getSortKey(this.statusValues);
    }
}

