/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.flow.base.refresh;

import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.IFlowEngine;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.refresh.FlowRefreshService;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.refresh.PublishMQDesc;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@PublishMQDesc(topic="FLOW_PUBLISH_TOPIC", tag="FLOW_SOLUTION_MQ_TAG", msgType="publish")
public class FlowRefreshProcess
implements IMessageProcessor<String> {
    private Logger logger = LoggerFactory.getLogger(FlowRefreshProcess.class);
    @Resource
    private FlowRefreshService flowRefreshService;
    public boolean ifRefresh = true;
    public final Integer READ_FROM_DATA = 1;
    @Value(value="${yundt.cube.flow.read}")
    private Integer readFlag = 0;
    @Resource
    public IFlowEngine flowEngine;

    @Transactional(rollbackFor={Exception.class})
    public MessageResponse process(String dataDto) {
        Thread.currentThread().setName("FLOW_RE_" + System.currentTimeMillis() + "_Thread");
        this.logger.info("\u6536\u5230\u6d41\u7a0b\u5237\u65b0\u6d88\u606f");
        try {
            if (this.ifRefresh && this.READ_FROM_DATA.equals(this.readFlag)) {
                if (!this.flowEngine.modifyStatus(IFlowEngine.RE_LOADED)) {
                    this.logger.info("\u6d41\u7a0b\u5f15\u64ce\u72b6\u6001\u4e3a{},\u52a0\u8f7d\u5931\u8d25~\uff0c\u91cd\u65b0\u52a0\u8f7d", (Object)this.flowEngine.getStatus());
                    return MessageResponse.ERROR;
                }
                boolean refresh = this.flowRefreshService.refresh();
                if (!refresh) {
                    return MessageResponse.ERROR;
                }
            } else {
                this.logger.info("\u4e0d\u5237\u65b0");
            }
        }
        catch (Exception e) {
            this.logger.error("\u5237\u65b0\u6d41\u7a0b\u65b9\u6848\u62a5\u9519", (Throwable)e);
        }
        this.flowEngine.modifyStatus(IFlowEngine.LOADED);
        this.logger.info("\u5904\u7406\u6d41\u7a0b\u5237\u65b0\u6d88\u606f\u5b8c\u6bd5");
        return MessageResponse.SUCCESS;
    }
}

