/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.flow.newaction;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.enhance.CubeResource;
import com.dtyunxi.cube.enhance.flow.ActionNode;
import com.dtyunxi.cube.enhance.flow.ActionNodeComponent;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.rebate.api.IBalanceApi;
import com.dtyunxi.yundt.cube.center.rebate.api.constants.ChangeTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.BalanceReturnReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.constants.tob.AuditTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.exception.TradeExceptionCode;
import com.dtyunxi.yundt.cube.center.trade.api.utils.EoUtil;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderService;
import com.dtyunxi.yundt.cube.center.trade.biz.util.Assert;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderAuditDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderAuditEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderEo;
import com.dtyunxi.yundt.cube.center.trade.ext.api.constants.OrderAuditType;
import com.dtyunxi.yundt.cube.center.trade.ext.api.dto.request.OrderAuditReqDto;
import com.dtyunxi.yundt.cube.center.trade.ext.order.IAuditOrderActionExtPt;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.OrderAuditBo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="auditOrderFlowAction")
@ActionNodeComponent
public class AuditOrderFlowAction {
    @Resource
    private IBalanceApi iBalanceApi;
    @CubeResource
    IAuditOrderActionExtPt auditOrderActionExtPt;
    @Resource
    OrderAuditDas orderAuditDas;
    @Resource
    OrderDas orderDas;
    @Resource
    IOrderService orderService;

    @ActionNode(entity=OrderEo.class, name="\u5ba1\u6838\u8ba2\u5355", isStart=true)
    @Transactional(rollbackFor={Exception.class})
    public OrderAuditBo auditOrder(OrderAuditBo orderAuditBo) {
        OrderAuditReqDto orderAuditReqDto = (OrderAuditReqDto)EoUtil.transformExtFieldsToDto((BaseVo)orderAuditBo.getOrderAuditReqDto(), (Class)this.auditOrderActionExtPt.getDtoClass());
        orderAuditReqDto = this.validate(orderAuditReqDto);
        orderAuditBo = this.packBo(orderAuditBo, orderAuditReqDto);
        orderAuditBo = this.save(orderAuditBo, orderAuditReqDto);
        return this.postProcessor(orderAuditBo, orderAuditReqDto);
    }

    @ActionNode(entity=OrderEo.class, name="\u8d22\u52a1\u5ba1\u6838", isStart=true)
    @Transactional(rollbackFor={Exception.class})
    public OrderAuditBo auditFinanceOrder(OrderAuditBo orderAuditBo) {
        return this.auditOrder(orderAuditBo);
    }

    @ActionNode(entity=OrderEo.class, name="\u8ba2\u5355\u53cd\u5ba1\u6838", isStart=true)
    @Transactional(rollbackFor={Exception.class})
    public OrderAuditBo orderReturnAudit(OrderAuditBo orderAuditBo) {
        return this.auditOrder(orderAuditBo);
    }

    @ActionNode(entity=OrderEo.class, name="\u8ba2\u5355\u4e1a\u52a1\u53cd\u5ba1\u6838", isStart=true)
    @Transactional(rollbackFor={Exception.class})
    public OrderAuditBo orderCsReturnAudit(OrderAuditBo orderAuditBo) {
        return this.auditOrder(orderAuditBo);
    }

    public OrderAuditBo changeOrderDeliveryType(OrderAuditBo orderAuditBo) {
        OrderAuditReqDto orderAuditReqDto = orderAuditBo.getOrderAuditReqDto();
        Integer deliveryType = orderAuditReqDto.getDeliveryType();
        if (deliveryType != null) {
            OrderEo orderEo = new OrderEo();
            ArrayList sqlFilters = Lists.newArrayList();
            sqlFilters.add(SqlFilter.eq((String)"order_no", (Object)orderAuditReqDto.getTradeNo()));
            orderEo.setDeliveryType(deliveryType);
            orderEo.setSqlFilters((List)sqlFilters);
            this.orderDas.updateSelectiveSqlFilter((BaseEo)orderEo);
        }
        return orderAuditBo;
    }

    private OrderAuditBo postProcessor(OrderAuditBo orderAuditBo, OrderAuditReqDto orderAuditReqDto) {
        this.orderService.publishWhenOrderTradeStatusChange(orderAuditBo.getOrderEo(), orderAuditBo.getOrderEo().getOrderTradeStatus());
        return this.auditOrderActionExtPt.postProcessor(orderAuditBo, orderAuditReqDto);
    }

    private OrderAuditBo save(OrderAuditBo orderAuditBo, OrderAuditReqDto orderAuditReqDto) {
        this.orderAuditDas.insert((BaseEo)orderAuditBo.getOrderAuditEo());
        OrderEo orderEo = orderAuditBo.getOrderEo();
        orderEo.setUpdateTime(null);
        orderEo.setOrderTradeStatus(orderAuditReqDto.getOrderTradeStatus());
        this.orderDas.updateSelective((BaseEo)orderEo);
        return this.auditOrderActionExtPt.save(orderAuditBo, orderAuditReqDto);
    }

    private void returnRebate(OrderAuditBo orderAuditBo) {
        OrderEo orderEo = orderAuditBo.getOrderEo();
        if (AuditTypeEnum.CS_AUDIT.getType().equals(orderAuditBo.getOrderAuditReqDto().getAuditType()) && 0 == orderAuditBo.getOrderAuditReqDto().getAuditResult() && orderEo.getTotalRebateAmount() != null && orderEo.getTotalRebateAmount().compareTo(BigDecimal.ZERO) > 0) {
            BalanceReturnReqDto balanceReturnReqDto = new BalanceReturnReqDto();
            balanceReturnReqDto.setChangeType(ChangeTypeEnum.CANCEL_ORDER.toCode());
            balanceReturnReqDto.setOrderNo(orderEo.getOrderNo());
            balanceReturnReqDto.setRefundNo(null);
            balanceReturnReqDto.setReturnAmount(orderEo.getTotalRebateAmount());
            balanceReturnReqDto.setUserId(Long.valueOf(orderEo.getCustomerId()));
            this.iBalanceApi.returnBalance(balanceReturnReqDto);
        }
    }

    private OrderAuditBo packBo(OrderAuditBo orderAuditBo, OrderAuditReqDto orderAuditReqDto) {
        OrderEo orderEo = this.orderDas.findByOrderNo(orderAuditReqDto.getTradeNo());
        Integer deliveryType = orderAuditReqDto.getDeliveryType();
        if (deliveryType != null) {
            orderEo.setDeliveryType(deliveryType);
        }
        orderAuditBo.setOrderAuditEo(this.packOrderAuditEo(orderAuditReqDto, orderEo));
        orderAuditBo.setOrderEo(orderEo);
        return this.auditOrderActionExtPt.packBo(orderAuditBo, orderAuditReqDto);
    }

    private OrderAuditEo packOrderAuditEo(OrderAuditReqDto orderAuditReqDto, OrderEo orderEo) {
        OrderAuditEo orderAuditEo = new OrderAuditEo();
        DtoHelper.dto2Eo((BaseVo)orderAuditReqDto, (BaseEo)orderAuditEo);
        orderAuditEo.setAuditDesc(orderAuditReqDto.getAuditDesc());
        orderAuditEo.setAuditor(orderAuditReqDto.getAuditor());
        orderAuditEo.setLocalOrderNo(orderAuditReqDto.getTradeNo());
        orderAuditEo.setNewValue(orderAuditReqDto.getAuditResult().toString());
        orderAuditEo.setTradeNo(orderAuditReqDto.getTradeNo());
        orderAuditEo.setInstanceId(orderEo.getInstanceId());
        orderAuditEo.setTenantId(orderEo.getTenantId());
        if ("0".equals(orderEo.getParentOrderNo())) {
            orderAuditEo.setOrderType(OrderAuditType.PARENT_ORDER.toString());
        } else {
            orderAuditEo.setOrderType(OrderAuditType.CHILD_ORDER.toString());
        }
        return orderAuditEo;
    }

    private OrderAuditReqDto validate(OrderAuditReqDto orderAuditReqDto) {
        String orderNo = orderAuditReqDto.getTradeNo();
        OrderEo orderEo = this.orderDas.findByOrderNo(orderNo);
        Assert.notNull((Object)orderEo, TradeExceptionCode.ORDER_NO_EXIT);
        return this.auditOrderActionExtPt.validate(orderAuditReqDto);
    }
}

