/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.flow.newaction;

import com.dtyunxi.cube.enhance.CubeResource;
import com.dtyunxi.cube.enhance.flow.ActionNode;
import com.dtyunxi.cube.enhance.flow.ActionNodeComponent;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.biz.member.api.basis.query.IMemberInfoExtQueryApi;
import com.dtyunxi.yundt.cube.biz.member.api.point.IPointCashOutApi;
import com.dtyunxi.yundt.cube.biz.member.api.point.query.IPointsAccountQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.utils.EoUtil;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderService;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderEo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.IOrderCreateActionExtPt;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.OrderCreateBo;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ActionNodeComponent
public class CreateOrderFlowAction {
    private static Logger logger = LoggerFactory.getLogger(CreateOrderFlowAction.class);
    @CubeResource
    IOrderCreateActionExtPt orderCreateActionExtPt;
    @Resource
    private IOrderService orderService;
    @Autowired
    private IPointCashOutApi pointCashOutApi;
    @Autowired
    private IMemberInfoExtQueryApi memberInfoExtQueryApi;
    @Autowired
    private IPointsAccountQueryApi pointsAccountQueryApi;

    @ActionNode(entity=OrderEo.class, name="\u4e0b\u5355")
    @Transactional
    public OrderCreateBo createOrder(OrderCreateBo orderCreateBo) {
        OrderReqDto orderReq = orderCreateBo.getOrderReqDto();
        orderReq = (OrderReqDto)EoUtil.transformExtFieldsToDto((BaseVo)orderReq, (Class)this.orderCreateActionExtPt.getDtoClass());
        orderCreateBo.setOrderReqDto(orderReq);
        if (!Objects.equals("1", orderReq.getSubmitType())) {
            orderReq = this.validate(orderReq);
            orderCreateBo = this.subOrderStock(orderCreateBo, orderReq);
        }
        orderCreateBo = this.packBo(orderCreateBo, orderReq);
        orderCreateBo = this.preCompute(orderCreateBo, orderReq);
        orderCreateBo = this.save(orderCreateBo, orderReq);
        return this.postProcessor(orderCreateBo, orderReq);
    }

    public void checkAndRollBackErrorOrder(OrderCreateBo orderCreateBo) {
        this.orderCreateActionExtPt.rollBackOrder(orderCreateBo, orderCreateBo.getOrderReqDto());
    }

    private OrderCreateBo subOrderStock(OrderCreateBo orderBo, OrderReqDto orderReq) {
        orderBo = this.orderCreateActionExtPt.subOrderStock(orderBo, orderReq);
        return orderBo;
    }

    @ActionNode(entity=OrderEo.class, name="\u662f\u5426\u63d0\u4ea4\u8ba2\u5355")
    public String isSubmitOrder(OrderCreateBo orderBo) {
        if (orderBo.getOrderReqDto().getSubmitType() != null && orderBo.getOrderReqDto().getSubmitType().equals("1")) {
            return "FALSE";
        }
        return "TRUE";
    }

    @ActionNode(entity=OrderEo.class, name="\u63d0\u4ea4\u8ba2\u5355")
    public OrderCreateBo submitOrder(OrderCreateBo orderBo) {
        return orderBo;
    }

    public OrderCreateBo updateOrder(OrderCreateBo orderBo) {
        OrderReqDto orderReq = orderBo.getOrderReqDto();
        orderReq = (OrderReqDto)EoUtil.transformExtFieldsToDto((BaseVo)orderReq, (Class)this.orderCreateActionExtPt.getDtoClass());
        orderBo.setOrderReqDto(orderReq);
        orderReq = this.validate(orderReq);
        OrderCreateBo orderCreateBo = this.packBo_update(orderBo, orderReq);
        orderCreateBo = this.save_update(orderCreateBo, orderReq);
        return orderCreateBo;
    }

    private OrderReqDto validate(OrderReqDto orderReq) {
        return this.orderCreateActionExtPt.validate(orderReq);
    }

    private OrderCreateBo packBo(OrderCreateBo orderCreateBo, OrderReqDto orderReq) {
        orderCreateBo = this.orderService.packOrderBaseDetailInfo(orderCreateBo);
        orderCreateBo = this.orderCreateActionExtPt.packBo(orderCreateBo, orderReq);
        return orderCreateBo;
    }

    private OrderCreateBo preCompute(OrderCreateBo orderBo, OrderReqDto orderReq) {
        orderBo = this.orderCreateActionExtPt.calcAmount(orderBo, orderReq);
        orderBo = this.orderCreateActionExtPt.splitOrder(orderBo, orderReq);
        return orderBo;
    }

    @Transactional
    public OrderCreateBo save(OrderCreateBo orderBo, OrderReqDto orderReq) {
        this.orderService.saveOrderBaseDetailInfo(orderBo);
        orderBo = this.orderCreateActionExtPt.preJoinActivity(orderBo, orderReq);
        orderBo = this.orderCreateActionExtPt.save(orderBo, orderReq);
        return orderBo;
    }

    private OrderCreateBo postProcessor(OrderCreateBo orderBo, OrderReqDto orderReq) {
        return this.orderCreateActionExtPt.postProcessor(orderBo, orderReq);
    }

    private OrderCreateBo packBo_update(OrderCreateBo orderCreateBo, OrderReqDto orderReq) {
        orderCreateBo = this.orderService.packOrderBaseDetailInfoForUpdate(orderCreateBo);
        orderCreateBo = this.orderCreateActionExtPt.packBo_update(orderCreateBo, orderReq);
        return orderCreateBo;
    }

    @Transactional
    public OrderCreateBo save_update(OrderCreateBo orderBo, OrderReqDto orderReq) {
        this.orderService.saveOrderBaseDetailInfoForUpdate(orderBo);
        orderBo = this.orderCreateActionExtPt.save_update(orderBo, orderReq);
        return orderBo;
    }
}

