/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.flow.newaction;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.enhance.flow.ActionNodeComponent;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.DeliveryCancelTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.DeliverySplitFlagEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.DeliveryStatusEnum;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.DeliveryBizTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.IfMergeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.SaleChannelEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ShippingTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.utils.TradeUtil;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.vo.DeliveryVo;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IDeliveryRouterService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IDeliverySplitService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderDeliveryService;
import com.dtyunxi.yundt.cube.center.trade.dao.das.DeliveryItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderAddressDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderDeliveryDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.RefDeliveryOrderDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.TradeItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.DeliveryItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderAddressEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderDeliveryEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.RefDeliveryOrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.TradeItemEo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.DeliveryOrderVo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.GenerateDeliveryBo;
import com.dtyunxi.yundt.cube.connector.comm.dto.request.ReceiverInfoReqDto;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="generateDeliveryFlowAction")
@ActionNodeComponent
public class GenerateDeliveryFlowAction {
    private static Logger logger = LoggerFactory.getLogger(GenerateDeliveryFlowAction.class);
    @Resource
    protected IOrderDeliveryService orderDeliveryService;
    @Resource
    protected OrderDeliveryDas orderDeliveryDas;
    @Autowired
    private OrderDas orderDas;
    @Autowired
    private OrderAddressDas orderAddressDas;
    @Resource
    private IDeliveryRouterService deliveryRouterService;
    @Resource
    private TradeItemDas tradeItemDas;
    @Resource
    private IDeliverySplitService deliverySplitService;
    @Resource
    private RefDeliveryOrderDas refDeliveryOrderDas;
    @Resource
    private DeliveryItemDas deliveryItemDas;
    @Resource
    private IShopQueryApi shopQueryApi;

    @Transactional
    public GenerateDeliveryBo create(GenerateDeliveryBo generateDeliveryBo) {
        logger.info("\u5f00\u59cb\u5904\u7406\u6839\u636e\u8ba2\u5355\u751f\u6210\u53d1\u8d27\u5355\u6d41\u7a0b\uff0c\u5165\u53c2generateDeliveryBo\uff1a{}", (Object)JSON.toJSONString((Object)generateDeliveryBo));
        String orderNo = generateDeliveryBo.getOrderNo();
        OrderEo orderSelect = OrderEo.newInstance();
        orderSelect.setOrderNo(orderNo);
        OrderEo order = (OrderEo)this.orderDas.selectOne((BaseEo)orderSelect);
        RefDeliveryOrderEo refDeliveryOrderSelect = RefDeliveryOrderEo.newInstance();
        refDeliveryOrderSelect.setOrderNo(generateDeliveryBo.getOrderNo());
        int count = this.refDeliveryOrderDas.count((BaseEo)refDeliveryOrderSelect);
        if (count >= 1) {
            logger.info("\u8ba2\u5355\uff1a{}\u5bf9\u5e94\u7684\u53d1\u8d27\u5355\u5df2\u5b58\u5728\uff0c\u4e0d\u5f80\u4e0b\u8d70\u6d41\u7a0b\u2026\u2026", (Object)generateDeliveryBo.getOrderNo());
            generateDeliveryBo.setToStatus(null);
            return generateDeliveryBo;
        }
        OrderDeliveryEo orderDeliveryEo = OrderDeliveryEo.newInstance();
        this.handleOrderDelivery(orderDeliveryEo, order);
        String deliveryNo = orderDeliveryEo.getDeliveryNo();
        ArrayList<RefDeliveryOrderEo> refDeliveryOrders = new ArrayList<RefDeliveryOrderEo>();
        this.handleRefDeliveryOrder(refDeliveryOrders, orderDeliveryEo, order);
        ArrayList<DeliveryItemEo> deliveryItemEos = new ArrayList<DeliveryItemEo>();
        this.handleDeliveryItems(deliveryItemEos, order, deliveryNo);
        generateDeliveryBo.setOrderDeliveryEo(orderDeliveryEo);
        DeliveryOrderVo deliveryOrderVo = new DeliveryOrderVo();
        deliveryOrderVo.setOrderDelivery(orderDeliveryEo);
        deliveryOrderVo.setRefDeliveryOrders(refDeliveryOrders);
        deliveryOrderVo.setDeliveryItems(deliveryItemEos);
        if (DeliveryStatusEnum.TO_CONFIRM.getStatus().equals(orderDeliveryEo.getDeliveryStatus())) {
            this.handleAutoSplit(deliveryOrderVo, generateDeliveryBo);
        }
        this.refDeliveryOrderDas.insertBatch(refDeliveryOrders);
        this.deliveryItemDas.insertBatch(deliveryItemEos);
        generateDeliveryBo.setToStatus(orderDeliveryEo.getDeliveryStatus());
        generateDeliveryBo.setDeliveryItemEoList(deliveryItemEos);
        generateDeliveryBo.setRefDeliveryOrderEo((RefDeliveryOrderEo)refDeliveryOrders.get(0));
        logger.info("\u6839\u636e\u5168\u6e20\u9053\u8ba2\u5355\u751f\u6210\u53d1\u8d27\u5355\u6210\u529f\uff0c\u8ba2\u5355\u53f7\uff1a{}\uff0c\u751f\u6210\u53d1\u8d27\u5355\u4fe1\u606f\uff1a{}", (Object)generateDeliveryBo.getOrderNo(), (Object)JSON.toJSONString((Object)generateDeliveryBo));
        return generateDeliveryBo;
    }

    private void handleAutoSplit(DeliveryOrderVo deliveryOrderVo, GenerateDeliveryBo generateDeliveryBo) {
        OrderDeliveryEo orderDeliveryEo = deliveryOrderVo.getOrderDelivery();
        List<DeliveryVo> autoSplitDeliveryList = this.deliverySplitService.getAutoSplitDelivery(deliveryOrderVo);
        if (CollectionUtils.isNotEmpty(autoSplitDeliveryList) && autoSplitDeliveryList.size() > 1) {
            orderDeliveryEo.setDeliveryStatus(DeliveryStatusEnum.CANCELED.getStatus());
            orderDeliveryEo.setCancelType(DeliveryCancelTypeEnum.AUTO_SPILT_CANCEL.getType());
            orderDeliveryEo.setCancelDesc(DeliveryCancelTypeEnum.AUTO_SPILT_CANCEL.getDesc());
            orderDeliveryEo.setSplitFlag(DeliverySplitFlagEnum.SPLIT.getFlag());
            orderDeliveryEo.setIfMerge(IfMergeEnum.NO_MERGE.getCode());
            orderDeliveryEo.setCancelTime(new Date());
            ArrayList deliveryChildList = new ArrayList();
            autoSplitDeliveryList.forEach(autoSplitDelivery -> {
                List<DeliveryItemEo> deliveryItems = autoSplitDelivery.getDeliveryItems();
                OrderDeliveryEo orderDelivery = autoSplitDelivery.getOrderDelivery();
                orderDelivery.setSplitFlag(DeliverySplitFlagEnum.SPLIT.getFlag());
                orderDelivery.setIfMerge(IfMergeEnum.NO_MERGE.getCode());
                List<RefDeliveryOrderEo> refDeliveryOrders = autoSplitDelivery.getRefDeliveryOrders();
                DeliveryOrderVo deliveryOrder = new DeliveryOrderVo();
                deliveryOrder.setOrderDelivery(orderDelivery);
                deliveryOrder.setDeliveryItems(deliveryItems);
                deliveryOrder.setRefDeliveryOrders(refDeliveryOrders);
                deliveryChildList.add(deliveryOrder);
            });
            generateDeliveryBo.setDeliveryChildList(deliveryChildList);
        }
    }

    private void handleRefDeliveryOrder(List<RefDeliveryOrderEo> refDeliveryOrders, OrderDeliveryEo orderDelivery, OrderEo order) {
        RefDeliveryOrderEo refDeliveryOrder = RefDeliveryOrderEo.newInstance();
        refDeliveryOrder.setOrderNo(order.getOrderNo());
        refDeliveryOrder.setDeliveryNo(orderDelivery.getDeliveryNo());
        refDeliveryOrder.setOriginOrderNo(order.getThirdOrderNo());
        refDeliveryOrder.setInstanceId(orderDelivery.getInstanceId());
        refDeliveryOrder.setTenantId(orderDelivery.getTenantId());
        refDeliveryOrders.add(refDeliveryOrder);
    }

    private void handleOrderDelivery(OrderDeliveryEo orderDeliveryEo, OrderEo orderEo) {
        OrderAddressEo addressSelect = new OrderAddressEo();
        addressSelect.setOrderNo(orderEo.getOrderNo());
        OrderAddressEo orderAddress = (OrderAddressEo)this.orderAddressDas.selectOne((BaseEo)addressSelect);
        if (null == orderAddress) {
            logger.warn("\u4fdd\u5b58\u53d1\u8d27\u5355\uff0c\u627e\u4e0d\u5230\u8ba2\u5355\u5bf9\u5e94\u7684\u5730\u5740\u4fe1\u606f\uff0corderNo:{}", (Object)orderEo.getOrderNo());
        }
        String deliveryNo = TradeUtil.generateTradeNo(orderEo.getOrderNo());
        orderDeliveryEo.setBizType(DeliveryBizTypeEnum.OMNI_CHANNEL.getType());
        orderDeliveryEo.setDeliveryNo(deliveryNo);
        orderDeliveryEo.setOrderNo(orderEo.getOrderNo());
        orderDeliveryEo.setThirdPayNo(orderEo.getThirdOrderNo());
        orderDeliveryEo.setSplitFlag(DeliverySplitFlagEnum.NOT_SPLIT.getFlag());
        orderDeliveryEo.setIfMerge(IfMergeEnum.NO_MERGE.getCode());
        orderDeliveryEo.setTotalAmount(orderEo.getTotalAmount());
        orderDeliveryEo.setItemAmount(orderEo.getTotalAmount());
        orderDeliveryEo.setDiscountAmount(orderEo.getDiscountAmount());
        orderDeliveryEo.setChannel(orderEo.getSaleChannel());
        if (null != orderAddress) {
            String address = orderAddress.getAddress();
            if (StringUtils.isEmpty((CharSequence)address) && StringUtils.isNotEmpty((CharSequence)orderAddress.getDetailed())) {
                address = orderAddress.getDetailed();
            }
            orderDeliveryEo.setDeliveryName(orderAddress.getDeliveryName());
            orderDeliveryEo.setAddress(address);
            orderDeliveryEo.setDeliveryMobile(orderAddress.getDeliveryMobile());
            orderDeliveryEo.setDeliveryPhone(orderAddress.getDeliveryPhone());
            orderDeliveryEo.setProvinceName(orderAddress.getProvinceName());
            orderDeliveryEo.setCityName(orderAddress.getCityName());
            orderDeliveryEo.setAreaName(orderAddress.getAreaName());
            orderDeliveryEo.setStreetName(orderAddress.getStreetName());
            orderDeliveryEo.setDetailed(orderAddress.getAddress());
            orderDeliveryEo.setPostcode(orderAddress.getPostcode());
            orderDeliveryEo.setCancelType(DeliveryCancelTypeEnum.NOT_CANCLE.getType());
            orderDeliveryEo.setCompany(orderAddress.getCompany());
            orderDeliveryEo.setIdentityType(orderAddress.getIdentityType());
            orderDeliveryEo.setIdentityNo(orderAddress.getIdentityNo());
            orderDeliveryEo.setEmail(orderAddress.getEmail());
            orderDeliveryEo.setCountryCode(orderAddress.getCountryCode());
            orderDeliveryEo.setShippingType(orderAddress.getShippingType());
        } else {
            logger.warn("\u751f\u6210\u53d1\u8d27\u5355\u7684\u65f6\u5019\u672a\u627e\u5230\u8ba2\u5355\u5bf9\u5e94\u7684\u6536\u4ef6\u4eba\u4fe1\u606f\uff0corderNo:{}, deliveryNo:{}", (Object)orderEo.getOrderNo(), (Object)deliveryNo);
        }
        orderDeliveryEo.setInstanceId(orderEo.getInstanceId());
        orderDeliveryEo.setTenantId(orderEo.getTenantId());
        orderDeliveryEo.setOrganizationId(orderEo.getOrganizationId());
        orderDeliveryEo.setOrganizationName(orderEo.getOrganizationName());
        orderDeliveryEo.setShopId(orderEo.getShopId());
        orderDeliveryEo.setShopCode(orderEo.getShopCode());
        Boolean autoReceive = false;
        ShopBaseDto shop = null;
        if (StringUtils.isNotEmpty((CharSequence)orderEo.getShopId())) {
            shop = (ShopBaseDto)this.shopQueryApi.queryBaseById(Long.valueOf(Long.parseLong(orderEo.getShopId()))).getData();
        }
        if (null != shop) {
            orderDeliveryEo.setShopCode(shop.getCode());
            autoReceive = null != shop.getAutoReceive() ? shop.getAutoReceive() : false;
        }
        if (SaleChannelEnum.SALECHANNEL_ZYSC.getCode().equals(orderEo.getSaleChannel())) {
            String shippingType = orderDeliveryEo.getShippingType();
            if (Arrays.asList(ShippingTypeEnum.INTRA_CITY.getType(), ShippingTypeEnum.PICKUP.getType()).contains(shippingType)) {
                if (autoReceive.booleanValue()) {
                    orderDeliveryEo.setDeliveryStatus(DeliveryStatusEnum.INIT.getStatus());
                } else {
                    orderDeliveryEo.setDeliveryStatus(DeliveryStatusEnum.TO_RECEIVING.getStatus());
                }
            } else {
                orderDeliveryEo.setDeliveryStatus(DeliveryStatusEnum.INIT.getStatus());
            }
            return;
        }
        int deliveryConfirmMin = this.deliveryRouterService.getDeliveryConfirmMin();
        if (deliveryConfirmMin > 0) {
            orderDeliveryEo.setDeliveryStatus(DeliveryStatusEnum.TO_CONFIRM.getStatus());
            logger.info("\u53d1\u8d27\u5355\u8bbe\u7f6e\u5f85\u786e\u8ba4\u65f6\u95f4\u4e3a\uff1a{}min\uff0c\u53d1\u8d27\u5355\u8bbe\u7f6e\u4e3a\u5f85\u786e\u8ba4\u72b6\u6001\u3002", (Object)deliveryConfirmMin);
            return;
        }
        Boolean routerConfigOpen = this.deliveryRouterService.checkRouterConfigOpen(orderEo, orderDeliveryEo);
        if (routerConfigOpen.booleanValue()) {
            orderDeliveryEo.setDeliveryStatus(DeliveryStatusEnum.TO_ROUTE.getStatus());
            return;
        }
        orderDeliveryEo.setDeliveryStatus(DeliveryStatusEnum.TO_DO.getStatus());
        orderDeliveryEo.clearWarehouse();
    }

    private String getFullAddress(ReceiverInfoReqDto receiverInfo) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)receiverInfo.getProvince())) {
            sb.append(receiverInfo.getProvince());
        }
        if (StringUtils.isNotBlank((CharSequence)receiverInfo.getCity())) {
            sb.append(receiverInfo.getCity());
        }
        if (StringUtils.isNotBlank((CharSequence)receiverInfo.getArea())) {
            sb.append(receiverInfo.getArea());
        }
        if (StringUtils.isNotBlank((CharSequence)receiverInfo.getTown())) {
            sb.append(receiverInfo.getTown());
        }
        if (StringUtils.isNotBlank((CharSequence)receiverInfo.getDetailAddress())) {
            sb.append(receiverInfo.getDetailAddress());
        }
        return sb.toString();
    }

    private void handleDeliveryItems(List<DeliveryItemEo> deliveryItemEos, OrderEo order, String deliveryNo) {
        TradeItemEo tradeItemSelect = TradeItemEo.newInstance();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"trade_no", (Object)order.getOrderNo()));
        tradeItemSelect.setSqlFilters(sqlFilters);
        List tradeItems = this.tradeItemDas.select((BaseEo)tradeItemSelect);
        if (CollectionUtils.isEmpty((Collection)tradeItems)) {
            logger.error("\u53d1\u8d27\u5355\u4fdd\u5b58\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8ba2\u5355\u5546\u54c1\u4fe1\u606f\uff0corderNo\uff1a{}", (Object)order.getOrderNo());
            throw new BizException("\u53d1\u8d27\u5355\u4fdd\u5b58\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8ba2\u5355\u5546\u54c1\u4fe1\u606f");
        }
        for (TradeItemEo tradeItem : tradeItems) {
            DeliveryItemEo deliveryItemEo = DeliveryItemEo.newInstance();
            deliveryItemEo.setTradeNo(tradeItem.getTradeNo());
            deliveryItemEo.setDeliveryNo(deliveryNo);
            deliveryItemEo.setTrOrderItemNo(tradeItem.getId().toString());
            deliveryItemEo.setCargoSerial(tradeItem.getCargoSerial());
            deliveryItemEo.setItemNum(tradeItem.getItemNum());
            deliveryItemEo.setDeliveryType("NORMAL");
            deliveryItemEo.setDeliverySubType("NORMAL");
            deliveryItemEo.setSkuSerial(tradeItem.getSkuSerial());
            deliveryItemEo.setSkuCode(tradeItem.getSkuCode());
            deliveryItemEo.setSkuDesc(tradeItem.getSkuDesc());
            deliveryItemEo.setItemName(tradeItem.getItemName());
            deliveryItemEo.setItemCode(tradeItem.getItemCode());
            deliveryItemEo.setItemPrice(tradeItem.getItemPrice());
            deliveryItemEo.setItemOrigPrice(tradeItem.getItemOrigPrice());
            String extension = tradeItem.getExtension();
            if (StringUtils.isNotBlank((CharSequence)extension)) {
                JSONObject extensionObj = JSON.parseObject((String)extension);
                deliveryItemEo.setItemImgPath(extensionObj.getString("imgPath"));
            }
            deliveryItemEo.setInstanceId(tradeItem.getInstanceId());
            deliveryItemEo.setTenantId(tradeItem.getTenantId());
            deliveryItemEos.add(deliveryItemEo);
        }
    }
}

