/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.flow.newaction;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.enhance.CubeResource;
import com.dtyunxi.cube.enhance.flow.ActionNode;
import com.dtyunxi.cube.enhance.flow.ActionNodeComponent;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.yundt.cube.center.payment.dto.notify.PayOrderNotifyRequest;
import com.dtyunxi.yundt.cube.center.trade.api.constants.PayStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.RefundReqDto;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.IFlowLockService;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.OrderPayedEvent;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.newaction.OrderFlowAction;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderService;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.PayRecordDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.PayRecordEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdPayRecordEo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.IOrderCreateActionExtPt;
import com.dtyunxi.yundt.cube.center.trade.ext.order.IPayNotifyActionExtPt;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.PayOrderNotifyBo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.RefundCreateBo;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="payNotifyFlowAction")
@ActionNodeComponent
public class PayNotifyFlowAction {
    @Resource
    protected IFlowLockService flowLockService;
    private static Logger logger = LoggerFactory.getLogger(PayNotifyFlowAction.class);
    private static final String PAY_NOTIFY_STATUS_SUCC = "S";
    @Resource
    private PayRecordDas payRecordDas;
    @CubeResource
    private IPayNotifyActionExtPt payNotifyActionExtPt;
    @CubeResource
    private IOrderCreateActionExtPt orderCreateActionExtPt;
    @Resource
    private OrderFlowAction orderFlowAction;
    @Resource
    private OrderDas orderDas;
    @Resource
    private IOrderService orderService;
    @Resource
    private ICacheService cacheService;

    @ActionNode(entity=PayRecordEo.class, name="\u652f\u4ed8\u56de\u8c03")
    @Transactional
    public PayOrderNotifyBo handleNotify(PayOrderNotifyBo payOrderNotifyBo) {
        PayOrderNotifyRequest notifyReq = payOrderNotifyBo.getPayOrderNotifyRequest();
        logger.info("\u8ba2\u5355\u652f\u4ed8\u56de\u8c03\u901a\u77e5: {}", JSON.toJSON((Object)notifyReq));
        notifyReq = this.validate(notifyReq);
        payOrderNotifyBo = this.packBo(payOrderNotifyBo, notifyReq);
        return payOrderNotifyBo;
    }

    @ActionNode(entity=PayRecordEo.class, name="\u652f\u4ed8\u6210\u529f")
    @Transactional
    public PayOrderNotifyBo paySuccess(PayOrderNotifyBo payOrderNotifyBo) {
        this.postProcessor(payOrderNotifyBo);
        return this.payNotifyActionExtPt.update(payOrderNotifyBo, payOrderNotifyBo.getPayOrderNotifyRequest());
    }

    @ActionNode(entity=PayRecordEo.class, name="\u901a\u77e5\u8ba2\u5355")
    @Transactional
    public OrderPayedEvent payNotifyOrder(PayOrderNotifyBo payOrderNotifyBo) {
        OrderPayedEvent orderPayedEvent = new OrderPayedEvent();
        String orderNo = payOrderNotifyBo.getPayRecordEo().getOrderNo();
        orderPayedEvent.setPayNo(payOrderNotifyBo.getPayRecordEo().getPayNo());
        orderPayedEvent.setOrderNo(orderNo);
        orderPayedEvent.setFinishTime(payOrderNotifyBo.getFinishTime());
        orderPayedEvent.setPayRecordEo(payOrderNotifyBo.getPayRecordEo());
        OrderEo orderEo = this.orderDas.findByOrderNo(orderNo);
        BigDecimal payAmount = orderEo.getPayAmount();
        PayRecordEo payRecordEo = PayRecordEo.newInstance();
        payRecordEo.setOrderNo(orderNo);
        List payRecordEos = this.payRecordDas.select((BaseEo)payRecordEo);
        BigDecimal reduce = payRecordEos.stream().filter(bean -> PayStatusEnum.SUCCESS.getName().equals(bean.getPayStatus())).map(StdPayRecordEo::getPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        orderPayedEvent.setResult("part");
        if (payAmount.compareTo(reduce) <= 0) {
            orderPayedEvent.setResult("all");
        }
        logger.info("[\u8ba2\u5355{}\u652f\u4ed8\u7ed3\u679c]:{}", (Object)orderNo, (Object)orderPayedEvent.getResult());
        logger.info("\u901a\u77e5\u8ba2\u5355:{}", (Object)JSON.toJSONString((Object)((Object)orderPayedEvent)));
        return orderPayedEvent;
    }

    public PayOrderNotifyBo postProcessor(PayOrderNotifyBo payOrderNotifyBo) {
        this.payNotifyActionExtPt.postProcessor(payOrderNotifyBo, payOrderNotifyBo.getPayOrderNotifyRequest(), "");
        return payOrderNotifyBo;
    }

    @ActionNode(entity=PayRecordEo.class, name="\u652f\u4ed8\u5931\u8d25")
    @Transactional
    public PayOrderNotifyBo payFail(PayOrderNotifyBo payOrderNotifyBo) {
        this.postProcessor(payOrderNotifyBo);
        return this.payNotifyActionExtPt.update(payOrderNotifyBo, payOrderNotifyBo.getPayOrderNotifyRequest());
    }

    @ActionNode(entity=PayRecordEo.class, name="\u652f\u4ed8\u9000\u6b3e")
    @Transactional
    public RefundCreateBo payRefund(PayOrderNotifyBo payOrderNotifyBo) {
        RefundCreateBo refundCreateBo = new RefundCreateBo();
        refundCreateBo.setPayRecordEo(payOrderNotifyBo.getPayRecordEo());
        RefundReqDto refundReqDto = new RefundReqDto();
        refundReqDto.setRefundTotalAmount(payOrderNotifyBo.getPayRecordEo().getPayAmount());
        refundReqDto.setPayNo(payOrderNotifyBo.getPayRecordEo().getPayNo());
        refundReqDto.setCancelDesc("\u91cd\u590d\u652f\u4ed8/\u8ba2\u5355\u53d6\u6d88");
        refundReqDto.setCancelType("ORDER");
        refundCreateBo.setRefundReqDto(refundReqDto);
        return refundCreateBo;
    }

    @ActionNode(entity=PayRecordEo.class, name="\u68c0\u67e5\u662f\u5426\u9700\u8981\u9000\u6b3e")
    @Transactional
    public String checkIsRefund(PayOrderNotifyBo payOrderNotifyBo) {
        if (payOrderNotifyBo.getPayRecordEo().getOrderNo() == null) {
            return "TRUE";
        }
        OrderEo orderEo = this.orderService.queryByOrderNo(payOrderNotifyBo.getPayRecordEo().getOrderNo());
        if (orderEo != null) {
            if (orderEo.getPayTime() != null || orderEo.getCancelTime() != null) {
                return "TRUE";
            }
            return "FALSE";
        }
        return "TRUE";
    }

    private PayOrderNotifyBo packBo(PayOrderNotifyBo payOrderNotifyBo, PayOrderNotifyRequest notifyReq) {
        PayRecordEo payRecordEo = payOrderNotifyBo.getPayRecordEo();
        if (notifyReq.getTradeId() != null) {
            payRecordEo.setExtlPaySerial(notifyReq.getTradeId());
        }
        payRecordEo.setPayFinishTime(DateUtil.parseDate((String)notifyReq.getFinishTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        payOrderNotifyBo.setPayRecordEo(payRecordEo);
        payOrderNotifyBo.setFinishTime(payRecordEo.getPayFinishTime());
        boolean paySucc = PAY_NOTIFY_STATUS_SUCC.equals(notifyReq.getOrderStatus());
        if (notifyReq.getOrderStatus() == null) {
            paySucc = true;
        }
        if (paySucc) {
            payOrderNotifyBo.setPayStatus(PayStatusEnum.SUCCESS.getName());
        } else {
            payOrderNotifyBo.setPayStatus(PayStatusEnum.FAIL.getName());
        }
        return this.payNotifyActionExtPt.packBo(payOrderNotifyBo, notifyReq);
    }

    private PayOrderNotifyRequest validate(PayOrderNotifyRequest notifyReq) {
        return this.payNotifyActionExtPt.validate(notifyReq);
    }
}

