/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.flow.newaction;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.enhance.flow.ActionNode;
import com.dtyunxi.cube.enhance.flow.ActionNodeComponent;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.biz.member.api.basis.dto.response.MemberInfoDetailRespDto;
import com.dtyunxi.yundt.cube.biz.member.api.basis.query.IMemberInfoExtQueryApi;
import com.dtyunxi.yundt.cube.biz.member.api.common.dto.point.response.PointsStatExtRespDto;
import com.dtyunxi.yundt.cube.biz.member.api.point.IPointCashOutApi;
import com.dtyunxi.yundt.cube.biz.member.api.point.dto.request.PointCashOutOperateItemReqDto;
import com.dtyunxi.yundt.cube.biz.member.api.point.dto.request.PointCashOutOperateReqDto;
import com.dtyunxi.yundt.cube.biz.member.api.point.query.IPointsAccountQueryApi;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.FlowActionNode;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderEo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.OrderCreateBo;
import com.dtyunxi.yundt.module.context.api.IContext;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="pointsDeductAction")
@ActionNodeComponent
public class PointsDeductAction {
    private Logger logger = LoggerFactory.getLogger(PointsDeductAction.class);
    @Resource
    private IPointsAccountQueryApi pointsAccountQueryApi;
    @Resource
    private IPointCashOutApi pointCashOutApi;
    @Resource
    private IMemberInfoExtQueryApi memberInfoExtQueryApi;
    @Resource
    private IContext context;

    @ActionNode(entity=OrderEo.class, name="\u6263\u51cf\u79ef\u5206")
    @FlowActionNode(entity=OrderEo.class, name="\u6263\u51cf\u79ef\u5206")
    public String pointDeduct(OrderCreateBo orderCreateBo) {
        if (orderCreateBo.getOrderEo().getIsSplit() == 1) {
            return "TRUE";
        }
        if (orderCreateBo.getOrderEo().getTotalCashOutPoint() == null) {
            return "TRUE";
        }
        if (orderCreateBo.getOrderEo().getTotalCashOutPoint() <= 0) {
            return "TRUE";
        }
        if (!this.checkPoint(orderCreateBo)) {
            return "FALSE";
        }
        if (CollectionUtils.isEmpty((Collection)orderCreateBo.getTradeItemEoList())) {
            return "TRUE";
        }
        PointCashOutOperateReqDto reqDto = new PointCashOutOperateReqDto();
        ArrayList itemDetailList = new ArrayList();
        orderCreateBo.getTradeItemEoList().forEach(tradeItemEo -> {
            if (tradeItemEo.getCashOutPoint() != null && tradeItemEo.getCashOutPoint() > 0) {
                PointCashOutOperateItemReqDto itemReqDto = new PointCashOutOperateItemReqDto();
                itemReqDto.setCashOutPoint(tradeItemEo.getCashOutPoint());
                itemReqDto.setQuantity(tradeItemEo.getItemNum());
                itemReqDto.setSku(tradeItemEo.getSkuSerial());
                itemDetailList.add(itemReqDto);
            }
        });
        reqDto.setItemDetailList(itemDetailList);
        reqDto.setMemberId(orderCreateBo.getMemberId());
        reqDto.setOrderNo(orderCreateBo.getOrderEo().getOrderNo());
        reqDto.setTradeNo(orderCreateBo.getOrderEo().getOrderNo());
        RestResponse restResponse = this.pointCashOutApi.operate(reqDto);
        RestResponseHelper.checkOrThrow((RestResponse)restResponse);
        return "TRUE";
    }

    private boolean checkPoint(OrderCreateBo orderBo) {
        PointsStatExtRespDto pointsStatExtRespDto = this.queryMemberPointInfo(this.context.userId(), orderBo);
        Integer points = pointsStatExtRespDto.getAvailablePoints();
        return true;
    }

    public PointsStatExtRespDto queryMemberPointInfo(Long userId, OrderCreateBo orderBo) {
        PointsStatExtRespDto pointsStatExtRespDto = null;
        try {
            RestResponse restResponse = this.memberInfoExtQueryApi.queryMemberInfoDetailByUserId(userId);
            MemberInfoDetailRespDto memberInfoDetailRespDto = (MemberInfoDetailRespDto)RestResponseHelper.extractData((RestResponse)restResponse);
            if (memberInfoDetailRespDto != null) {
                Long memberId = memberInfoDetailRespDto.getId();
                if (memberId != null) {
                    orderBo.setMemberId(memberId);
                    RestResponse pointsResponse = this.pointsAccountQueryApi.queryPointsAccount(memberId);
                    pointsStatExtRespDto = (PointsStatExtRespDto)RestResponseHelper.extractData((RestResponse)pointsResponse);
                }
                this.logger.info("\u67e5\u8be2\u56de\u4f1a\u5458\u79ef\u5206\u4fe1\u606f: userId={}, memberId={} pointsStatExtRespDto={}", new Object[]{userId, memberId, JSON.toJSONString((Object)pointsStatExtRespDto)});
            }
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u4f1a\u5458\u79ef\u5206\u4fe1\u606f\u5931\u8d25: userId={} " + e.getMessage(), (Object)userId, (Object)e);
        }
        return pointsStatExtRespDto;
    }
}

