/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.flow.newaction;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.enhance.CubeResource;
import com.dtyunxi.cube.enhance.flow.ActionNode;
import com.dtyunxi.cube.enhance.flow.ActionNodeComponent;
import com.dtyunxi.cube.enhance.flow.ActionResult;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.connector.core.api.dto.RefundsAgreeReqDto;
import com.dtyunxi.yundt.connector.core.api.dto.RefundsRefuseReqDto;
import com.dtyunxi.yundt.connector.core.api.dto.ReturngoodsAgreeReqDto;
import com.dtyunxi.yundt.connector.core.api.dto.ReturngoodsRefuseReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.DeliveryRouteApi;
import com.dtyunxi.yundt.cube.center.inventory.api.query.IWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.payment.api.trade.ICreateTradeService;
import com.dtyunxi.yundt.cube.center.payment.dto.exception.VerifyException;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.RefundRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.RefundResponse;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.AuditRecordStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.PayResultEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.RefundStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.RefundTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ReturnStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ReturnTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.SaleChannelEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.AuditRecordReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.GenerateOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.PayRefundReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.RefundReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ReturnReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.exception.TradeExceptionCode;
import com.dtyunxi.yundt.cube.center.trade.api.utils.SqlFilterBuilder;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.utils.TradeUtil;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.ConfirmReceiveBo;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.ConfirmRefundBo;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.ReplenishBo;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.ReturnCompleteBo;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.UserConfirmReturnBo;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IAfterSalesService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderDeliveryService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IPayService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.ITradeItemService;
import com.dtyunxi.yundt.cube.center.trade.biz.util.ImageUtil;
import com.dtyunxi.yundt.cube.center.trade.dao.das.AuditRecordDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderDeliveryDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.RefDeliveryOrderDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.RefTradeItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.RefundDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.ReturnDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.AuditRecordEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.PayRecordEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.RefDeliveryOrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.RefundEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.ReturnEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdRefundEo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.IReturnRefundActionExtPt;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.CancelReturnBo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.ReturnAuditBBCBo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.ReturnAuditBo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.ReturnBo;
import com.dtyunxi.yundt.cube.connector.api.IAfterSalesApi;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="returnFlowAction")
@ActionNodeComponent
public class ReturnFlowAction {
    private static Logger logger = LoggerFactory.getLogger(ReturnFlowAction.class);
    @Resource
    private Environment environment;
    @Autowired
    ITradeItemService tradeItemService;
    @Autowired
    private OrderDeliveryDas orderDeliveryDas;
    @Autowired
    private RefDeliveryOrderDas refDeliveryOrderDas;
    @Resource
    private IWarehouseQueryApi warehouseQueryApi;
    @Resource
    private DeliveryRouteApi deliveryRouteApi;
    @Resource
    private IPayService payService;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private ICreateTradeService createTradeService;
    @Autowired
    private IAfterSalesService afterSalesService;
    @Resource
    private ReturnDas returnDas;
    @Resource
    private RefundDas refundDas;
    @Autowired
    AuditRecordDas auditRecordDas;
    @Autowired
    RefTradeItemDas refTradeItemDas;
    @CubeResource
    private IReturnRefundActionExtPt returnRefundActionExtPt;
    @Resource
    private IOrderDeliveryService orderDeliveryService;
    @Resource
    private IOrderService orderService;
    @Resource
    private IAfterSalesApi afterSalesApi;
    @Resource
    private IShopQueryApi shopQueryApi;

    @ActionNode(entity=ReturnEo.class, name="\u8fdb\u884c\u9000\u6b3e")
    @Transactional(rollbackFor={Exception.class})
    public String doRefund(ReturnAuditBo returnAuditBo) {
        ReturnEo returnEo = this.returnDas.selectByTradeNo(returnAuditBo.getReturnNo());
        RefundEo queryRefundEo = RefundEo.newInstance();
        queryRefundEo.setRefundNo(returnAuditBo.getRefundNo());
        RefundEo refundEo = (RefundEo)this.refundDas.selectOne((BaseEo)queryRefundEo);
        if (SaleChannelEnum.SALECHANNEL_ZYSC.getCode().equals(returnEo.getSaleChannel())) {
            List<PayRecordEo> payRecordEos = this.payService.getPayRecordSuccessByOrderNo(returnEo.getOrderTradeNo());
            if (CollectionUtils.isEmpty(payRecordEos)) {
                throw new BizException("\u627e\u4e0d\u5230\u6210\u529f\u652f\u4ed8\u8bb0\u5f55");
            }
            PayRecordEo payRecordEo = payRecordEos.get(0);
            if (StringUtils.isNotEmpty((CharSequence)payRecordEo.getParentPayNo()) && !payRecordEo.getParentPayNo().equals("0")) {
                payRecordEo = this.payService.getPayRecordByTradeNo(payRecordEo.getParentPayNo());
            }
            if ("OFFLINE_AMOUNT_PAY".equals(payRecordEo.getPayMethod()) || "OFFLINE_PUBLIC_REMIT_PAY".equals(payRecordEo.getPayMethod())) {
                refundEo.setStatus("refundStatus", PayResultEnum.SUCCESS.getName());
                refundEo.setRefundTime(new Date());
                this.refundDas.updateSelective((BaseEo)refundEo);
                return "success";
            }
            PayRefundReqDto payRefundReqDto = new PayRefundReqDto();
            payRefundReqDto.setTradeNo(refundEo.getTradeNo());
            payRefundReqDto.setPayNo(refundEo.getPayNo());
            payRefundReqDto.setInstanceId(payRecordEo.getInstanceId());
            payRefundReqDto.setTenantId(payRecordEo.getTenantId());
            payRefundReqDto.setExtlPaySerial(payRecordEo.getExtlPaySerial());
            payRefundReqDto.setAmount(refundEo.getRefundTotalAmount());
            payRefundReqDto.setUserId(payRecordEo.getUserId());
            String extension = payRecordEo.getExtension();
            if (StringUtils.isNotEmpty((CharSequence)extension)) {
                JSONObject json = JSON.parseObject((String)extension);
                payRefundReqDto.setStoreId(json.getString("storeId"));
                payRefundReqDto.setAppId(json.getString("appId"));
                payRefundReqDto.setAppName(json.getString("appName"));
            }
            RefundRequest refundRequest = this.payService.buildRefundRequest(payRefundReqDto);
            try {
                RefundResponse response = this.createTradeService.createRefundOrder(refundRequest);
                PayResultEnum payResult = PayResultEnum.getByName((String)response.getResult());
                refundEo.setStatus("refundStatus", payResult.getName());
                refundEo.setRefundTime(new Date());
                this.refundDas.updateSelective((BaseEo)refundEo);
                if (RefundStatusEnum.FAIL.getName().equals(response.getResult()) || PayResultEnum.ERROR.getName().equals(response.getResult())) {
                    return "fail";
                }
                return "success";
            }
            catch (VerifyException ex) {
                logger.error("\u53d1\u8d77\u9000\u6b3e\u5f02\u5e38", (Throwable)ex);
                throw new BizException(ex.getMessage());
            }
        }
        return "success";
    }

    @ActionNode(entity=ReturnEo.class, name="\u7b49\u5f85\u5ba1\u6838\u7ed3\u679c")
    @Transactional(rollbackFor={Exception.class})
    public ReturnAuditBBCBo returnAuditResult(ReturnAuditBBCBo returnAuditBBCBo) {
        AuditRecordReqDto auditResult = returnAuditBBCBo.getReturnAuditReqDto();
        ReturnEo returnEo = returnAuditBBCBo.getReturnEo();
        AuditRecordReqDto returnAuditReqDto = returnAuditBBCBo.getReturnAuditReqDto();
        if (!SaleChannelEnum.SALECHANNEL_ZYSC.getCode().equals(returnEo.getSaleChannel())) {
            if (RefundTypeEnum.REFUND_ONLY.getName().equals(returnEo.getReturnType())) {
                this.deliveryorderIntercept(returnAuditBBCBo);
            }
            if (RefundTypeEnum.RETURN_BASE.getName().equals(returnEo.getReturnType())) {
                this.handleThirdReturnGoods(returnAuditBBCBo);
            }
        }
        AuditRecordEo selectAuditRecordEo = new AuditRecordEo();
        selectAuditRecordEo.setBizTradeNo(auditResult.getBizTradeNo());
        selectAuditRecordEo.setAuditStatus(AuditRecordStatusEnum.AUDITING.getName());
        List auditRecordEoList = this.auditRecordDas.select((BaseEo)selectAuditRecordEo);
        String auditRecordNo = Optional.ofNullable(auditRecordEoList).map(list -> ((AuditRecordEo)list.stream().findFirst().get()).getAuditRecordNo()).orElseThrow(() -> new BizException(TradeExceptionCode.AUDIT_RECORD_NOT_EXIST.getCode(), TradeExceptionCode.AUDIT_RECORD_NOT_EXIST.getMsg()));
        if (auditResult.getSellerRefundAmount() != null) {
            returnEo.setRefundAmount(auditResult.getSellerRefundAmount());
            returnEo.setRefundAmount(auditResult.getSellerRefundAmount());
        }
        AuditRecordEo auditRecordEo = new AuditRecordEo();
        auditRecordEo.setHandleType(auditResult.getHandleType());
        auditRecordEo.setHandleDesc(auditResult.getHandleDesc());
        auditRecordEo.setSellerRemark(auditResult.getSellerRemark());
        AuditRecordStatusEnum auditRecordStatusEnum = AuditRecordStatusEnum.getByName((String)auditResult.getAuditStatus());
        if (auditRecordStatusEnum != null) {
            auditRecordEo.setAuditStatus(auditRecordStatusEnum.getName());
            String bizResult = auditRecordStatusEnum.getName().toLowerCase();
            returnAuditBBCBo.setAuditResult(bizResult);
        }
        this.afterSalesService.modifyAuditRecord(auditRecordNo, auditRecordEo);
        if (AuditRecordStatusEnum.PASS.getName().equals(returnAuditReqDto.getAuditStatus())) {
            List deliveryOrderEos = this.refDeliveryOrderDas.select(SqlFilterBuilder.create(RefDeliveryOrderEo.class).eq("order_no", (Object)returnEo.getOrderTradeNo()).eo());
            logger.info("\u552e\u540e\u5355\u5ba1\u6838\u901a\u8fc7\uff0c\u8ba2\u5355\u53f7\uff1a{}\uff0c\u67e5\u8be2\u51fa\u7684\u5173\u8054\u53d1\u8d27\u5355\u53f7\u4e3a\uff1a{}", (Object)returnEo.getOrderTradeNo(), (Object)JSON.toJSONString((Object)deliveryOrderEos));
            if (CollectionUtils.isNotEmpty((Collection)deliveryOrderEos)) {
                this.orderDeliveryService.cancelDelivery(((RefDeliveryOrderEo)deliveryOrderEos.get(0)).getDeliveryNo());
            }
        }
        return returnAuditBBCBo;
    }

    private void deliveryorderIntercept(ReturnAuditBBCBo returnAuditBBCBo) {
        ReturnEo returnEo = returnAuditBBCBo.getReturnEo();
        AuditRecordReqDto returnAuditReqDto = returnAuditBBCBo.getReturnAuditReqDto();
    }

    private void handleThirdReturnGoods(ReturnAuditBBCBo returnAuditBBCBo) {
        ReturnEo returnEo = returnAuditBBCBo.getReturnEo();
        RefundEo refundSelect = RefundEo.newInstance();
        refundSelect.setReturnNo(returnEo.getReturnNo());
        RefundEo refundEo = (RefundEo)this.refundDas.selectOne((BaseEo)refundSelect);
        RefundEo refundUpdate = RefundEo.newInstance();
        AuditRecordReqDto returnAuditReqDto = returnAuditBBCBo.getReturnAuditReqDto();
        if (null != refundEo) {
            String refundStatus = AuditRecordStatusEnum.PASS.getName().equals(returnAuditReqDto.getAuditStatus()) ? RefundStatusEnum.AUDITING.getName() : RefundStatusEnum.FAIL.getName();
            refundUpdate.setId(refundEo.getId());
            refundUpdate.setRefundStatus(refundStatus);
            this.refundDas.updateSelective((BaseEo)refundUpdate);
        }
    }

    private void thirdAgreeReturnGoods(ReturnEo returnEo) {
        logger.info("\u552e\u540e\u5355\u5ba1\u6838\u901a\u8fc7\uff0c\u8c03\u7528\u8fde\u63a5\u5668\u540c\u610f\u9000\u8d27\u63a5\u53e3");
        ReturngoodsAgreeReqDto returngoodsAgreeReqDto = new ReturngoodsAgreeReqDto();
        returngoodsAgreeReqDto.setRefundId(returnEo.getExtlReturnSerial());
        returngoodsAgreeReqDto.setChannelCode(returnEo.getSaleChannel());
        returngoodsAgreeReqDto.setShopCode(this.getShopCode(returnEo));
        returngoodsAgreeReqDto.setRemark("\u540c\u610f\u9000\u8d27");
        try {
            logger.info("\u64cd\u4f5c\u7b2c\u4e09\u65b9\u53d1\u8d27\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)returngoodsAgreeReqDto));
            RestResponse response = this.afterSalesApi.returnGoodsAgree(returngoodsAgreeReqDto);
            logger.info("\u64cd\u4f5c\u7b2c\u4e09\u65b9\u53d1\u8d27\u6210\u529f\uff0c\u8fd4\u56de\u54cd\u5e94\u4fe1\u606f\uff0cresponse:{}", (Object)JSON.toJSONString((Object)response));
            if (!"0".equals(response.getResultCode())) {
                throw new BizException("\u8c03\u7528\u7b2c\u4e09\u65b9\u540c\u610f\u9000\u8d27\u5931\u8d25\uff0c" + response.getResultMsg());
            }
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u7b2c\u4e09\u65b9\u540c\u610f\u9000\u8d27\u5931\u8d25\uff0c\u552e\u540e\u5355\u53f7\uff1a{}\uff0ce:{}", new Object[]{returnEo.getReturnNo(), e.getMessage(), e});
            throw new BizException("\u8c03\u7528\u7b2c\u4e09\u65b9\u540c\u610f\u9000\u8d27\u5931\u8d25\uff01" + e.getMessage());
        }
    }

    private void thirdRejectReturnGoods(ReturnEo returnEo) {
        logger.info("\u552e\u540e\u5355\u5ba1\u6838\u62d2\u7edd\uff0c\u8c03\u7528\u8fde\u63a5\u5668\u62d2\u7edd\u9000\u8d27\u63a5\u53e3");
        try {
            ReturngoodsRefuseReqDto returngoodsRefuseReqDto = new ReturngoodsRefuseReqDto();
            returngoodsRefuseReqDto.setRefundId(returnEo.getExtlReturnSerial());
            if (StringUtils.isNotEmpty((CharSequence)returnEo.getRefuseProofPics())) {
                String imagePath = returnEo.getRefuseProofPics().split(",")[0];
                byte[] refuseProof = ImageUtil.image2byte(imagePath);
                returngoodsRefuseReqDto.setRefuseProof(refuseProof);
            }
            returngoodsRefuseReqDto.setChannelCode(returnEo.getSaleChannel());
            returngoodsRefuseReqDto.setShopCode(this.getShopCode(returnEo));
            RestResponse response = this.afterSalesApi.returnGoodsRefuse(returngoodsRefuseReqDto);
            logger.info("\u64cd\u4f5c\u8c03\u7528\u8fde\u63a5\u5668\u62d2\u7edd\u9000\u8d27\u6210\u529f\uff0c\u8fd4\u56de\u54cd\u5e94\u4fe1\u606f\uff0cresponse:{}", (Object)JSON.toJSONString((Object)response));
            if (!"0".equals(response.getResultCode())) {
                throw new BizException("\u8c03\u7528\u64cd\u4f5c\u8c03\u7528\u8fde\u63a5\u5668\u62d2\u7edd\u9000\u8d27\u5931\u8d25\uff0c" + response.getResultMsg());
            }
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u64cd\u4f5c\u8c03\u7528\u8fde\u63a5\u5668\u62d2\u7edd\u9000\u8d27\u5931\u8d25\uff0c\u552e\u540e\u5355\u53f7\uff1a{}\uff0ce:{}", new Object[]{returnEo.getReturnNo(), e.getMessage(), e});
            throw new BizException("\u8c03\u7528\u8c03\u7528\u64cd\u4f5c\u8c03\u7528\u8fde\u63a5\u5668\u62d2\u7edd\u9000\u8d27\u5931\u8d25\uff01" + e.getMessage());
        }
    }

    @ActionNode(entity=ReturnEo.class, name="\u68c0\u67e5\u662f\u5426\u8981\u9000\u8d27")
    @Transactional(rollbackFor={Exception.class})
    public String checkIsReturn(ReturnBo returnBo) {
        logger.info("\u9000\u6b3e\u5355\u53f7{}\u76ee\u524d\u9000\u6b3e\u7c7b\u578b{}", (Object)returnBo.getReturnEo().getReturnNo(), (Object)returnBo.getReturnEo().getReturnType());
        if (returnBo.getReturnEo().getReturnType().equals(RefundTypeEnum.RETURN_BASE.getName())) {
            return "TRUE";
        }
        return "FALSE";
    }

    @ActionNode(entity=ReturnEo.class, name="\u5df2\u63a5\u53d7\u9000\u56de\u8d27\u54c1")
    @Transactional(rollbackFor={Exception.class})
    public ConfirmReceiveBo confirmReceive(ConfirmReceiveBo confirmReceiveBo) {
        logger.info("\u552e\u540e\u9000\u8d27\u786e\u8ba4\u6536\u8d27\uff0cconfirmReceiveBo\uff1a{}", (Object)JSON.toJSONString((Object)((Object)confirmReceiveBo)));
        ReturnReqDto returnReqDto = confirmReceiveBo.getReturnReqDto();
        ReturnEo eo = confirmReceiveBo.getReturnEo();
        if (returnReqDto.getSellerRefundAmount() != null) {
            eo.setRefundAmount(returnReqDto.getSellerRefundAmount());
            eo.setCancelDesc(returnReqDto.getCancelDesc());
            eo.setCancelTime(returnReqDto.getCancelTime());
            eo.setCancelType(returnReqDto.getCancelType());
        }
        if (returnReqDto.getCancelType() == null || "0".equals(returnReqDto.getCancelType())) {
            confirmReceiveBo.setConfirmReceiveResult("default");
        } else {
            confirmReceiveBo.setConfirmReceiveResult("cancel");
        }
        if (null != confirmReceiveBo.getReturnReqDto().getReceivedGift()) {
            confirmReceiveBo.getReturnEo().setReceivedGift(confirmReceiveBo.getReturnReqDto().getReceivedGift());
        }
        if (SaleChannelEnum.SALECHANNEL_ZYSC.getCode().equals(eo.getSaleChannel())) {
            logger.info("\u81ea\u7531\u5546\u57ce\uff0c\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u9000\u6b3eWAIT_REFUND");
            confirmReceiveBo.setToReturnStatus(ReturnStatusEnum.WAIT_REFUND.getName());
        } else {
            logger.info("\u5168\u6e20\u9053\uff0c\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u9a8c\u6536TO_ACCEPTANCE");
            confirmReceiveBo.setToReturnStatus(ReturnStatusEnum.TO_ACCEPTANCE.getName());
        }
        return confirmReceiveBo;
    }

    @ActionNode(entity=ReturnEo.class, name="\u552e\u540e\u62d2\u7edd\u5b8c\u6210")
    @Transactional(rollbackFor={Exception.class})
    public CancelReturnBo returnFinishAction(CancelReturnBo cancelReturnBo) {
        return cancelReturnBo;
    }

    public RestResponse<Void> getConfirmRefundVerifyCode(ConfirmRefundBo refundBo) {
        ReturnReqDto returnReqDto = refundBo.getReturnReqDto();
        ReturnEo returnEoSelect = new ReturnEo();
        returnEoSelect.setReturnNo(returnReqDto.getTradeNo());
        ReturnEo returnEo = (ReturnEo)this.returnDas.selectOne((BaseEo)returnEoSelect);
        Long amount = returnEo.getRefundAmount().multiply(new BigDecimal("100")).longValue();
        RefundsAgreeReqDto refundsAgreeReqDto = new RefundsAgreeReqDto();
        refundsAgreeReqDto.setRefundId(returnEo.getExtlReturnSerial());
        refundsAgreeReqDto.setAmount(amount.toString());
        refundsAgreeReqDto.setShopCode(this.getShopCode(returnEo));
        refundsAgreeReqDto.setChannelCode(returnEo.getSaleChannel());
        try {
            logger.info("\u83b7\u53d6\u7b2c\u4e09\u65b9\u786e\u8ba4\u9000\u6b3e\u9a8c\u8bc1\u7801\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)refundsAgreeReqDto));
            RestResponse restResponse = this.afterSalesApi.refundsAgree(refundsAgreeReqDto);
            logger.info("\u83b7\u53d6\u7b2c\u4e09\u65b9\u786e\u8ba4\u9000\u6b3e\u9a8c\u8bc1\u7801\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)restResponse));
            if (!"0".equals(restResponse.getResultCode())) {
                logger.error("\u83b7\u53d6\u7b2c\u4e09\u65b9\u786e\u8ba4\u9000\u6b3e\u9a8c\u8bc1\u7801, e:{}", (Object)restResponse.getResultMsg());
                return new RestResponse("10000", "\u83b7\u53d6\u7b2c\u4e09\u65b9\u786e\u8ba4\u9000\u6b3e\u9a8c\u8bc1\u7801\u5931\u8d25: \u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u7b2c\u4e09\u65b9\u786e\u8ba4\u9000\u6b3e\u9a8c\u8bc1\u7801, e:{}", (Object)e.getMessage(), (Object)e);
            return new RestResponse("10000", "\u83b7\u53d6\u7b2c\u4e09\u65b9\u786e\u8ba4\u9000\u6b3e\u9a8c\u8bc1\u7801\u5931\u8d25: \u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        return RestResponse.VOID;
    }

    @Transactional(rollbackFor={Exception.class})
    @ActionNode(entity=ReturnEo.class, name="\u786e\u8ba4\u9000\u6b3e", results={@ActionResult(code="default", desc="\u9ed8\u8ba4"), @ActionResult(code="cancel", desc="\u53d6\u6d88")})
    public ConfirmRefundBo confirmRefundAction(ConfirmRefundBo refundBo) {
        ReturnEo returnEo;
        logger.info("\u6536\u8d27\u540e\u5355\u786e\u8ba4\u9000\u6b3e\uff0crefundBo\uff1a{}", (Object)JSON.toJSONString((Object)((Object)refundBo)));
        ReturnReqDto returnReqDto = refundBo.getReturnReqDto();
        if (returnReqDto.getSellerRefundAmount() != null) {
            ReturnEo eo = refundBo.getReturnEo();
            eo.setRefundAmount(returnReqDto.getSellerRefundAmount());
            HashMap map = Maps.newHashMap();
            map.put("refundAmountDetail", returnReqDto.getSellerRefundAmount());
            if (null != returnReqDto.getReturnFreightAmount()) {
                map.put("returnFreightAmount", returnReqDto.getReturnFreightAmount().setScale(2));
            }
            eo.setRefundAmountDetail(JSON.toJSONString((Object)map));
        }
        if (returnReqDto.getCancelType() == null || "0".equals(returnReqDto.getCancelType())) {
            refundBo.setConfirmResult("default");
            ReturnEo returnEoSelect = new ReturnEo();
            returnEoSelect.setReturnNo(returnReqDto.getTradeNo());
            returnEo = (ReturnEo)this.returnDas.selectOne((BaseEo)returnEoSelect);
            if (!SaleChannelEnum.SALECHANNEL_ZYSC.getCode().equals(returnEo.getSaleChannel())) {
                logger.info("\u5168\u6e20\u9053\u552e\u540e\u5355\uff0c\u5904\u7406\u7b2c\u4e09\u65b9\u9000\u6b3e\u2026\u2026");
                Long amount = returnEo.getRefundAmount().multiply(new BigDecimal("100")).longValue();
                RefundsAgreeReqDto refundsAgreeReqDto = new RefundsAgreeReqDto();
                refundsAgreeReqDto.setRefundId(returnEo.getExtlReturnSerial());
                refundsAgreeReqDto.setAmount(amount.toString());
                refundsAgreeReqDto.setShopCode(this.getShopCode(returnEo));
                refundsAgreeReqDto.setCode(returnReqDto.getVerifyCode());
                refundsAgreeReqDto.setChannelCode(returnEo.getSaleChannel());
                try {
                    logger.info("\u8bf7\u6c42\u8fde\u63a5\u5668\u8fdb\u884c\u7b2c\u4e09\u65b9\u9000\u6b3e\u64cd\u4f5c\uff0cchannelCode\uff1a{}\uff0c refundsAgreeReqDto\uff1a{}", (Object)returnEo.getSaleChannel(), (Object)JSON.toJSONString((Object)refundsAgreeReqDto));
                    RestResponse restResponse = this.afterSalesApi.refundsAgree(refundsAgreeReqDto);
                    if (!"0".equals(restResponse.getResultCode())) {
                        throw new BizException("\u540c\u610f\u9000\u6b3e\u64cd\u4f5c\u5931\u8d25:" + restResponse.getResultMsg());
                    }
                    logger.info("\u5168\u6e20\u9053\u552e\u540e\u5355\uff0c\u5904\u7406\u7b2c\u4e09\u65b9\u6210\u529f\uff0c\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)restResponse));
                    RefundEo refundSelect = RefundEo.newInstance();
                    refundSelect.setTradeNo(returnEo.getTradeNo());
                    RefundEo refundEo = (RefundEo)this.refundDas.selectOne((BaseEo)refundSelect);
                    if (null != refundEo) {
                        RefundEo refundUpdate = RefundEo.newInstance();
                        refundUpdate.setId(refundEo.getId());
                        refundUpdate.setRefundStatus(RefundStatusEnum.REFUNING.getName());
                        this.refundDas.updateSelective((BaseEo)refundUpdate);
                        logger.info("\u66f4\u65b0\u9000\u6b3e\u5355\u4e3a\uff1a{}\u72b6\u6001", (Object)RefundStatusEnum.REFUNING.getName());
                    }
                }
                catch (Exception e) {
                    logger.error("\u7b2c\u4e09\u65b9\u9000\u6b3e\u5931\u8d25\uff0c\u552e\u540e\u5355\u53f7\uff1a{}\uff0ce:{}", new Object[]{returnReqDto.getTradeNo(), e.getMessage(), e});
                    throw new BizException("\u9000\u6b3e\u64cd\u4f5c\u5931\u8d25:" + e.getMessage());
                }
                refundBo.setConfirmResult("STOP_EXTC");
            }
        } else {
            refundBo.setConfirmResult("cancel");
        }
        RefundReqDto refundReqDto = new RefundReqDto();
        refundBo.setRefundReqDto(refundReqDto);
        if (refundBo.getReturnEo() != null) {
            returnEo = refundBo.getReturnEo();
            BeanUtils.copyProperties((Object)returnEo, (Object)refundReqDto);
            OrderEo orderEo = this.orderService.getByOrderNo(returnEo.getOrderTradeNo());
            this.orderService.cancelAndUpdateOrder(orderEo, "buyer_cancel", null);
        }
        refundReqDto.setRefundTotalAmount(refundBo.getReturnEo().getRefundAmount());
        return refundBo;
    }

    public RestResponse rejectRefund(ReturnReqDto returnReqDto) {
        logger.info("\u62d2\u7edd\u9000\u6b3e\u64cd\u4f5c\uff0creturnReqDto\uff1a{}", (Object)JSON.toJSONString((Object)returnReqDto));
        ReturnEo returnEoSelect = new ReturnEo();
        returnEoSelect.setReturnNo(returnReqDto.getReturnNo());
        ReturnEo returnEo = (ReturnEo)this.returnDas.selectOne((BaseEo)returnEoSelect);
        if (!SaleChannelEnum.SALECHANNEL_ZYSC.getCode().equals(returnEo.getSaleChannel())) {
            RefundsRefuseReqDto refundsRefuseReqDto = new RefundsRefuseReqDto();
            refundsRefuseReqDto.setRefundId(returnEo.getExtlReturnSerial());
            refundsRefuseReqDto.setRefuseMessage(returnReqDto.getRefuseMessage());
            refundsRefuseReqDto.setChannelCode(returnEo.getSaleChannel());
            refundsRefuseReqDto.setShopCode(this.getShopCode(returnEo));
            try {
                logger.info("\u8bf7\u6c42\u8fde\u63a5\u5668\u8fdb\u884c\u7b2c\u4e09\u65b9\u62d2\u7edd\u9000\u6b3e\u64cd\u4f5c\uff0crefundsRefuseReqDto\uff1a{}", (Object)JSON.toJSONString((Object)refundsRefuseReqDto));
                RestResponse restResponse = this.afterSalesApi.refundsRefuse(refundsRefuseReqDto);
                if ("0".equals(restResponse.getResultCode())) {
                    ReturnEo returnUpdate = ReturnEo.newInstance();
                    returnUpdate.setId(returnEo.getId());
                    returnUpdate.setReturnStatus(ReturnStatusEnum.CANCELED.getName());
                    returnUpdate.setRemark("\u62d2\u7edd\u9000\u6b3e");
                    this.returnDas.updateSelective((BaseEo)returnUpdate);
                    List deliveryOrderEos = this.refDeliveryOrderDas.select(SqlFilterBuilder.create(RefDeliveryOrderEo.class).eq("order_no", (Object)returnEo.getOrderTradeNo()).eo());
                    logger.info("\u53d6\u6d88\u7684\u9000\u6b3e\u8981\u91cd\u65b0\u751f\u6210\u53d1\u8d27\u5355:{}\uff0c\u67e5\u8be2\u51fa\u7684\u5173\u8054\u53d1\u8d27\u5355\u53f7\u4e3a\uff1a{}", (Object)returnEo.getOrderTradeNo(), (Object)JSON.toJSONString((Object)deliveryOrderEos));
                    if (CollectionUtils.isNotEmpty((Collection)deliveryOrderEos)) {
                        this.refDeliveryOrderDas.deleteByExample(SqlFilterBuilder.create(RefDeliveryOrderEo.class).eq("order_no", (Object)returnEo.getOrderTradeNo()).eo());
                        GenerateOrderReqDto generateOrderReqDto = new GenerateOrderReqDto();
                        ArrayList<String> orderNos = new ArrayList<String>();
                        orderNos.add(returnEo.getOrderTradeNo());
                        generateOrderReqDto.setOrderNos(orderNos);
                        MessageResponse messageResponse = this.commonsMqService.sendSingleMessage(this.environment.resolvePlaceholders("${GENERATE_DELIVERY_TOPIC:GENERATE_DELIVERY_TOPIC}"), this.environment.resolvePlaceholders("GENERATE_DELIVERY_TAG"), (Object)generateOrderReqDto);
                        logger.info("\u53d6\u6d88\u7684\u9000\u6b3e\u91cd\u65b0\u751f\u6210\u53d1\u8d27\u5355MQ\u6d88\u606f\u5b8c\u6bd5\uff0cgenerateOrderReqDto\uff1a{}", JSON.toJSON((Object)generateOrderReqDto));
                    }
                }
                return restResponse;
            }
            catch (Exception e) {
                logger.error("\u7b2c\u4e09\u65b9\u62d2\u7edd\u9000\u6b3e\u5931\u8d25\uff0c\u552e\u540e\u5355\u53f7\uff1a{}\uff0ce:{}", new Object[]{returnReqDto.getTradeNo(), e.getMessage(), e});
                throw new BizException("\u62d2\u7edd\u9000\u6b3e\u64cd\u4f5c\u5931\u8d25:" + e.getMessage());
            }
        }
        return RestResponse.VOID;
    }

    private String getShopCode(ReturnEo returnEo) {
        String shopId = returnEo.getShopId();
        if (StringUtils.isEmpty((CharSequence)shopId)) {
            throw new BizException("\u552e\u540e\u5355\u6ca1\u6709\u5e97\u94faID\u4fe1\u606f\uff0c\u6570\u636e\u4e0d\u5b8c\u6574!");
        }
        ShopBaseDto shop = (ShopBaseDto)this.shopQueryApi.queryBaseById(Long.valueOf(Long.parseLong(shopId))).getData();
        if (null == shop) {
            throw new BizException("\u627e\u4e0d\u5230\u552e\u540e\u5355\u5bf9\u5e94\u7684\u5e97\u94fa\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\u5e97\u94fa\u4fe1\u606f\u662f\u5426\u6b63\u786e");
        }
        return shop.getCode();
    }

    @Transactional(rollbackFor={Exception.class})
    public void auditInspectGoods(ReturnReqDto returnReqDto) {
        String returnNo = returnReqDto.getReturnNo();
        ReturnEo returnEoSelect = new ReturnEo();
        returnEoSelect.setReturnNo(returnNo);
        ReturnEo returnEo = (ReturnEo)this.returnDas.selectOne((BaseEo)returnEoSelect);
        RefundEo refundSelect = RefundEo.newInstance();
        refundSelect.setReturnNo(returnEo.getReturnNo());
        RefundEo refundEo = (RefundEo)this.refundDas.selectOne((BaseEo)refundSelect);
        ReturnEo returnUpdate = ReturnEo.newInstance();
        returnUpdate.setId(returnEo.getId());
        RefundEo refundUpdate = RefundEo.newInstance();
        refundUpdate.setId(refundEo.getId());
        if (ReturnStatusEnum.AUDIT_PASS.getName().equals(returnReqDto.getAuditStatus())) {
            logger.info("\u552e\u540e\u5355\uff1a{}\u9a8c\u8d27\u901a\u8fc7\uff0c\u552e\u540e\u5355\u66f4\u65b0\u4e3a\u5f85\u9000\u6b3e\u3002", (Object)returnNo);
            returnUpdate.setReturnStatus(ReturnStatusEnum.WAIT_REFUND.getName());
            refundUpdate.setRefundStatus(RefundStatusEnum.WAIT_REFUND.getName());
        } else if (ReturnStatusEnum.AUDIT_REJECT.getName().equals(returnReqDto.getAuditStatus())) {
            logger.info("\u552e\u540e\u5355\uff1a{}\u9a8c\u8d27\u4e0d\u901a\u8fc7\uff0c\u552e\u540e\u5355\u66f4\u65b0\u4e3a\u5f85\u6536\u8d27\u3002", (Object)returnNo);
            returnUpdate.setReturnStatus(ReturnStatusEnum.TO_RECEIVE.getName());
        } else {
            throw new BizException("\u9a8c\u8d27\u5ba1\u6838\u72b6\u6001\u4e0d\u6b63\u786e");
        }
        this.returnDas.updateSelective((BaseEo)returnUpdate);
        this.refundDas.updateSelective((BaseEo)refundUpdate);
    }

    @ActionNode(entity=ReturnEo.class, name="\u53d6\u6d88\u9000\u6b3e\u5b8c\u6210")
    @Transactional(rollbackFor={Exception.class})
    public CancelReturnBo cancelReturnFinishAction(CancelReturnBo cancelReturnBo) {
        return this.returnRefundActionExtPt.cancelReturnFinishAction(cancelReturnBo);
    }

    @ActionNode(entity=ReturnEo.class, name="\u7528\u6237\u786e\u8ba4\u9000\u8d27")
    @Transactional(rollbackFor={Exception.class})
    public UserConfirmReturnBo userConfirmReturn(UserConfirmReturnBo userConfirmReturnBo) {
        ReturnReqDto returnReqDto = userConfirmReturnBo.getReturnReqDto();
        if (ReturnTypeEnum.RETURN_BASE.getName().equals(returnReqDto.getReturnType())) {
            throw new BizException("\u552e\u540e\u5355\u7c7b\u578b\u4e0d\u6b63\u786e");
        }
        if (StringUtils.isNotBlank((CharSequence)returnReqDto.getReturnExpressCompany()) || StringUtils.isNotBlank((CharSequence)returnReqDto.getReturnExpressSerial())) {
            ReturnEo eo = userConfirmReturnBo.getReturnEo();
            eo.setReturnExpressCompany(returnReqDto.getReturnExpressCompany());
            eo.setReturnExpressSerial(returnReqDto.getReturnExpressSerial());
            eo.setReturnExpressDetail(returnReqDto.getReturnExpressDetail());
        }
        if (returnReqDto.getCancelType() == null || "0".equals(returnReqDto.getCancelType())) {
            userConfirmReturnBo.setConfirmResult("receive");
        } else {
            userConfirmReturnBo.setConfirmResult("cancel");
        }
        return userConfirmReturnBo;
    }

    @ActionNode(entity=ReturnEo.class, name="\u8865\u5145\u8d44\u6599")
    public ReplenishBo replenish(ReplenishBo replenishBo) {
        AuditRecordReqDto auditRecordReqDto = replenishBo.getAuditRecordReqDto();
        AuditRecordEo auditRecordEo = new AuditRecordEo();
        this.auditRecordDas.selectByTradeNo(auditRecordReqDto.getBizTradeNo());
        CubeBeanUtils.copyProperties((Object)auditRecordEo, (Object)auditRecordReqDto, (String[])new String[0]);
        auditRecordEo.setAuditRecordNo(TradeUtil.generateTradeNo(auditRecordReqDto.getBizTradeNo()));
        replenishBo.setReplenishResult(auditRecordEo.getAuditRecordNo());
        this.afterSalesService.saveInitAuditRecord(auditRecordEo);
        return replenishBo;
    }

    @ActionNode(entity=ReturnEo.class, name="\u552e\u540e\u5b8c\u6210")
    public ReturnCompleteBo complete(ReturnCompleteBo returnBo) {
        logger.info("\u9000\u6b3e\u5355\u53f7{}\u5df2\u7ecf\u552e\u540e\u5b8c\u6210", (Object)returnBo.getReturnEo().getReturnNo());
        returnBo.setOrderNo(returnBo.getReturnEo().getOrderTradeNo());
        return returnBo;
    }

    @ActionNode(entity=ReturnEo.class, name="\u662f\u5426\u5168\u90e8\u9000\u6b3e")
    public String checkIsAllRefund(ReturnBo returnBo) {
        ReturnEo returnEo = returnBo.getReturnEo();
        RefundEo queryRefundEo = RefundEo.newInstance();
        queryRefundEo.setReturnNo(returnEo.getReturnNo());
        List refundEos = this.refundDas.select((BaseEo)queryRefundEo);
        BigDecimal reduce = refundEos.stream().filter(bean -> PayResultEnum.SUCCESS.getName().equals(bean.getRefundStatus()) || PayResultEnum.S.getName().equals(bean.getRefundStatus())).map(StdRefundEo::getRefundTotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (returnEo.getTotalAmount().compareTo(reduce) <= 0) {
            return "TRUE";
        }
        return "FALSE";
    }

    @Transactional(rollbackFor={Exception.class})
    public void confirmRefundActionOmnichannel(ConfirmRefundBo refundBo) {
        logger.info("\u6536\u8d27\u540e\u5355\u786e\u8ba4\u9000\u6b3e\uff0crefundBo\uff1a{}", (Object)JSON.toJSONString((Object)((Object)refundBo)));
        ReturnReqDto returnReqDto = refundBo.getReturnReqDto();
        ReturnEo returnEoSelect = new ReturnEo();
        returnEoSelect.setReturnNo(returnReqDto.getTradeNo());
        ReturnEo returnEo = (ReturnEo)this.returnDas.selectOne((BaseEo)returnEoSelect);
        if (returnReqDto.getSellerRefundAmount() != null) {
            returnEo.setRefundAmount(returnReqDto.getSellerRefundAmount());
            HashMap map = Maps.newHashMap();
            map.put("refundAmountDetail", returnReqDto.getSellerRefundAmount());
            if (null != returnReqDto.getReturnFreightAmount()) {
                map.put("returnFreightAmount", returnReqDto.getReturnFreightAmount().setScale(2));
            }
            returnEo.setRefundAmountDetail(JSON.toJSONString((Object)map));
        }
        if (returnReqDto.getCancelType() == null || "0".equals(returnReqDto.getCancelType())) {
            refundBo.setConfirmResult("default");
            if (!SaleChannelEnum.SALECHANNEL_ZYSC.getCode().equals(returnEo.getSaleChannel())) {
                logger.info("\u5168\u6e20\u9053\u552e\u540e\u5355\uff0c\u5904\u7406\u7b2c\u4e09\u65b9\u9000\u6b3e\u2026\u2026");
                Long amount = returnEo.getRefundAmount().multiply(new BigDecimal("100")).longValue();
                RefundsAgreeReqDto refundsAgreeReqDto = new RefundsAgreeReqDto();
                refundsAgreeReqDto.setRefundId(returnEo.getExtlReturnSerial());
                refundsAgreeReqDto.setAmount(amount.toString());
                refundsAgreeReqDto.setShopCode(this.getShopCode(returnEo));
                refundsAgreeReqDto.setCode(returnReqDto.getVerifyCode());
                refundsAgreeReqDto.setChannelCode(returnEo.getSaleChannel());
                try {
                    logger.info("\u8bf7\u6c42\u8fde\u63a5\u5668\u8fdb\u884c\u7b2c\u4e09\u65b9\u9000\u6b3e\u64cd\u4f5c\uff0cchannelCode\uff1a{}\uff0c refundsAgreeReqDto\uff1a{}", (Object)returnEo.getSaleChannel(), (Object)JSON.toJSONString((Object)refundsAgreeReqDto));
                    RestResponse restResponse = this.afterSalesApi.refundsAgree(refundsAgreeReqDto);
                    if (!"0".equals(restResponse.getResultCode())) {
                        throw new BizException("\u540c\u610f\u9000\u6b3e\u64cd\u4f5c\u5931\u8d25:" + restResponse.getResultMsg());
                    }
                    logger.info("\u5168\u6e20\u9053\u552e\u540e\u5355\uff0c\u5904\u7406\u7b2c\u4e09\u65b9\u6210\u529f\uff0c\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)restResponse));
                    RefundEo refundSelect = RefundEo.newInstance();
                    refundSelect.setTradeNo(returnEo.getTradeNo());
                    RefundEo refundEo = (RefundEo)this.refundDas.selectOne((BaseEo)refundSelect);
                    if (null != refundEo) {
                        RefundEo refundUpdate = RefundEo.newInstance();
                        refundUpdate.setId(refundEo.getId());
                        refundUpdate.setRefundStatus(RefundStatusEnum.REFUNING.getName());
                        this.refundDas.updateSelective((BaseEo)refundUpdate);
                        logger.info("\u66f4\u65b0\u9000\u6b3e\u5355\u4e3a\uff1a{}\u72b6\u6001", (Object)RefundStatusEnum.REFUNING.getName());
                    }
                    returnEo.setReturnStatus("FINISH");
                    this.returnDas.updateSelective((BaseEo)returnEo);
                }
                catch (Exception e) {
                    logger.error("\u7b2c\u4e09\u65b9\u9000\u6b3e\u5931\u8d25\uff0c\u552e\u540e\u5355\u53f7\uff1a{}\uff0ce:{}", new Object[]{returnReqDto.getTradeNo(), e.getMessage(), e});
                    throw new BizException("\u9000\u6b3e\u64cd\u4f5c\u5931\u8d25:" + e.getMessage());
                }
                refundBo.setConfirmResult("STOP_EXTC");
            }
        } else {
            refundBo.setConfirmResult("cancel");
        }
        RefundReqDto refundReqDto = new RefundReqDto();
        refundBo.setRefundReqDto(refundReqDto);
        BeanUtils.copyProperties((Object)returnEo, (Object)refundReqDto);
        OrderEo orderEo = this.orderService.getByOrderNo(returnEo.getOrderTradeNo());
        this.orderService.cancelAndUpdateOrder(orderEo, "buyer_cancel", null);
    }
}

