/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.flow.newaction.extptimpl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.enhance.extension.CubeExtImpl;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.biz.member.api.basis.query.IMemberInfoExtQueryApi;
import com.dtyunxi.yundt.cube.biz.member.api.point.IPointCashOutApi;
import com.dtyunxi.yundt.cube.center.member.api.common.dto.request.PointsTradeInfoReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.constants.DistributionRangeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OrderBizTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OrderCancelTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.CancelReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderExtInfoDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderPreviewReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderSplitReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.TradeItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.activity.OrderActivityAddReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.TradeItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.order.OrderPreviewRespDto;
import com.dtyunxi.yundt.cube.center.trade.biz.constants.BaseFlowDef;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.utils.TradeUtil;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.newaction.CreateOrderFlowAction;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.newaction.OrderFlowAction;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.producer.MarketOrderTradeStatusProducer;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.producer.OrderCloseProducer;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.vo.OrderCloseMessageVo;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderActivityService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IShareDistributionService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IShareRegisterDistributionService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.ITradeConfQueryService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.extl.IExtlOrderActivityService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.extl.IExtlOrderStockService;
import com.dtyunxi.yundt.cube.center.trade.biz.util.ContextUtil;
import com.dtyunxi.yundt.cube.center.trade.biz.util.DistributionUtil;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.SharedDistributionEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.SharedRegisterDistributionEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdSharedDistributionEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.TradeItemEo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.IOrderCreateActionExtPt;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.CancelOrderBo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.OrderCreateBo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.OrderRefactorBo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.BizActivityType;
import com.dtyunxi.yundt.module.context.api.IContext;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@CubeExtImpl(name="C\u7aef\u4e0b\u5355 \u6269\u5c55", descr="C\u7aef\u4e0b\u5355\u6269\u5c55")
public class OrderCreateActionBBCExtPtImpl
implements IOrderCreateActionExtPt {
    private static Logger logger = LoggerFactory.getLogger(OrderCreateActionBBCExtPtImpl.class);
    @Resource
    private IOrderActivityService orderActivityService;
    @Resource
    private IExtlOrderActivityService extlOrderActivityService;
    @Resource
    private IOrderService orderService;
    @Resource
    private CreateOrderFlowAction createOrderFlowAction;
    @Resource
    private OrderCloseProducer orderCloseProducer;
    @Resource
    private IExtlOrderStockService extlOrderStockService;
    @Resource
    private OrderFlowAction orderFlowAction;
    @Resource
    private MarketOrderTradeStatusProducer marketOrderTradeStatusProducer;
    @Resource
    private OrderDas orderDas;
    @Resource
    private IMemberInfoExtQueryApi memberInfoExtQueryApi;
    @Resource
    private IPointCashOutApi pointCashOutApi;
    @Autowired
    private DistributionUtil distributionUtil;
    @Resource
    private ITradeConfQueryService tradeConfQueryService;
    @Resource
    private IShareRegisterDistributionService shareRegisterDistributionService;
    @Resource
    private IShareDistributionService shareDistributionService;
    @Autowired
    private IContext context;

    public String getFlowDefName() {
        return BaseFlowDef.BASE_ORDER.getFlowName();
    }

    public Long getFlowDefId() {
        return BaseFlowDef.BASE_ORDER.getFlowId();
    }

    public Class getDtoClass() {
        return null;
    }

    public OrderReqDto validate(OrderReqDto orderReq) {
        return orderReq;
    }

    public OrderCreateBo packBo(OrderCreateBo orderCreateBo, OrderReqDto orderReq) {
        Integer distribType = this.distributionUtil.getDistribType();
        boolean includeDistribution = orderCreateBo.getTradeItemEoList().stream().anyMatch(tradeItemEo -> StringUtils.isNotBlank((CharSequence)tradeItemEo.getDistributionInfo()));
        if (includeDistribution || distribType == 2) {
            this.setTradeItemShareInfo(orderReq, orderCreateBo.getTradeItemEoList(), distribType);
        }
        this.setOrderItemExtInfo(orderCreateBo, orderReq);
        List tradeItems = orderReq.getOrderItems();
        int sumIntegral = 0;
        for (TradeItemReqDto tradeItemReqDto : tradeItems) {
            if (tradeItemReqDto.getIntegral() == null) continue;
            sumIntegral += tradeItemReqDto.getIntegral().intValue();
        }
        orderReq.setIntegral(Integer.valueOf(sumIntegral));
        orderCreateBo.getOrderEo().setIntegral(Integer.valueOf(sumIntegral));
        String orderExt = this.getOrderExt(orderReq);
        orderCreateBo.getOrderEo().setExtension(orderExt);
        orderCreateBo.getOrderEo().setBuyerRemark(orderReq.getBuyerRemark());
        return orderCreateBo;
    }

    private void setTradeItemShareInfo(OrderReqDto orderReqDto, List<TradeItemEo> tradeItemEos, Integer distribType) {
        logger.info("\u8bbe\u7f6e\u8ba2\u5355\u4e2d\u5206\u9500\u5546\u54c1\u7684\u5206\u9500\u4fe1\u606f: {}", (Object)orderReqDto.getOrderNo());
        String distributionRange = (String)this.tradeConfQueryService.queryByCode("distributionRange");
        logger.info("\u5206\u9500\u4fdd\u62a4\u914d\u7f6e\u9879-\u5206\u9500\u4fdd\u62a4\u8303\u56f4: {}", (Object)distributionRange);
        List<SharedRegisterDistributionEo> sharedRegisterDistributionEoList = this.shareRegisterDistributionService.getShareRegisterDistribution(Long.valueOf(orderReqDto.getUserId()));
        List<SharedDistributionEo> sharedDistributionEoList = this.shareDistributionService.getShareDistribution(Long.valueOf(orderReqDto.getUserId()), null, null);
        if (CollectionUtils.isNotEmpty(sharedRegisterDistributionEoList)) {
            SharedRegisterDistributionEo mallRegisterDistribution = sharedRegisterDistributionEoList.get(0);
            tradeItemEos.stream().filter(tradeItemEo -> StringUtils.isNotBlank((CharSequence)tradeItemEo.getDistributionInfo()) || Objects.equals(2, distribType)).forEach(tradeItemEo -> {
                tradeItemEo.setDistributionRange(Integer.valueOf(DistributionRangeEnum.MALL.getCode()));
                tradeItemEo.setShareUserId(mallRegisterDistribution.getShareUserId());
                tradeItemEo.setShareUserName(mallRegisterDistribution.getShareUserName());
                tradeItemEo.setShareUserMobile(mallRegisterDistribution.getShareUserMobile());
            });
        } else if (CollectionUtils.isNotEmpty(sharedDistributionEoList)) {
            if (DistributionRangeEnum.MALL.getName().equals(distributionRange)) {
                SharedDistributionEo mallDistribution = sharedDistributionEoList.get(0);
                tradeItemEos.stream().filter(tradeItemEo -> StringUtils.isNotBlank((CharSequence)tradeItemEo.getDistributionInfo()) || Objects.equals(2, distribType)).forEach(tradeItemEo -> {
                    tradeItemEo.setDistributionRange(Integer.valueOf(DistributionRangeEnum.MALL.getCode()));
                    tradeItemEo.setShareUserId(mallDistribution.getShareUserId());
                    tradeItemEo.setShareUserName(mallDistribution.getShareUserName());
                    tradeItemEo.setShareUserMobile(mallDistribution.getShareUserMobile());
                });
            }
            if (DistributionRangeEnum.SHOP.getName().equals(distributionRange)) {
                Map<Long, List<SharedDistributionEo>> shopDistributionMap = sharedDistributionEoList.stream().collect(Collectors.groupingBy(StdSharedDistributionEo::getShopId));
                tradeItemEos.stream().filter(tradeItemEo -> StringUtils.isNotBlank((CharSequence)tradeItemEo.getDistributionInfo()) || Objects.equals(2, distribType)).forEach(tradeItemEo -> {
                    List shopDistributionList = (List)shopDistributionMap.get(Long.valueOf(tradeItemEo.getShopId()));
                    if (CollectionUtils.isNotEmpty((Collection)shopDistributionList)) {
                        tradeItemEo.setDistributionRange(Integer.valueOf(DistributionRangeEnum.SHOP.getCode()));
                        SharedDistributionEo shopDistribution = (SharedDistributionEo)shopDistributionList.get(0);
                        tradeItemEo.setShareUserId(shopDistribution.getShareUserId());
                        tradeItemEo.setShareUserName(shopDistribution.getShareUserName());
                        tradeItemEo.setShareUserMobile(shopDistribution.getShareUserMobile());
                    }
                });
            }
            if (DistributionRangeEnum.ITEM.getName().equals(distributionRange)) {
                Map<String, List<SharedDistributionEo>> itemDistributionMap = sharedDistributionEoList.stream().collect(Collectors.groupingBy(eo -> eo.getShopId() + "" + eo.getItemId()));
                tradeItemEos.stream().filter(tradeItemEo -> StringUtils.isNotBlank((CharSequence)tradeItemEo.getDistributionInfo()) || Objects.equals(2, distribType)).forEach(tradeItemEo -> {
                    tradeItemEo.setDistributionRange(Integer.valueOf(DistributionRangeEnum.ITEM.getCode()));
                    List itemDistributionList = (List)itemDistributionMap.get(tradeItemEo.getShopId() + tradeItemEo.getItemSerial());
                    if (CollectionUtils.isNotEmpty((Collection)itemDistributionList)) {
                        SharedDistributionEo itemDistribution = (SharedDistributionEo)itemDistributionList.get(0);
                        tradeItemEo.setShareUserId(itemDistribution.getShareUserId());
                        tradeItemEo.setShareUserName(itemDistribution.getShareUserName());
                        tradeItemEo.setShareUserMobile(itemDistribution.getShareUserMobile());
                    }
                });
            }
        }
    }

    public OrderCreateBo subOrderStock(OrderCreateBo orderBo, OrderReqDto orderReq) {
        boolean isSubActivityStock;
        boolean isChildrenOrder = orderBo.getOrderEo() != null && StringUtils.isNotEmpty((CharSequence)orderBo.getOrderEo().getParentOrderNo());
        boolean ifSkill = this.orderService.checkIfSkill(orderReq);
        boolean bl = isSubActivityStock = "2".equals(orderReq.getBizType()) || ifSkill;
        if (!isSubActivityStock && !isChildrenOrder) {
            this.orderService.subOrderStock(orderReq);
            orderBo.setIfSubStock(Boolean.valueOf(true));
        }
        return orderBo;
    }

    public OrderCreateBo rollBackOrderStock(OrderCreateBo orderBo, OrderReqDto orderReq) {
        boolean isChildrenOrder;
        boolean bl = isChildrenOrder = orderBo.getOrderEo() != null && StringUtils.isNotEmpty((CharSequence)orderBo.getOrderEo().getParentOrderNo());
        if (orderBo.getIfSubStock().booleanValue() && !isChildrenOrder) {
            this.orderService.rollbackOrderStock(orderReq);
        }
        return orderBo;
    }

    public OrderCreateBo rollBackOrder(OrderCreateBo orderBo, OrderReqDto orderReq) {
        try {
            boolean isChildrenOrder;
            boolean bl = isChildrenOrder = orderBo.getOrderEo() != null && StringUtils.isNotEmpty((CharSequence)orderBo.getOrderEo().getParentOrderNo());
            if (!isChildrenOrder) {
                this.rollBackOrderStock(orderBo, orderReq);
            }
        }
        catch (Exception e) {
            logger.error("\u56de\u6eda\u8ba2\u5355\u51fa\u9519", (Throwable)e);
        }
        return orderBo;
    }

    private void setOrderItemExtInfo(OrderCreateBo orderCreateBo, OrderReqDto orderReq) {
        if (orderReq.getIsCycleBuy() == 1) {
            Map<String, TradeItemReqDto> activitySkuItemMap = orderReq.getOrderItems().stream().collect(Collectors.toMap(item -> item.getShopId() + item.getSkuSerial() + String.valueOf(item.getGift()), item -> item));
            Iterator iterator = orderCreateBo.getTradeItemEoList().iterator();
            while (iterator.hasNext()) {
                TradeItemEo tradeItemEo;
                TradeItemReqDto tradeItemReqDto = activitySkuItemMap.get((tradeItemEo = (TradeItemEo)iterator.next()).getShopId() + tradeItemEo.getSkuSerial() + String.valueOf(tradeItemEo.getGift()));
                tradeItemEo.setCycleBuy(Boolean.valueOf(tradeItemReqDto.getCycleType() != null));
                if (!ArrayUtils.isNotEmpty((Object[])tradeItemReqDto.getCycleValue())) continue;
                tradeItemEo.setCycleValue(StringUtils.join((Object[])tradeItemReqDto.getCycleValue(), (String)","));
            }
        }
        this.orderService.setCargoCodeBySkuId(orderCreateBo.getTradeItemEoList());
    }

    private String getOrderExt(OrderReqDto orderBo) {
        if (CollectionUtils.isNotEmpty((Collection)orderBo.getExtInfos())) {
            for (OrderExtInfoDto extInfoDto : orderBo.getExtInfos()) {
                if (!orderBo.getShopId().equals(extInfoDto.getShopId().toString())) continue;
                orderBo.setBuyerRemark(extInfoDto.getBuyerRemark());
                JSONObject extenJson = null;
                extenJson = StringUtils.isEmpty((CharSequence)orderBo.getExtension()) ? new JSONObject() : JSONObject.parseObject((String)orderBo.getExtension());
                if (StringUtils.isNotBlank((CharSequence)extInfoDto.getInvoice())) {
                    extenJson.put("invoice", (Object)Long.valueOf(extInfoDto.getInvoice()));
                }
                return extenJson.toJSONString();
            }
        }
        return null;
    }

    public OrderCreateBo calcAmount(OrderCreateBo orderBo, OrderReqDto orderReq) {
        boolean notSecondKillReq;
        if (orderReq.getActivity() != null && CollectionUtils.isNotEmpty((Collection)orderReq.getActivity().getActivityList()) && orderReq.getActivity().getActivityList().stream().filter(o -> o.getActivityId().equals(BizActivityType.POINT_DEDUCT_ACTIVITY.getId())).count() > 0L) {
            orderReq.getActivity().setUserCheckPointDeduction(true);
        }
        boolean isChildrenOrder = StringUtils.isNotEmpty((CharSequence)orderBo.getOrderEo().getParentOrderNo());
        boolean bl = notSecondKillReq = !"SKILL_ORDER".equals(orderReq.getFlowType());
        if (notSecondKillReq && !isChildrenOrder) {
            OrderPreviewReqDto order = new OrderPreviewReqDto();
            BeanUtils.copyProperties((Object)orderReq, (Object)order);
            order.setViewType(Integer.valueOf(1));
            order.setOrderItems(order.getOrderItems());
            order.setActivity(order.getActivity());
            order.setGiftItems(order.getGiftItems());
            OrderPreviewRespDto previewRespDto = this.orderService.countAndPreviewOrderAmount(order);
            orderReq.setTotalIntegral(previewRespDto.getTotalIntegral());
            orderReq.setStartingPric(previewRespDto.getStartingPric());
            orderReq.setTotalAmount(previewRespDto.getTotalAmount());
            orderReq.setDiscountAmount(previewRespDto.getDiscountAmount());
            orderBo.setCountPreview(previewRespDto);
            if (previewRespDto.getTotalIntegral() != null) {
                orderBo.getOrderEo().setIntegral(Integer.valueOf(previewRespDto.getTotalIntegral().intValue()));
            }
            orderBo.getOrderEo().setTotalAmount(previewRespDto.getTotalAmount());
            orderBo.getOrderEo().setPayAmount(previewRespDto.getPayAmount());
            orderBo.getOrderEo().setDiscountAmount(previewRespDto.getDiscountAmount());
            orderBo.getOrderEo().setFreightAmount(previewRespDto.getFreightAmount());
            orderBo.getOrderEo().setPresentPoint(previewRespDto.getPresentPoint());
            if (previewRespDto.isUsePointDeduct()) {
                orderBo.getOrderEo().setTotalCashOutAmount(previewRespDto.getTotalCashOutAmount());
                orderBo.getOrderEo().setTotalCashOutPoint(previewRespDto.getTotalCashOutPoint());
            }
            orderReq.setTotalCashOutAmount(previewRespDto.getTotalCashOutAmount());
            orderReq.setTotalCashOutPoint(previewRespDto.getTotalCashOutPoint());
            Map<String, TradeItemRespDto> activitySkuItemMap = previewRespDto.getOrderItems().stream().collect(Collectors.toMap(item -> item.getShopId() + item.getSkuSerial() + item.getGift(), item -> item));
            for (TradeItemEo tradeItemEo : orderBo.getTradeItemEoList()) {
                TradeItemRespDto tradeItemRespDto = activitySkuItemMap.get(tradeItemEo.getShopId() + tradeItemEo.getSkuSerial() + tradeItemEo.getGift());
                tradeItemEo.setItemPrice(tradeItemRespDto.getItemPrice());
                tradeItemEo.setItemOrigPrice(tradeItemRespDto.getItemOrigPrice());
                tradeItemEo.setPayTotalAmount(tradeItemRespDto.getPayTotalAmount().compareTo(BigDecimal.ZERO) == -1 ? BigDecimal.ZERO : tradeItemRespDto.getPayTotalAmount());
                tradeItemEo.setItemMarketPrice(tradeItemRespDto.getItemMarketPrice());
                tradeItemEo.setPlatformDiscountPrice(tradeItemRespDto.getPlatformDiscountPrice());
                tradeItemEo.setDiscountTotalAmount(tradeItemRespDto.getDiscountTotalAmount());
                if (!previewRespDto.isUsePointDeduct()) continue;
                tradeItemEo.setCashOutAmount(tradeItemRespDto.getCashOutAmount());
                tradeItemEo.setCashOutPoint(tradeItemRespDto.getCashOutPoint());
            }
        }
        this.checkStartPric(orderReq);
        return orderBo;
    }

    private void checkStartPric(OrderReqDto orderReqDto) {
        if (orderReqDto.getFreightAmount() == null) {
            orderReqDto.setFreightAmount(BigDecimal.ZERO);
        }
        if (orderReqDto.getStartingPric() == null) {
            orderReqDto.setStartingPric(BigDecimal.ZERO);
        }
        if (orderReqDto.getStartingPric().compareTo(orderReqDto.getPayAmount().subtract(orderReqDto.getFreightAmount())) > 0) {
            throw new BizException("\u4e0d\u6ee1\u8db3\u8d77\u9001\u4ef7");
        }
    }

    public OrderCreateBo splitOrder(OrderCreateBo orderCreateBo, OrderReqDto orderReq) {
        boolean isChildrenOrder = StringUtils.isNotEmpty((CharSequence)orderCreateBo.getOrderEo().getParentOrderNo());
        if (isChildrenOrder) {
            return orderCreateBo;
        }
        if (orderCreateBo.getCountPreview() == null) {
            return orderCreateBo;
        }
        OrderSplitReqDto orderSplit = orderCreateBo.getCountPreview().getOrderSplit();
        if (orderSplit == null || CollectionUtils.isEmpty((Collection)orderSplit.getChildrenOrderList())) {
            return orderCreateBo;
        }
        orderCreateBo.getOrderEo().setIsSplit(Integer.valueOf(1));
        ArrayList<OrderCreateBo> orderChildList = new ArrayList<OrderCreateBo>();
        ArrayList<OrderCreateBo> orderChildSuccessList = new ArrayList<OrderCreateBo>();
        for (OrderReqDto childrenOrder : orderSplit.getChildrenOrderList()) {
            childrenOrder.setTradeNo(TradeUtil.generateTradeNo(orderReq.getTradeNo()));
            childrenOrder.setParentOrderNo(orderCreateBo.getOrderEo().getOrderNo());
            childrenOrder.setActivity(null);
            childrenOrder.setIsSplit(Integer.valueOf(0));
            OrderCreateBo orderCreate = new OrderCreateBo();
            orderCreate.setOrderReqDto(childrenOrder);
            orderCreate.setStartFlowParam(orderCreateBo.getCurrentFlowDefId(), orderCreateBo.getCurrentFlowName());
            orderChildList.add(orderCreate);
        }
        for (OrderCreateBo orderCreate : orderChildList) {
            this.createOrderFlowAction.createOrder(orderCreate);
            orderChildSuccessList.add(orderCreate);
        }
        return orderCreateBo;
    }

    protected void dealErrorChildrenOrder(OrderCreateBo currentChildCreate, List<OrderCreateBo> childrenOrderList) {
        for (OrderCreateBo childOrder : childrenOrderList) {
            try {
                CancelOrderBo cancelOrderBo = new CancelOrderBo();
                cancelOrderBo.setOrderEo(childOrder.getOrderEo());
                cancelOrderBo.setDriveFlowParam(this.getFlowDefId(), this.getFlowDefName(), childOrder.getOrderEo().getOrderNo());
                cancelOrderBo.setToStatus("CANCEL");
                this.orderFlowAction.cancelOrder(cancelOrderBo);
            }
            catch (Exception cancelE) {
                logger.error("\u53d6\u6d88\u56de\u6eda\u8ba2\u5355\u51fa\u9519", (Throwable)cancelE);
            }
        }
        try {
            this.createOrderFlowAction.checkAndRollBackErrorOrder(currentChildCreate);
        }
        catch (Exception orderEx) {
            logger.error("\u56de\u6eda\u5f02\u5e38\u8ba2\u5355\u51fa\u9519", (Throwable)orderEx);
        }
    }

    public OrderCreateBo preJoinActivity(OrderCreateBo orderBo, OrderReqDto orderReq) {
        boolean isChildrenOrder = StringUtils.isNotEmpty((CharSequence)orderBo.getOrderEo().getParentOrderNo());
        if (!isChildrenOrder && orderReq.getActivity() != null && CollectionUtils.isNotEmpty((Collection)orderReq.getActivity().getActivityList())) {
            this.preJoinActivity(orderReq);
        }
        return orderBo;
    }

    public void preJoinActivity(OrderReqDto orderReq) {
        if (orderReq.getActivity() != null && CollectionUtils.isNotEmpty((Collection)orderReq.getActivity().getActivityList())) {
            this.extlOrderActivityService.preJoinActivity(orderReq);
            List activityList = orderReq.getActivity().getActivityList();
            activityList.stream().forEach(activity -> {
                OrderActivityAddReqDto activityAddReqDto = new OrderActivityAddReqDto();
                activityAddReqDto.setTradeNo(orderReq.getTradeNo());
                activityAddReqDto.setOrderNo(orderReq.getTradeNo());
                activityAddReqDto.setUserId(orderReq.getUserId());
                activityAddReqDto.setUserSrc(orderReq.getUserSrc());
                activityAddReqDto.setStatus(Integer.valueOf(0));
                activityAddReqDto.setParentType(activity.getType());
                activityAddReqDto.setType(activity.getType());
                activityAddReqDto.setParentActivityId("0L");
                activityAddReqDto.setActivityId(activity.getActivityId().toString());
                activityAddReqDto.setExtension(JSON.toJSONString((Object)activity));
                this.orderActivityService.add(activityAddReqDto);
            });
        }
    }

    public OrderCreateBo save(OrderCreateBo orderBo, OrderReqDto orderReq) {
        return orderBo;
    }

    public OrderCreateBo postProcessor(OrderCreateBo orderBo, OrderReqDto orderReq) {
        ContextUtil.getInstanceId();
        OrderCloseMessageVo messageVo = new OrderCloseMessageVo(orderBo.getOrderEo().getOrderNo(), null, orderReq.getCloseTime(), orderReq.getTenantId(), orderReq.getInstanceId());
        this.orderCloseProducer.sendOrderCloseMsg(messageVo);
        return orderBo;
    }

    public OrderRefactorBo completeOrder(OrderRefactorBo orderBo) {
        orderBo.getOrderEo().setEndTime(new Date());
        this.extlOrderActivityService.returnPoints(orderBo.getOrderEo());
        this.marketOrderTradeStatusProducer.sendOrderCompleteMessage(orderBo.getOrderEo().getOrderNo());
        return orderBo;
    }

    public String isGroupOrder(OrderEo orderEo) {
        try {
            if (OrderBizTypeEnum.GROUPORDER.getType().toString().equals(orderEo.getBizType())) {
                return "TRUE";
            }
            return "FALSE";
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return "fail";
        }
    }

    public CancelOrderBo cancelOrder(CancelOrderBo cancelOrderBo) {
        OrderEo orderEo = cancelOrderBo.getOrderEo();
        CancelReqDto cancelReqDto = cancelOrderBo.getCancelReqDto();
        if (cancelReqDto == null) {
            cancelReqDto = new CancelReqDto();
        }
        boolean ifSkill = this.orderService.checkIfSkill(orderEo);
        if (!orderEo.getBizType().equals("2") && !ifSkill) {
            this.orderService.rollbackOrderStock(orderEo);
        }
        if (cancelReqDto.getCancelType() == null || cancelReqDto.getCancelDesc() == null) {
            cancelReqDto.setCancelType(OrderCancelTypeEnum.SYSTEM_CANCLE.getName());
            cancelReqDto.setCancelDesc(OrderCancelTypeEnum.SYSTEM_CANCLE.getDesc());
        }
        if (cancelOrderBo.getOrderEo() == null) {
            orderEo = this.orderDas.lockByOrderNo(cancelOrderBo.getCancelReqDto().getTradeNo());
            cancelOrderBo.setOrderEo(orderEo);
        }
        cancelOrderBo.getOrderEo().setCancelDesc(cancelReqDto.getCancelDesc());
        orderEo.setCancelTime(new Date());
        orderEo.setCancelType(cancelReqDto.getCancelType());
        this.orderService.refundCancelOrder(orderEo, cancelReqDto);
        this.rush(cancelOrderBo);
        if (cancelOrderBo.ifNoUseFlow()) {
            this.orderDas.updateSelective((BaseEo)orderEo);
        }
        if (this.isGroupOrder(orderEo).equals("TRUE")) {
            logger.info("\u62fc\u56e2\u5931\u8d25\u8ba2\u5355{},\u53d1\u9001\u6d88\u606f\u5230\u8425\u9500", (Object)orderEo.getOrderNo());
            this.marketOrderTradeStatusProducer.sendGroupOrderFailMessageToMarket(orderEo.getOrderNo());
        }
        if (StringUtils.isEmpty((CharSequence)cancelOrderBo.getToStatus())) {
            cancelOrderBo.setToStatus("CANCEL");
        }
        if ("WAIT_AUDIT".equals(orderEo.getOrderTradeStatus())) {
            logger.info("\u8ba2\u5355\uff1a{}\u5ba1\u6838\u4e0d\u901a\u8fc7\uff0c\u72b6\u6001\u66f4\u65b0\u4e3a\u5df2\u5173\u95ed\u3002", (Object)orderEo.getOrderNo());
            cancelOrderBo.setToStatus("CLOSED");
        }
        return cancelOrderBo;
    }

    private void rush(CancelOrderBo cancelOrderBo) {
        PointsTradeInfoReqDto pointsTradeInfoReqDto = new PointsTradeInfoReqDto();
        Long userId = this.context.userId();
        OrderEo orderEo = cancelOrderBo.getOrderEo();
        if (userId != null && orderEo != null) {
            Long memberId = (Long)RestResponseHelper.extractData((RestResponse)this.memberInfoExtQueryApi.queryMemberIdByUserId(userId));
            pointsTradeInfoReqDto.setMemberId(memberId);
            pointsTradeInfoReqDto.setOrderNo(orderEo.getOrderNo());
            String sendJson = JSON.toJSONString((Object)pointsTradeInfoReqDto);
            logger.info("\u53d6\u6d88\u5355\u53f7{}\u8ba2\u5355\u62b5\u73b0\u79ef\u5206\u51b2\u6b63\u8acb\u6c42dto={}", (Object)orderEo.getOrderNo(), (Object)sendJson);
            this.pointCashOutApi.rush(pointsTradeInfoReqDto);
        }
    }
}

