/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.flow.newaction.extptimpl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.enhance.extension.CubeExtImpl;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.payment.dto.notify.PayOrderNotifyRequest;
import com.dtyunxi.yundt.cube.center.trade.api.constants.PayTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.biz.constants.BaseFlowDef;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.newaction.PayNotifyFlowAction;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.producer.IntegralOrderPayProducer;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.vo.IntegralOrderPayMessageVo;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderService;
import com.dtyunxi.yundt.cube.center.trade.dao.das.PayRecordDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.PayRecordEo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.IPayNotifyActionExtPt;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.PayOrderNotifyBo;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@CubeExtImpl(name="B2C\u7aef\u652f\u4ed8\u56de\u8c03\u6269\u5c55", descr="B2C\u7aef\u652f\u4ed8\u56de\u8c03\u6269\u5c55")
public class PayNotifyActionBBCExtPtImpl
implements IPayNotifyActionExtPt {
    private static final Logger logger = LoggerFactory.getLogger(PayNotifyActionBBCExtPtImpl.class);
    @Resource
    private PayRecordDas payRecordDas;
    @Resource
    private IOrderService orderService;
    @Resource
    private PayNotifyFlowAction payNotifyFlowAction;
    @Resource
    private IntegralOrderPayProducer integralOrderPayProducer;

    public Long getFlowDefId() {
        return BaseFlowDef.BASE_PAY.getFlowId();
    }

    public String getFlowName() {
        return BaseFlowDef.BASE_PAY.getFlowName();
    }

    public PayOrderNotifyRequest validate(PayOrderNotifyRequest notifyReq) {
        return notifyReq;
    }

    public PayOrderNotifyBo packBo(PayOrderNotifyBo payOrderNotifyBo, PayOrderNotifyRequest notifyReq) {
        if ("S".equals(notifyReq.getOrderStatus())) {
            PayRecordEo payRecordEo = payOrderNotifyBo.getPayRecordEo();
            Integer integral = payRecordEo.getIntegral();
            if (!PayTypeEnum.INTEGRAL.getCode().equals(payRecordEo.getPayMethod()) && integral != null && integral > 0) {
                IntegralOrderPayMessageVo integralOrderPayMessageVo = new IntegralOrderPayMessageVo(payRecordEo.getOrderNo(), payRecordEo.getPayNo(), PayTypeEnum.INTEGRAL.getCode());
                logger.info("\u79ef\u5206\u6df7\u5408\u8ba2\u5355\u7684\u79ef\u5206\u652f\u4ed8: {}", (Object)JSON.toJSONString((Object)integralOrderPayMessageVo));
                this.integralOrderPayProducer.sendPayMsg(integralOrderPayMessageVo);
            }
        }
        PayRecordEo query = PayRecordEo.newInstance();
        query.setParentPayNo(payOrderNotifyBo.getPayRecordEo().getPayNo());
        List list = this.payRecordDas.select((BaseEo)query);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            list.stream().forEach(bean -> {
                bean.setExtlPaySerial(notifyReq.getTradeId());
                bean.setPayStatus(payOrderNotifyBo.getPayRecordEo().getPayStatus());
            });
            payOrderNotifyBo.setSubPayRecordEos(list);
        }
        return payOrderNotifyBo;
    }

    public PayOrderNotifyBo update(PayOrderNotifyBo payOrderNotifyBo, PayOrderNotifyRequest notifyReq) {
        return payOrderNotifyBo;
    }

    public String checkIfRefund(PayOrderNotifyBo payOrderNotifyBo) {
        if (payOrderNotifyBo.getPayRecordEo().getOrderNo() == null) {
            return "TRUE";
        }
        OrderEo orderEo = this.orderService.queryByOrderNo(payOrderNotifyBo.getPayRecordEo().getOrderNo());
        if (orderEo != null) {
            if (orderEo.getCancelTime() != null) {
                return "TRUE";
            }
            if (orderEo.getPayTime() != null) {
                PayRecordEo payRecordEo = new PayRecordEo();
                payRecordEo.setOrderNo(payOrderNotifyBo.getPayRecordEo().getOrderNo());
                List resultList = this.payRecordDas.select((BaseEo)payRecordEo);
                for (PayRecordEo payRecord : resultList) {
                    if (payRecord.getPayFinishTime() == null || payRecord.getPayNo().equals(payOrderNotifyBo.getPayRecordEo().getPayNo())) continue;
                    return "TRUE";
                }
            }
        } else {
            return "TRUE";
        }
        return "FALSE";
    }

    public String postProcessor(PayOrderNotifyBo payOrderNotifyBo, PayOrderNotifyRequest notifyReq, String result) {
        if (CollectionUtils.isNotEmpty((Collection)payOrderNotifyBo.getSubPayRecordEos())) {
            for (PayRecordEo payRecordEo : payOrderNotifyBo.getSubPayRecordEos()) {
                PayOrderNotifyBo payOrderNotify = new PayOrderNotifyBo();
                payOrderNotify.setPayOrderNotifyRequest(notifyReq);
                payOrderNotify.setDriveFlowParam(this.getFlowDefId(), this.getFlowName(), payRecordEo.getPayNo());
                this.payNotifyFlowAction.handleNotify(payOrderNotify);
            }
        }
        return result;
    }
}

