/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.flow.newaction.status;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.enhance.CubeResource;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.trade.biz.constants.BaseFlowDef;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.StatusFlowInstanceInfo;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.ext.AbstractStatusAdapter;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.ext.StatusEO;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.producer.DeliveryProducer;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IDeliveryService;
import com.dtyunxi.yundt.cube.center.trade.dao.das.DeliveryItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderDeliveryDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.RefDeliveryOrderDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderDeliveryEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.RefDeliveryOrderEo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.IDeliveryOrderStateChangeExtPt;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.DeliveryOrderVo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.GenerateDeliveryBo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.OrderDeliveryCreateBo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.OrderDeliveryStatusBo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="deliveryOrderStatusAdapter")
@StatusEO(entity=OrderDeliveryEo.class, flowNoField="deliveryNo", entityField="orderDeliveryEo", groupName="\u53d1\u8d27\u5355")
public class DeliveryOrderStatusAdapter
extends AbstractStatusAdapter {
    private static Logger logger = LoggerFactory.getLogger(DeliveryOrderStatusAdapter.class);
    @Resource
    private IDeliveryService deliveryService;
    @Resource
    private OrderDeliveryDas orderDeliveryDas;
    @Autowired
    private DeliveryProducer deliveryProducer;
    @Resource
    private RefDeliveryOrderDas refDeliveryOrderDas;
    @Resource
    private DeliveryItemDas deliveryItemDas;
    @CubeResource
    private IDeliveryOrderStateChangeExtPt deliveryOrderStateChangeExtPt;

    @Override
    public Object getEntity(String flowName, String flowNo) {
        OrderDeliveryEo orderDeliveryEo = new OrderDeliveryEo();
        orderDeliveryEo.setDeliveryNo(flowNo);
        List list = this.orderDeliveryDas.select((BaseEo)orderDeliveryEo);
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new BizException("\u53d1\u8d27\u5355\u53f7" + flowNo + "\u65e0\u6cd5\u67e5\u8be2\u8bb0\u5f55");
        }
        return list.get(0);
    }

    @Override
    public void save(String flowName, Object saveEntity, boolean isStartCreate) {
        super.save(flowName, saveEntity, isStartCreate);
    }

    @Override
    public void statusChangeListen(StatusFlowInstanceInfo statusFlowInstanceInfo, Object beforeMethodInputParam, Object beforeMethodReturnParam) {
        logger.info("\u53d1\u8d27\u5355\u53f7=" + statusFlowInstanceInfo.getFlowNo() + "\u8fdb\u5165\u72b6\u6001\u53d8\u66f4\u4e8b\u4ef6");
        if (BaseFlowDef.BASE_DELIVERY.getFlowName().equals(statusFlowInstanceInfo.getFlowName())) {
            DeliveryOrderVo deliveryOrderVo;
            ArrayList<RefDeliveryOrderEo> refDeliveryOrderEos;
            if (beforeMethodReturnParam instanceof OrderDeliveryStatusBo) {
                OrderDeliveryStatusBo orderDeliveryBo = (OrderDeliveryStatusBo)beforeMethodReturnParam;
                logger.info("\u53d1\u8d27\u5355{}\u53d1\u751f\u72b6\u6001\u64cd\u4f5c{}\u524d\u7f6e\u72b6\u6001{}\u5f53\u524d\u72b6\u6001{}", new Object[]{orderDeliveryBo.getOrderDeliveryEo().getDeliveryNo(), orderDeliveryBo.getOptCode(), orderDeliveryBo.getPreStatus(), orderDeliveryBo.getOrderDeliveryEo().getDeliveryStatus()});
                this.deliveryService.sendMessageToInv(orderDeliveryBo);
            }
            if (beforeMethodReturnParam instanceof OrderDeliveryCreateBo) {
                OrderDeliveryCreateBo orderDeliveryCreateBo = (OrderDeliveryCreateBo)beforeMethodReturnParam;
                refDeliveryOrderEos = new ArrayList<RefDeliveryOrderEo>();
                refDeliveryOrderEos.add(orderDeliveryCreateBo.getRefDeliveryOrderEo());
                deliveryOrderVo = new DeliveryOrderVo();
                deliveryOrderVo.setOrderDelivery(orderDeliveryCreateBo.getOrderDeliveryEo());
                deliveryOrderVo.setRefDeliveryOrders(refDeliveryOrderEos);
                deliveryOrderVo.setDeliveryItems(orderDeliveryCreateBo.getDeliveryItemEoList());
                this.deliveryProducer.sendInventoryDelivery(deliveryOrderVo);
                logger.info("\u540c\u6b65\u5546\u57ce\u8ba2\u5355\u5230\u5e93\u5b58\u4e2d\u5fc3...");
            }
            if (beforeMethodReturnParam instanceof GenerateDeliveryBo) {
                GenerateDeliveryBo generateDeliveryBo = (GenerateDeliveryBo)beforeMethodReturnParam;
                refDeliveryOrderEos = new ArrayList();
                refDeliveryOrderEos.add(generateDeliveryBo.getRefDeliveryOrderEo());
                deliveryOrderVo = new DeliveryOrderVo();
                deliveryOrderVo.setOrderDelivery(generateDeliveryBo.getOrderDeliveryEo());
                deliveryOrderVo.setRefDeliveryOrders(refDeliveryOrderEos);
                deliveryOrderVo.setDeliveryItems(generateDeliveryBo.getDeliveryItemEoList());
                this.deliveryProducer.sendInventoryDelivery(deliveryOrderVo);
                logger.info("\u53d1\u9001\u53d1\u8d27\u5355:{}\u5230\u5e93\u5b58\u4e2d\u5fc3...", (Object)deliveryOrderVo.getOrderDelivery().getDeliveryNo());
                List deliveryChildList = generateDeliveryBo.getDeliveryChildList();
                if (CollectionUtils.isNotEmpty((Collection)deliveryChildList)) {
                    deliveryChildList.forEach(child -> {
                        OrderDeliveryEo orderDelivery = child.getOrderDelivery();
                        List deliveryItems = child.getDeliveryItems();
                        List refDeliveryOrders = child.getRefDeliveryOrders();
                        if (null == orderDelivery.getId()) {
                            logger.info("\u4fdd\u5b58\u5b50\u53d1\u8d27\u5355\uff1a{}", (Object)orderDelivery.getDeliveryNo());
                            this.deliveryItemDas.insertBatch(deliveryItems);
                            this.refDeliveryOrderDas.insertBatch(refDeliveryOrders);
                            this.orderDeliveryDas.insert((BaseEo)orderDelivery);
                        }
                    });
                    logger.info("\u53d1\u9001\u5b50\u53d1\u8d27\u5355\u5230\u5e93\u5b58\u4e2d\u5fc3");
                    deliveryChildList.forEach(deliveryChild -> {
                        this.deliveryProducer.sendInventoryDelivery((DeliveryOrderVo)deliveryChild);
                        logger.info("\u53d1\u9001\u5b50\u53d1\u8d27\u5355\uff1a{}\u5230\u5e93\u5b58\u4e2d\u5fc3...", (Object)deliveryChild.getOrderDelivery().getDeliveryNo());
                    });
                } else {
                    logger.info("\u65e0\u5b50\u53d1\u8d27\u5355\u2026\u2026");
                }
            }
        }
        if (this.deliveryOrderStateChangeExtPt != null) {
            OrderDeliveryEo orderDeliveryEo = (OrderDeliveryEo)statusFlowInstanceInfo.getEntityEo();
            this.deliveryOrderStateChangeExtPt.notify(orderDeliveryEo.getTradeNo(), orderDeliveryEo.getOrderNo(), orderDeliveryEo.getDeliveryNo(), orderDeliveryEo.getParentDeliveryNo(), orderDeliveryEo.getDeliveryStatus());
        }
    }
}

