/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.mq.process;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.DeliveryRouteRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.DeliveryStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.query.IWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderDeliveryDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderDeliveryEo;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="INVENTORY_ROUTE_RESULT_TOPIC", tag="INVENTORY_ROUTE_RESULT_TAG")
public class DeliveryRouteProcess
implements IMessageProcessor<DeliveryRouteRespDto> {
    private Logger logger = LoggerFactory.getLogger(DeliveryRouteProcess.class);
    @Autowired
    private OrderDeliveryDas orderDeliveryDas;
    @Autowired
    private IWarehouseQueryApi warehouseQueryApi;

    public MessageResponse process(DeliveryRouteRespDto deliveryRouteRespDto) {
        Thread.currentThread().setName("DELIVERY-ROUTE-PROCESS-" + deliveryRouteRespDto.getDeliveryNo() + "-" + UUID.randomUUID().toString());
        this.logger.info("\u6536\u5230\u5e93\u5b58\u4e2d\u5fc3\u53d1\u8d27\u5355\u8def\u7531\u7ed3\u679c\uff0cdeliveryNo :{}, DeliveryRouteRespDto\uff1a{}", (Object)deliveryRouteRespDto.getDeliveryNo(), (Object)JSON.toJSONString((Object)deliveryRouteRespDto));
        OrderDeliveryEo deliverySelect = OrderDeliveryEo.newInstance();
        deliverySelect.setDeliveryNo(deliveryRouteRespDto.getDeliveryNo());
        OrderDeliveryEo orderDeliveryEo = (OrderDeliveryEo)this.orderDeliveryDas.selectOne((BaseEo)deliverySelect);
        if (null == orderDeliveryEo) {
            this.logger.error("\u66f4\u65b0\u53d1\u8d27\u5355\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u53d1\u8d27\u5355\u4fe1\u606f\uff0cdeliveryNo\uff1a{}", (Object)deliveryRouteRespDto.getDeliveryNo());
            return MessageResponse.SUCCESS;
        }
        OrderDeliveryEo orderDeliveryUpdate = OrderDeliveryEo.newInstance();
        orderDeliveryUpdate.setId(orderDeliveryEo.getId());
        orderDeliveryUpdate.setDeliveryStatus(deliveryRouteRespDto.getDeliveryStatus());
        orderDeliveryUpdate.setWarehouseCode(deliveryRouteRespDto.getWarehouseCode());
        orderDeliveryUpdate.setWarehouseSubType(deliveryRouteRespDto.getWarehouseSubType());
        orderDeliveryUpdate.setWarehouseName(deliveryRouteRespDto.getWarehouseName());
        if (StringUtils.isEmpty((CharSequence)deliveryRouteRespDto.getWarehouseName()) && StringUtils.isNotEmpty((CharSequence)deliveryRouteRespDto.getWarehouseCode())) {
            WarehouseRespDto warehouseRespDto = (WarehouseRespDto)this.warehouseQueryApi.queryWarehouseByCode(deliveryRouteRespDto.getWarehouseCode(), null).getData();
            if (null != warehouseRespDto) {
                orderDeliveryUpdate.setWarehouseName(warehouseRespDto.getName());
                orderDeliveryUpdate.setWarehouseOrganizationId(warehouseRespDto.getOrganizationId());
                orderDeliveryUpdate.setWarehouseOrganizationName(warehouseRespDto.getOrganizationName());
                this.logger.info("\u6536\u5230\u5e93\u5b58\u4e2d\u5fc3\u53d1\u8d27\u5355\u8def\u7531\u7ed3\u679c --> \u66f4\u65b0\u5e93\u5b58\u4e2d\u5fc3\u5173\u8054\u7684\u7ec4\u7ec7\u6743\u9650(\u4ed3\u5e93id)(bbc\u5546\u573a) --> \u4f4d\u7f6e\uff1a{}\uff0c\u8bbe\u7f6e\u7ec4\u7ec7\u6743\u9650\u503c\u7684\u5b9e\u4f53\uff1a{}", (Object)"[DeliveryRouteProcess].[process]", (Object)JSONObject.toJSONString((Object)orderDeliveryUpdate));
            } else {
                orderDeliveryUpdate.setWarehouseOrganizationId(Long.valueOf(0L));
                orderDeliveryUpdate.setWarehouseOrganizationName("\u9ed8\u8ba4\u6743\u9650");
                this.logger.warn("\u6839\u636e\u4ed3\u5e93\u7f16\u7801\u67e5\u8be2\u4ed3\u5e93\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u6570\u636e\uff0cwarehouseCode:{}", (Object)deliveryRouteRespDto.getWarehouseCode());
                this.logger.info("\u6536\u5230\u5e93\u5b58\u4e2d\u5fc3\u53d1\u8d27\u5355\u8def\u7531\u7ed3\u679c --> \u66f4\u65b0\u5e93\u5b58\u4e2d\u5fc3\u5173\u8054\u7684\u7ec4\u7ec7\u6743\u9650(\u4ed3\u5e93id)(bbc\u5546\u573a) --> \u4f4d\u7f6e\uff1a{}\uff0c\u8bbe\u7f6e\u7ec4\u7ec7\u6743\u9650\u503c\u7684\u5b9e\u4f53\uff1a{}", (Object)"[DeliveryRouteProcess].[process]", (Object)JSONObject.toJSONString((Object)orderDeliveryUpdate));
            }
        }
        if (DeliveryStatusEnum.TO_ASSIGN.getStatus().equals(deliveryRouteRespDto.getDeliveryStatus()) || DeliveryStatusEnum.TO_DO.getStatus().equals(deliveryRouteRespDto.getDeliveryStatus()) || DeliveryStatusEnum.CANCELED.getStatus().equals(deliveryRouteRespDto.getDeliveryStatus())) {
            orderDeliveryUpdate.clearWarehouse();
        }
        this.orderDeliveryDas.updateSelective((BaseEo)orderDeliveryUpdate);
        this.logger.info("\u53d1\u8d27\u5355\u72b6\u6001\u53d1\u751f\u53d8\u5316\uff0c\u7531{}\u53d8\u4e3a{}", (Object)orderDeliveryEo.getDeliveryStatus(), (Object)orderDeliveryUpdate.getDeliveryStatus());
        return MessageResponse.SUCCESS;
    }
}

