/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.mq.process;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.DeliveryRouteRespDto;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.vo.DeliverySplitResultVo;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.vo.DeliveryVo;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IDeliveryService;
import com.dtyunxi.yundt.cube.center.trade.dao.das.DeliveryItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderDeliveryDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.RefDeliveryOrderDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.DeliveryItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderDeliveryEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.RefDeliveryOrderEo;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="INVENTORY_ROUTE_RESULT_TOPIC", tag="INVENTORY_ROUTE_SPLIT_RESULT_TAG")
public class DeliveryRouteSplitProcess
implements IMessageProcessor<String> {
    private Logger logger = LoggerFactory.getLogger(DeliveryRouteSplitProcess.class);
    @Autowired
    private OrderDeliveryDas orderDeliveryDas;
    @Autowired
    private RefDeliveryOrderDas refDeliveryOrderDas;
    @Autowired
    private DeliveryItemDas deliveryItemDas;
    @Autowired
    private IDeliveryService deliveryService;

    public MessageResponse process(String deliverySplitResultJson) {
        DeliverySplitResultVo deliveryOrderVo = (DeliverySplitResultVo)JSON.parseObject((String)deliverySplitResultJson, DeliverySplitResultVo.class);
        Thread.currentThread().setName("DELIVERY-ROUTE-SPLIT-PROCESS-" + deliveryOrderVo.getSplitParent().getDeliveryNo() + "-" + UUID.randomUUID().toString());
        this.logger.info("\u63a5\u6536\u5230\u5e93\u5b58\u4e2d\u5fc3\u62c6\u5355\u4fe1\u606fdeliverySplitResultJson\uff1a{}", (Object)deliverySplitResultJson);
        DeliveryRouteRespDto splitParent = deliveryOrderVo.getSplitParent();
        List<DeliveryVo> splitChilds = deliveryOrderVo.getSplitChilds();
        OrderDeliveryEo orderDeliveryEo = this.deliveryService.getOrderDeliveryByDeliveryNo(splitParent.getDeliveryNo());
        OrderDeliveryEo orderDeliveryUpdate = OrderDeliveryEo.newInstance();
        orderDeliveryUpdate.setId(orderDeliveryEo.getId());
        orderDeliveryUpdate.setDeliveryStatus(splitParent.getDeliveryStatus());
        orderDeliveryUpdate.setWarehouseCode("");
        orderDeliveryUpdate.setWarehouseName("");
        this.orderDeliveryDas.updateSelective((BaseEo)orderDeliveryUpdate);
        this.logger.info("\u66f4\u65b0\u7236\u53d1\u8d27\u5355:{}\u5b8c\u6bd5\u3002", (Object)splitParent.getDeliveryNo());
        for (DeliveryVo deliveryVo : splitChilds) {
            OrderDeliveryEo orderDelivery = deliveryVo.getOrderDelivery();
            List<RefDeliveryOrderEo> refDeliveryOrders = deliveryVo.getRefDeliveryOrders();
            List<DeliveryItemEo> deliveryItems = deliveryVo.getDeliveryItems();
            orderDelivery.setId(null);
            refDeliveryOrders.forEach(refDeliveryOrderEo -> refDeliveryOrderEo.setId(null));
            deliveryItems.forEach(deliveryItemEo -> deliveryItemEo.setId(null));
            this.orderDeliveryDas.insert((BaseEo)orderDelivery);
            this.refDeliveryOrderDas.insertBatch(refDeliveryOrders);
            this.deliveryItemDas.insertBatch(deliveryItems);
            this.logger.info("\u4fdd\u5b58\u5b50\u53d1\u8d27\u5355\uff1a{}\u5b8c\u6bd5\u3002", (Object)orderDelivery.getDeliveryNo());
        }
        return MessageResponse.SUCCESS;
    }
}

