/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.mq.process;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.DeliveryPackageReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.PackageItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.vo.OutPackageMessageVo;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.vo.OutStorageMessageVo;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.vo.PackDetailMessageVo;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderDeliveryService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
@MQDesc(tag="delivery_storage_out3", consumer="delivery_storage_out3", msgType="publish")
public class DeliveryStorageOutProcess
implements IMessageProcessor {
    private Logger logger = LoggerFactory.getLogger(DeliveryStorageOutProcess.class);
    @Resource
    private IOrderDeliveryService deliveryService;
    @Resource
    private ICacheService cacheService;

    public MessageResponse process(Object message) {
        String messageStr = JSON.toJSONString((Object)message);
        this.logger.info("\u83b7\u53d6\u5230\u5e93\u5b58\u4e2d\u5fc3\u6d88\u606f\uff1a{}", (Object)messageStr);
        MessageVo messageVo = (MessageVo)message;
        JSONObject outStorageMessageVo = JSON.parseObject((String)String.valueOf(messageVo.getData()));
        OutStorageMessageVo outStorageMessage = (OutStorageMessageVo)((Object)JSONObject.toJavaObject((JSON)outStorageMessageVo, OutStorageMessageVo.class));
        if (StringUtils.isEmpty(outStorageMessage.getOutPackageList())) {
            return MessageResponse.SUCCESS;
        }
        return this.handleWarehouseOut(outStorageMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageResponse handleWarehouseOut(OutStorageMessageVo outStorageMessage) {
        String cacheKey = "out_order_no" + outStorageMessage.getStatus() + outStorageMessage.getStorageNo() + outStorageMessage.getOutPackageList().get(0).getId();
        Boolean success = this.cacheService.add(cacheKey, (Object)"1");
        if (success.booleanValue()) {
            try {
                Object packageMessageVos;
                if (outStorageMessage.getStatus().equals("create_out")) {
                    packageMessageVos = outStorageMessage.getOutPackageList();
                    if (CollectionUtils.isEmpty((Collection)packageMessageVos)) {
                        MessageResponse messageResponse = MessageResponse.SUCCESS;
                        return messageResponse;
                    }
                    ArrayList<DeliveryPackageReqDto> deliveryPackageReqDtos = new ArrayList<DeliveryPackageReqDto>();
                    Iterator iterator = packageMessageVos.iterator();
                    while (iterator.hasNext()) {
                        OutPackageMessageVo outPackageMessageVo = (OutPackageMessageVo)((Object)iterator.next());
                        ArrayList<PackageItemReqDto> packageItemEos = new ArrayList<PackageItemReqDto>();
                        for (PackDetailMessageVo packDetailMessageVo : outPackageMessageVo.getPackDetailMessageList()) {
                            PackageItemReqDto packageItemEo = new PackageItemReqDto();
                            packageItemEo.setPackageSerial(outPackageMessageVo.getId().toString());
                            packageItemEo.setPackageSrc("CUBE");
                            packageItemEo.setShippingSerial(outPackageMessageVo.getShippingNo());
                            packageItemEo.setShippingCompany(outPackageMessageVo.getShippingCompany());
                            if (packDetailMessageVo.getCargoId() != null) {
                                packageItemEo.setCargoSerial(packDetailMessageVo.getCargoId().toString());
                            }
                            int actualDeliveryNum = packDetailMessageVo.getNum().intValue();
                            packageItemEo.setActualDeliveryNum(Integer.valueOf(actualDeliveryNum));
                            packageItemEo.setActualDeliverySkuNum(Integer.valueOf(actualDeliveryNum));
                            packageItemEos.add(packageItemEo);
                        }
                        DeliveryPackageReqDto deliveryPackageReqDto = new DeliveryPackageReqDto();
                        deliveryPackageReqDto.setPackageItems(packageItemEos);
                        deliveryPackageReqDto.setTradeNo(outPackageMessageVo.getPackOrderNo());
                        deliveryPackageReqDtos.add(deliveryPackageReqDto);
                    }
                    this.deliveryService.deliveryStorageOut(deliveryPackageReqDtos, false);
                }
                packageMessageVos = MessageResponse.SUCCESS;
                return packageMessageVos;
            }
            catch (Exception e) {
                this.logger.info(e.getMessage(), (Throwable)e);
                MessageResponse messageResponse = MessageResponse.ERROR;
                return messageResponse;
            }
            finally {
                this.cacheService.delCache(cacheKey);
            }
        }
        this.logger.info("\u6d88\u606f\u4e4b\u524d\u5df2\u5904\u7406,\u76f4\u63a5\u629b\u5f03");
        return MessageResponse.SUCCESS;
    }
}

