/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.mq.process;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.enhance.CubeResource;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OrderCancelTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.CancelReqDto;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.OrderBo;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.newaction.OrderFlowAction;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.process.DeliveryStorageOutProcess;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.vo.ActivityGroupOperateOrderMessageVo;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.extl.IContextService;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderEo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.IOrderCreateActionExtPt;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.CancelOrderBo;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@MQDesc(tag="ACTIVITY_GROUP_ORDER_OPERATE", msgType="single")
public class OrderOperateProcess
implements IMessageProcessor<MessageVo> {
    private Logger logger = LoggerFactory.getLogger(DeliveryStorageOutProcess.class);
    @Resource
    private OrderFlowAction orderFlowAction;
    @Resource
    private IContextService contextService;
    @Resource
    private IOrderService orderService;
    @CubeResource
    private IOrderCreateActionExtPt orderCreateActionExtPt;

    public MessageResponse process(MessageVo messageObj) {
        Thread.currentThread().setName("op_" + UUID.randomUUID());
        String messageStr = JSON.toJSONString((Object)messageObj);
        ActivityGroupOperateOrderMessageVo message = (ActivityGroupOperateOrderMessageVo)((Object)JSON.parseObject((String)messageObj.getData().toString(), ActivityGroupOperateOrderMessageVo.class));
        this.logger.info("\u6536\u5230\u6d3b\u52a8\u64cd\u4f5c\u6d88\u606f\uff1a{}", (Object)messageStr);
        List<String> orderNos = message.getOrderNos();
        if ("CANCEL".equals(message.getOperate())) {
            orderNos.forEach(orderNo -> {
                OrderEo orderEo = this.orderService.queryByOrderNo((String)orderNo);
                this.contextService.getAndSetInstanceInfo(orderEo.getInstanceId());
                this.logger.info("\u6d3b\u52a8\u53d6\u6d88\u53d1\u8d27\u8ba2\u5355\u53f7\uff1a{}", orderNo);
                CancelOrderBo cancelOrderBo = new CancelOrderBo();
                cancelOrderBo.setDriveFlowParam(this.orderCreateActionExtPt.getFlowDefId(), this.orderCreateActionExtPt.getFlowDefName(), orderNo);
                CancelReqDto cancelReqDto = new CancelReqDto();
                cancelReqDto.setTradeNo(orderNo);
                cancelReqDto.setCancelDesc(OrderCancelTypeEnum.GROUP_FAIL_CANCLE.getDesc());
                cancelReqDto.setCancelType(OrderCancelTypeEnum.GROUP_FAIL_CANCLE.getName());
                cancelOrderBo.setCancelReqDto(cancelReqDto);
                cancelOrderBo.setToStatus("CLOSED");
                this.orderFlowAction.cancelOrder(cancelOrderBo);
            });
        } else {
            orderNos.forEach(orderNo -> {
                OrderEo orderEo = this.orderService.queryByOrderNo((String)orderNo);
                this.contextService.getAndSetInstanceInfo(orderEo.getInstanceId());
                this.logger.info("\u6d3b\u52a8\u751f\u6210\u53d1\u8d27\u8ba2\u5355\u53f7\uff1a{}", orderNo);
                OrderBo orderBo = new OrderBo();
                orderBo.setOrderEo(orderEo);
                orderBo.setOrderNo((String)orderNo);
                orderBo.setDriveFlowParam(this.orderCreateActionExtPt.getFlowDefId(), this.orderCreateActionExtPt.getFlowDefName(), (String)orderNo);
                this.orderFlowAction.deliveryOrderConfirm(orderBo);
            });
        }
        return MessageResponse.SUCCESS;
    }
}

