/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.mq.process;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.IOrderApi;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.vo.SeckillOrderMessageVo;
import java.util.Date;
import java.util.TimeZone;
import java.util.UUID;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@MQDesc(topic="${SECKILL_ORDER_TOPIC:SECKILL_ORDER_TOPIC}", tag="seckill_submit_order")
public class SeckillOrderProcess
implements IMessageProcessor<MessageVo> {
    private Logger logger = LoggerFactory.getLogger(SeckillOrderProcess.class);
    @Resource(name="orderApiImpl")
    IOrderApi orderApi;
    @Resource
    private ICacheService commonCacheService;
    @Resource
    private IShopQueryApi shopQueryApi;
    private String SECKILL_MESSAGE_FLAG = "seckill_message_flag";
    private Long SHOP_INTRA_CITY = 2L;
    private final int KEY_VALID_TIME = 86400;

    @Transactional(rollbackFor={Exception.class})
    public MessageResponse process(MessageVo messageVo) {
        boolean success;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u83b7\u53d6\u5230\u79d2\u6740\u8ba2\u5355\u6d88\u606f\uff1a{}", (Object)JSON.toJSONString((Object)messageVo));
        }
        Thread.currentThread().setName("thread_skill_" + UUID.randomUUID());
        TimeZone.setDefault(TimeZone.getTimeZone("GMT+8"));
        SeckillOrderMessageVo seckillOrder = (SeckillOrderMessageVo)((Object)JSON.parseObject((String)messageVo.getData().toString(), SeckillOrderMessageVo.class));
        this.logger.info("\u83b7\u53d6\u5230\u79d2\u6740\u6807\u8bc6\u53f7{}", (Object)seckillOrder.getSeckillKey());
        seckillOrder.setCloseTime(this.getCloseTime(seckillOrder.getPayOvertime()));
        if (seckillOrder.getMessageSendTime() != null) {
            Date date = new Date();
            this.logger.info("\u6d88\u606f\u53d1\u9001\u65f6\u95f4{}\uff0c\u63a5\u53d7\u65f6\u95f4{},\u82b1\u8d39\u65f6\u95f4{}", new Object[]{DateUtil.getDateFormat((Date)seckillOrder.getMessageSendTime(), (String)"yyyy-MM-dd HH:mm:ss"), DateUtil.getDateFormat((Date)date, (String)"yyyy-MM-dd HH:mm:ss"), date.getTime() - seckillOrder.getMessageSendTime().getTime()});
        }
        if (!(success = this.commonCacheService.add(this.getMessageFlagKey(seckillOrder.getSeckillKey()), (Object)"1", 86400))) {
            this.logger.info("\u79d2\u6740no ={} \u91cd\u590d\u4e86", (Object)seckillOrder.getSeckillKey());
        }
        seckillOrder.setFlowType("SKILL_ORDER");
        this.logger.info("\u914d\u9001\u7c7b\u578b{}", (Object)seckillOrder.getShippingType());
        String orderNo = (String)this.orderApi.addOrder((OrderReqDto)seckillOrder).getData();
        this.commonCacheService.setCache(seckillOrder.getSeckillKey(), (Object)orderNo);
        return MessageResponse.SUCCESS;
    }

    String getMessageFlagKey(String seckillKey) {
        return this.SECKILL_MESSAGE_FLAG + ":" + seckillKey;
    }

    private Date getCloseTime(Integer payOvertime) {
        if (payOvertime == null) {
            payOvertime = 30;
        }
        return DateUtil.addMinutes((Date)new Date(), (int)payOvertime);
    }
}

