/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.mq.process;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.biz.member.api.basis.dto.response.MemberPhoneRespDto;
import com.dtyunxi.yundt.cube.biz.member.api.basis.query.IMemberExtQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.DistributionRegisterRecordAddReqDto;
import com.dtyunxi.yundt.cube.center.trade.biz.service.ITradeConfQueryService;
import com.dtyunxi.yundt.cube.center.trade.dao.das.ShareRegisterDistributionDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.SharedRegisterDistributionEo;
import java.util.Date;
import javax.annotation.Resource;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="MEMBER_RELATION_DISTRIBUTION_REGISTER_PROTECT_TAG")
public class ShareRegisterDistributionProcess
implements IMessageProcessor<String> {
    private Logger logger = LoggerFactory.getLogger(ShareRegisterDistributionProcess.class);
    @Resource
    private ShareRegisterDistributionDas shareRegisterDistributionDas;
    @Resource
    private IMemberExtQueryApi memberExtQueryApi;
    @Resource
    private ITradeConfQueryService tradeConfQueryService;

    public MessageResponse process(String jsonStr) {
        this.logger.info("\u7528\u6237\u5173\u8054\u5206\u9500\u6ce8\u518c\u4fdd\u62a4\u8bb0\u5f55\u4fe1\u606f ---> \u6536\u5230\u7528\u6237\u5173\u8054\u5206\u9500\u6ce8\u518c\u4fdd\u62a4\u8bb0\u5f55\u4fe1\u606f\u7684MQ\u6d88\u606f:{}", (Object)JSONObject.toJSONString((Object)jsonStr));
        if (null == jsonStr) {
            this.logger.error("\u6d88\u606f\u4f53\u5185\u5bb9\u4e0d\u5168\uff0c\u5ffd\u7565\u5904\u7406");
            return MessageResponse.SUCCESS;
        }
        DistributionRegisterRecordAddReqDto reqDto = (DistributionRegisterRecordAddReqDto)JSON.parseObject((String)jsonStr, DistributionRegisterRecordAddReqDto.class);
        try {
            Long memberId = reqDto.getMemberId();
            Long commanderId = reqDto.getCommanderId();
            Long memberUserId = (Long)this.memberExtQueryApi.queryUserIdByMemberId(memberId).getData();
            this.logger.info("\u67e5\u8be2\u4f1a\u5458\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)memberUserId));
            if (memberUserId == null) {
                throw new BizException("\u67e5\u8be2\u4f1a\u5458\u7528\u6237id\u4e0d\u5b58\u5728\uff01");
            }
            Long commanderUserId = (Long)this.memberExtQueryApi.queryUserIdByMemberId(commanderId).getData();
            if (commanderUserId == null) {
                throw new BizException("\u67e5\u8be2\u5206\u9500\u5458\u4f1a\u5458\u7528\u6237id\u4e0d\u5b58\u5728\uff01");
            }
            MemberPhoneRespDto commanderMember = (MemberPhoneRespDto)this.memberExtQueryApi.queryMemberByPhone(commanderId).getData();
            this.logger.info("\u67e5\u8be2\u5206\u9500\u5458\u4f1a\u5458\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)commanderMember));
            if (commanderMember == null) {
                throw new BizException("\u67e5\u8be2\u5206\u9500\u5458\u4f1a\u5458\u4e0d\u5b58\u5728\uff01");
            }
            DateTime now = DateTime.now();
            Integer distributionRegisterLimit = (Integer)this.tradeConfQueryService.queryByCode("distributionRegisterLimit");
            this.logger.info("\u5206\u9500\u6ce8\u518c\u4fdd\u62a4\u914d\u7f6e\u9879-\u5206\u9500\u6ce8\u518c\u4fdd\u62a4\u671f\u9650: {}", (Object)JSON.toJSONString((Object)distributionRegisterLimit));
            Date expirationTime = now.plusDays(distributionRegisterLimit.intValue()).toDate();
            SharedRegisterDistributionEo sharedRegisterDistributionEo = SharedRegisterDistributionEo.newInstance();
            sharedRegisterDistributionEo.setPlaceUserId(memberUserId);
            SharedRegisterDistributionEo existSharedRegisterDistributionEo = (SharedRegisterDistributionEo)this.shareRegisterDistributionDas.selectOne((BaseEo)sharedRegisterDistributionEo);
            if (existSharedRegisterDistributionEo != null) {
                this.logger.info("\u5df2\u7ecf\u751f\u6210\u6ce8\u518c\u4fdd\u62a4\u65f6\u95f4\u6570\u636e\uff01");
                return MessageResponse.SUCCESS;
            }
            SharedRegisterDistributionEo createSharedRegisterDistributionEo = new SharedRegisterDistributionEo();
            createSharedRegisterDistributionEo.setPlaceUserId(memberUserId);
            createSharedRegisterDistributionEo.setShareUserId(commanderUserId);
            createSharedRegisterDistributionEo.setShareUserName(commanderMember.getUserName());
            createSharedRegisterDistributionEo.setShareUserMobile(commanderMember.getPhone());
            createSharedRegisterDistributionEo.setExpirationTime(expirationTime);
            this.shareRegisterDistributionDas.insert((BaseEo)createSharedRegisterDistributionEo);
        }
        catch (Exception e) {
            this.logger.error("\u7528\u6237\u5173\u8054\u5206\u9500\u6ce8\u518c\u4fdd\u62a4\u8bb0\u5f55\u5904\u7406\u6267\u884c\u5f02\u5e38\uff1a{}", (Throwable)e);
            return MessageResponse.SUCCESS;
        }
        return MessageResponse.SUCCESS;
    }
}

