/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.mq.producer;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.DeliveryChangeReqDto;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.vo.DeliveryMergeVo;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.vo.DeliverySplitVo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.DeliveryOrderVo;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class DeliveryProducer {
    private static final Logger logger = LoggerFactory.getLogger(DeliveryProducer.class);
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private Environment environment;

    public void sendInventoryDelivery(DeliveryOrderVo deliveryOrderVo) {
        logger.info("\u5411\u5e93\u5b58\u4e2d\u5fc3\u53d1\u9001\u53d1\u8d27\u5355\u4fe1\u606f: {}", (Object)JSON.toJSONString((Object)deliveryOrderVo));
        this.commonsMqService.sendSingleMessage(this.environment.resolvePlaceholders("INVENTORY_DELIVERY_TOPIC"), "INVENTORY_DELIVERY_TAG", (Object)JSON.toJSONString((Object)deliveryOrderVo));
    }

    public void sendInventoryDeliveryChange(DeliveryChangeReqDto deliveryChangeReqDto) {
        logger.info("\u5411\u5e93\u5b58\u4e2d\u5fc3\u66f4\u65b0\u53d1\u8d27\u5355\u6d88\u606f: {}", (Object)JSON.toJSONString((Object)deliveryChangeReqDto));
        this.commonsMqService.sendSingleMessage(this.environment.resolvePlaceholders("INVENTORY_DELIVERY_TOPIC"), "INVENTORY_DELIVERY_CHANGE_TAG", (Object)deliveryChangeReqDto);
    }

    public void sendInventoryDeliverySplit(DeliverySplitVo deliverySplitVo) {
        logger.info("\u53d1\u8d27\u5355\uff1a{}\u62c6\u5355\u6210\u529f\uff0c\u5411\u5e93\u5b58\u4e2d\u5fc3\u53d1\u9001\u62c6\u5355\u4fe1\u606f\u53d1\u8d27\u5355\u6d88\u606f: {}", (Object)deliverySplitVo.getDeliveryParent().getDeliveryNo(), (Object)JSON.toJSONString((Object)deliverySplitVo));
        this.commonsMqService.sendSingleMessage(this.environment.resolvePlaceholders("TRADE_DELIVERY_SPLIT_TOPIC"), this.environment.resolvePlaceholders("TRADE_DELIVERY_SPLIT_TAG"), (Object)JSON.toJSONString((Object)deliverySplitVo));
    }

    public void sendInventoryDeliveryMerge(DeliveryMergeVo deliveryMergeVo) {
        logger.info("\u53d1\u8d27\u5355\u5408\u5355\u6210\u529f\uff0c\u5411\u5e93\u5b58\u4e2d\u5fc3\u53d1\u9001\u62c6\u5355\u4fe1\u606f\u53d1\u8d27\u5355\u6d88\u606f: {}", (Object)JSON.toJSONString((Object)deliveryMergeVo));
        this.commonsMqService.sendSingleMessage(this.environment.resolvePlaceholders("TRADE_DELIVERY_MERGE_TOPIC"), this.environment.resolvePlaceholders("TRADE_DELIVERY_MERGE_TAG"), (Object)JSON.toJSONString((Object)deliveryMergeVo));
    }
}

