/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.mq.producer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.constants.ComConstants;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.biz.member.api.basis.dto.request.TradeOrderInfoReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.DistributionSetRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderAddressRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.PayRecordRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.ReturnDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.TradeItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.IAfterSalesQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.IOrderQueryApi;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IPayService;
import com.dtyunxi.yundt.cube.center.trade.biz.util.DistributionUtil;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.PayRecordEo;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.constants.DistributionTypeEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class MarketOrderTradeStatusProducer {
    private Logger logger = LoggerFactory.getLogger(MarketOrderTradeStatusProducer.class);
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource(name="orderQueryApiImpl")
    private IOrderQueryApi orderQueryApi;
    @Autowired
    private IPayService payService;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource(name="afterSalesQueryApiImpl")
    private IAfterSalesQueryApi afterSalesQueryApi;
    @Resource
    private Environment environment;
    @Autowired
    private DistributionUtil distributionUtil;

    public void setRecommendUserId(TradeOrderInfoReqDto tradeOrderInfoReqDto, List<TradeItemRespDto> orderItems) {
    }

    private TradeOrderInfoReqDto getTradeOrderByOrderNo(String orderNo, String payNo) {
        OrderAddressRespDto orderAddress;
        TradeOrderInfoReqDto tradeOrderInfoReqDto = new TradeOrderInfoReqDto();
        RestResponse orderQueryApiOrderDetail = this.orderQueryApi.getOrderDetail(orderNo);
        OrderDetailRespDto orderDetailRespDto = (OrderDetailRespDto)orderQueryApiOrderDetail.getData();
        tradeOrderInfoReqDto.setOrderCreateTime(orderDetailRespDto.getCreateTime());
        tradeOrderInfoReqDto.setInstanceId(orderDetailRespDto.getInstanceId());
        tradeOrderInfoReqDto.setTenantId(orderDetailRespDto.getTenantId());
        List orderItems = orderDetailRespDto.getOrderItems();
        RestResponse shopDtoRestResponse = this.shopQueryApi.queryById(Long.valueOf(orderDetailRespDto.getShopId()).longValue(), new String[]{""});
        ShopDto data = (ShopDto)shopDtoRestResponse.getData();
        if (data != null) {
            tradeOrderInfoReqDto.setShopCode(data.getCode());
        }
        Integer distributionType = this.distributionUtil.getDistribType();
        if (CollectionUtils.isNotEmpty((Collection)orderItems)) {
            List tradeItems = orderItems.stream().map(tradeItemRespDto -> {
                TradeOrderInfoReqDto.TradeItem tradeItem = new TradeOrderInfoReqDto.TradeItem();
                tradeItem.setItemName(tradeItemRespDto.getItemName());
                tradeItem.setItemCode(tradeItemRespDto.getItemSerial());
                tradeItem.setItemType("\u5546\u57ce\u5546\u54c1");
                tradeItem.setItemSku(tradeItemRespDto.getSkuSerial());
                tradeItem.setOrderLineId("0");
                tradeItem.setItemNum(new BigDecimal(tradeItemRespDto.getItemNum()));
                tradeItem.setItemPrice(tradeItemRespDto.getItemPrice());
                tradeItem.setPayAmount(tradeItemRespDto.getPayTotalAmount());
                tradeItem.setItemImageUrl(this.getImgPath((TradeItemRespDto)tradeItemRespDto));
                tradeItem.setItemCostPrice(tradeItemRespDto.getItemCostPrice());
                if (StringUtils.isNotBlank((CharSequence)tradeItemRespDto.getDistributionInfo()) && Objects.equals(distributionType, DistributionTypeEnum.PREMIUM.getCode())) {
                    DistributionSetRespDto distributionInfo = (DistributionSetRespDto)JSON.parseObject((String)tradeItemRespDto.getDistributionInfo(), DistributionSetRespDto.class);
                    if (null != distributionInfo) {
                        if (distributionInfo.getValueType() == 1) {
                            tradeItem.setDirectCommission(Double.valueOf(distributionInfo.getFirstLevelAmount() != null ? distributionInfo.getFirstLevelAmount().doubleValue() / 100.0 : 0.0));
                            tradeItem.setIndirectCommission(Double.valueOf(distributionInfo.getSecondLevelAmount() != null ? distributionInfo.getSecondLevelAmount().doubleValue() / 100.0 : 0.0));
                            tradeItem.setDirectPoints(Double.valueOf(distributionInfo.getFirstLevelPoint() != null ? distributionInfo.getFirstLevelPoint().doubleValue() / 100.0 : 0.0));
                            tradeItem.setIndirectPoints(Double.valueOf(distributionInfo.getSecondLevelPoint() != null ? distributionInfo.getSecondLevelPoint().doubleValue() / 100.0 : 0.0));
                        } else if (distributionInfo.getValueType() == 2) {
                            tradeItem.setDirectCommission(Double.valueOf(distributionInfo.getFirstLevelAmount() != null ? distributionInfo.getFirstLevelAmount().doubleValue() * 100.0 : 0.0));
                            tradeItem.setIndirectCommission(Double.valueOf(distributionInfo.getSecondLevelAmount() != null ? distributionInfo.getSecondLevelAmount().doubleValue() * 100.0 : 0.0));
                            tradeItem.setDirectPoints(Double.valueOf(distributionInfo.getFirstLevelPoint() != null ? distributionInfo.getFirstLevelPoint().doubleValue() : 0.0));
                            tradeItem.setIndirectPoints(Double.valueOf(distributionInfo.getSecondLevelPoint() != null ? distributionInfo.getSecondLevelPoint().doubleValue() : 0.0));
                        }
                        tradeItem.setCommissionType(distributionInfo.getValueType());
                    }
                } else if (Objects.equals(distributionType, DistributionTypeEnum.PREMIUM.getCode())) {
                    tradeItem.setCommissionType(Integer.valueOf(2));
                    tradeItem.setDirectCommission(Double.valueOf(0.0));
                    tradeItem.setIndirectCommission(Double.valueOf(0.0));
                    tradeItem.setDirectPoints(Double.valueOf(0.0));
                    tradeItem.setIndirectPoints(Double.valueOf(0.0));
                }
                return tradeItem;
            }).collect(Collectors.toList());
            tradeOrderInfoReqDto.setTradeItems(tradeItems);
        }
        if (null != (orderAddress = orderDetailRespDto.getOrderAddress())) {
            this.logger.warn("\u8ba2\u5355\u5730\u5740\u67e5\u8be2\u4e0d\u5230\u4fe1\u606f\u2026\u2026");
            tradeOrderInfoReqDto.setReceiverCity(orderAddress.getCityName());
            tradeOrderInfoReqDto.setReceiverDistrict(orderAddress.getAreaName());
            tradeOrderInfoReqDto.setReceiverProvince(orderAddress.getProvinceName());
            tradeOrderInfoReqDto.setReceiverName(orderAddress.getDeliveryName());
            tradeOrderInfoReqDto.setReceiverPhone(orderAddress.getDeliveryMobile());
            tradeOrderInfoReqDto.setReceiverAddress(orderAddress.getDetailed());
        }
        tradeOrderInfoReqDto.setFreight(orderDetailRespDto.getFreightAmount());
        tradeOrderInfoReqDto.setNickName(orderDetailRespDto.getBuyerNickname());
        tradeOrderInfoReqDto.setTradeCode(orderDetailRespDto.getTradeNo());
        tradeOrderInfoReqDto.setPayAmount(orderDetailRespDto.getPayAmount());
        tradeOrderInfoReqDto.setSource(Integer.valueOf(1));
        tradeOrderInfoReqDto.setOriginOrderNo(orderDetailRespDto.getSaleChannelOrderNo());
        tradeOrderInfoReqDto.setOutOrderNo(orderDetailRespDto.getSaleChannelOrderNo());
        tradeOrderInfoReqDto.setPayTime(orderDetailRespDto.getPayTime());
        tradeOrderInfoReqDto.setDiscountAmount(orderDetailRespDto.getDiscountAmount());
        tradeOrderInfoReqDto.setUserId(Long.valueOf(orderDetailRespDto.getUserId()));
        TradeItemRespDto distributionTradeItem = orderItems.stream().filter(tradeItemRespDto -> tradeItemRespDto.getShareUserId() != null).findFirst().orElse(null);
        if (distributionTradeItem != null) {
            tradeOrderInfoReqDto.setRecommendUserId(distributionTradeItem.getShareUserId());
        }
        if (StringUtils.isNotEmpty((CharSequence)orderDetailRespDto.getUserId())) {
            tradeOrderInfoReqDto.setUserId(Long.valueOf(orderDetailRespDto.getUserId()));
        }
        if (StringUtils.isNotEmpty((CharSequence)payNo)) {
            orderDetailRespDto.setPayRecordList(new ArrayList());
            PayRecordEo payRecordEo = this.payService.queryByPayNo(payNo);
            PayRecordRespDto payRecordRespDto2 = new PayRecordRespDto();
            BeanUtils.copyProperties((Object)payRecordEo, (Object)payRecordRespDto2);
            tradeOrderInfoReqDto.setPayTime(new Date());
            orderDetailRespDto.getPayRecordList().add(payRecordRespDto2);
        }
        if (CollectionUtils.isNotEmpty((Collection)orderDetailRespDto.getPayRecordList())) {
            List payInfos = orderDetailRespDto.getPayRecordList().stream().map(payRecordRespDto -> {
                TradeOrderInfoReqDto.PayInfo payInfo = new TradeOrderInfoReqDto.PayInfo();
                payInfo.setPayNo(payRecordRespDto.getExtlPayAccount());
                payInfo.setPayAmount(payRecordRespDto.getPayAmount());
                String desc = ComConstants.PayType.getDescByCode((String)payRecordRespDto.getPayMethod());
                payInfo.setType(desc);
                payInfo.setPayId(payRecordRespDto.getPayNo());
                return payInfo;
            }).collect(Collectors.toList());
            tradeOrderInfoReqDto.setPayInfos(payInfos);
        }
        if ("mall".equals(orderDetailRespDto.getSaleChannel())) {
            tradeOrderInfoReqDto.setSource(Integer.valueOf(2));
        }
        return tradeOrderInfoReqDto;
    }

    private String getImgPath(TradeItemRespDto tradeItem) {
        JSONObject jsonObject;
        if (StringUtils.isNotBlank((CharSequence)tradeItem.getExtension()) && null != (jsonObject = JSONObject.parseObject((String)tradeItem.getExtension()))) {
            return jsonObject.getString("imgPath");
        }
        return null;
    }

    public void sendOrderPaySuccessMessageToMarket(OrderEo orderEo, String payNo) {
        this.logger.info("\u8ba2\u5355\u53f7{}\u53d1\u9001\u652f\u4ed8\u6210\u529f\u8425\u9500\u6d88\u606f", (Object)orderEo.getOrderNo());
        TradeOrderInfoReqDto tradeOrderInfoReqDto = this.getTradeOrderByOrderNo(orderEo.getOrderNo(), payNo);
        tradeOrderInfoReqDto.setOrderType(Integer.valueOf(1));
        tradeOrderInfoReqDto.setOrderNo(orderEo.getOrderNo());
        tradeOrderInfoReqDto.setTradeStatus("PAYED");
        ArrayList<TradeOrderInfoReqDto> tradeOrderInfoReqDtos = new ArrayList<TradeOrderInfoReqDto>();
        tradeOrderInfoReqDtos.add(tradeOrderInfoReqDto);
        String sendJson = JSON.toJSONString(tradeOrderInfoReqDtos);
        this.logger.info("\u8ba2\u5355\u53f7{}\u53d1\u9001\u652f\u4ed8\u6210\u529f\u8425\u9500\u6d88\u606f={}", (Object)orderEo.getOrderNo(), (Object)sendJson);
        this.commonsMqService.sendSingleMessage(this.environment.resolvePlaceholders("${IMK_TRADE_UNIFIED_SYNC_TOPIC:IMK_TRADE_UNIFIED_SYNC_TOPIC}"), "IMK_TRADE_UNIFIED_SYNC_TAG", (Object)sendJson);
    }

    public void sendOrderDeliverySuccessMessageToMarket(String orderNo) {
        this.logger.info("\u8ba2\u5355\u53f7{}\u53d1\u9001\u53d1\u8d27\u8425\u9500\u6d88\u606f", (Object)orderNo);
        TradeOrderInfoReqDto tradeOrderInfoReqDto = this.getTradeOrderByOrderNo(orderNo, null);
        tradeOrderInfoReqDto.setOrderType(Integer.valueOf(1));
        tradeOrderInfoReqDto.setOrderNo(orderNo);
        tradeOrderInfoReqDto.setTradeStatus("DELIVERY");
        ArrayList<TradeOrderInfoReqDto> tradeOrderInfoReqDtos = new ArrayList<TradeOrderInfoReqDto>();
        tradeOrderInfoReqDtos.add(tradeOrderInfoReqDto);
        String sendJson = JSON.toJSONString(tradeOrderInfoReqDtos);
        this.logger.info("\u8ba2\u5355\u53f7{}\u53d1\u9001\u53d1\u8d27\u6210\u529f\u8425\u9500\u6d88\u606f={}", (Object)orderNo, (Object)sendJson);
        this.commonsMqService.sendSingleMessage(this.environment.resolvePlaceholders("${IMK_TRADE_UNIFIED_SYNC_TOPIC:IMK_TRADE_UNIFIED_SYNC_TOPIC}"), "IMK_TRADE_UNIFIED_SYNC_TAG", (Object)sendJson);
    }

    public void sendOrderReturnSuccessMessageToMarket(String returnNo) {
        this.logger.info("\u9000\u6b3e\u5355\u53f7{}\u53d1\u9001\u9000\u6b3e\u6210\u529f\u8425\u9500\u6d88\u606f", (Object)returnNo);
        RestResponse returnDetailRespDtoRestResponse = this.afterSalesQueryApi.queryReturnDetail(returnNo, "{}");
        ReturnDetailRespDto returnDetailRespDto = (ReturnDetailRespDto)returnDetailRespDtoRestResponse.getData();
        TradeOrderInfoReqDto tradeOrderInfoReqDto = this.getTradeOrderByOrderNo(returnDetailRespDto.getOrderTradeNo(), null);
        tradeOrderInfoReqDto.setOrderType(Integer.valueOf(2));
        tradeOrderInfoReqDto.setOrderNo(returnNo);
        tradeOrderInfoReqDto.setOriginOrderNo(returnDetailRespDto.getOrderTradeNo());
        tradeOrderInfoReqDto.setRefundAmount(Double.valueOf(returnDetailRespDto.getRefundAmount().doubleValue()));
        tradeOrderInfoReqDto.setRefundTime(new Date());
        TradeOrderInfoReqDto.RefundInfo refundInfo = new TradeOrderInfoReqDto.RefundInfo();
        refundInfo.setRefundAmount(returnDetailRespDto.getRefundAmount());
        if (CollectionUtils.isNotEmpty((Collection)returnDetailRespDto.getReturnOmniItemRespDtoList())) {
            List refundItems = returnDetailRespDto.getReturnOmniItemRespDtoList().stream().map(refTradeItem -> {
                TradeOrderInfoReqDto.RefundItem refundItem = new TradeOrderInfoReqDto.RefundItem();
                refundItem.setItemSku(refTradeItem.getSkuSerial());
                refundItem.setOrderLineId("0");
                refundItem.setRefundNum(new BigDecimal(refTradeItem.getItemNum()));
                refundItem.setItemSku(refTradeItem.getSkuSerial());
                return refundItem;
            }).collect(Collectors.toList());
            refundInfo.setRufundItems(refundItems);
        }
        ArrayList<TradeOrderInfoReqDto.RefundInfo> list = new ArrayList<TradeOrderInfoReqDto.RefundInfo>();
        list.add(refundInfo);
        tradeOrderInfoReqDto.setRefundInfos(list);
        tradeOrderInfoReqDto.setTradeStatus("FINISHED");
        ArrayList<TradeOrderInfoReqDto> tradeOrderInfoReqDtos = new ArrayList<TradeOrderInfoReqDto>();
        tradeOrderInfoReqDtos.add(tradeOrderInfoReqDto);
        String sendJson = JSON.toJSONString(tradeOrderInfoReqDtos);
        this.logger.info("\u9000\u6b3e\u5355\u53f7{}\u53d1\u9001\u9000\u6b3e\u6210\u529f\u8425\u9500\u6d88\u606f={}", (Object)returnNo, (Object)sendJson);
        this.commonsMqService.sendSingleMessage(this.environment.resolvePlaceholders("${IMK_TRADE_UNIFIED_SYNC_TOPIC:IMK_TRADE_UNIFIED_SYNC_TOPIC}"), "IMK_TRADE_UNIFIED_SYNC_TAG", (Object)sendJson);
    }

    public void sendOrderCompleteMessage(String orderNo) {
        this.logger.info("\u8ba2\u5355\u53f7{}\u53d1\u9001\u8ba2\u5355\u5b8c\u6210\u8425\u9500\u6d88\u606f", (Object)orderNo);
        TradeOrderInfoReqDto tradeOrderInfoReqDto = this.getTradeOrderByOrderNo(orderNo, null);
        tradeOrderInfoReqDto.setOrderType(Integer.valueOf(1));
        tradeOrderInfoReqDto.setOrderNo(orderNo);
        tradeOrderInfoReqDto.setTradeStatus("COMPLETE");
        ArrayList<TradeOrderInfoReqDto> tradeOrderInfoReqDtos = new ArrayList<TradeOrderInfoReqDto>();
        tradeOrderInfoReqDtos.add(tradeOrderInfoReqDto);
        String data = JSON.toJSONString(tradeOrderInfoReqDtos);
        this.commonsMqService.sendSingleMessage(this.environment.resolvePlaceholders("${IMK_TRADE_UNIFIED_SYNC_TOPIC:IMK_TRADE_UNIFIED_SYNC_TOPIC}"), "IMK_TRADE_UNIFIED_SYNC_TAG", (Object)data);
        this.logger.info("\u8ba2\u5355\u53f7{}\u53d1\u9001\u8ba2\u5355\u5b8c\u6210\u8425\u9500\u6d88\u606f\u6210\u529f\uff0cmessage={}", (Object)orderNo, (Object)data);
    }

    public void sendGroupOrderFailMessageToMarket(String orderNo) {
        this.logger.info("\u62fc\u56e2\u5931\u8d25\u5355\u53f7{}\u53d1\u9001\u62fc\u56e2\u5931\u8d25\u8425\u9500\u6d88\u606f", (Object)orderNo);
        RestResponse returnDetailRespDtoRestResponse = this.orderQueryApi.getOrderDetail(orderNo);
        OrderDetailRespDto orderDetailRespDto = (OrderDetailRespDto)returnDetailRespDtoRestResponse.getData();
        TradeOrderInfoReqDto tradeOrderInfoReqDto = this.getTradeOrderByOrderNo(orderNo, null);
        tradeOrderInfoReqDto.setOrderType(Integer.valueOf(2));
        tradeOrderInfoReqDto.setOrderNo("GF" + orderNo);
        tradeOrderInfoReqDto.setOriginOrderNo(orderNo);
        tradeOrderInfoReqDto.setRefundAmount(Double.valueOf(orderDetailRespDto.getPayAmount().doubleValue()));
        tradeOrderInfoReqDto.setRefundTime(new Date());
        TradeOrderInfoReqDto.RefundInfo refundInfo = new TradeOrderInfoReqDto.RefundInfo();
        refundInfo.setRefundAmount(orderDetailRespDto.getPayAmount());
        if (CollectionUtils.isNotEmpty((Collection)orderDetailRespDto.getOrderItems())) {
            List refundItems = orderDetailRespDto.getOrderItems().stream().map(refTradeItem -> {
                TradeOrderInfoReqDto.RefundItem refundItem = new TradeOrderInfoReqDto.RefundItem();
                refundItem.setItemSku(refTradeItem.getSkuSerial());
                refundItem.setOrderLineId("0");
                refundItem.setRefundNum(new BigDecimal(refTradeItem.getItemNum()));
                refundItem.setItemSku(refTradeItem.getSkuSerial());
                return refundItem;
            }).collect(Collectors.toList());
            refundInfo.setRufundItems(refundItems);
        }
        ArrayList<TradeOrderInfoReqDto.RefundInfo> list = new ArrayList<TradeOrderInfoReqDto.RefundInfo>();
        list.add(refundInfo);
        tradeOrderInfoReqDto.setRefundInfos(list);
        tradeOrderInfoReqDto.setTradeStatus("GROUP_FAIL");
        ArrayList<TradeOrderInfoReqDto> tradeOrderInfoReqDtos = new ArrayList<TradeOrderInfoReqDto>();
        tradeOrderInfoReqDtos.add(tradeOrderInfoReqDto);
        String sendJson = JSON.toJSONString(tradeOrderInfoReqDtos);
        this.logger.info("\u62fc\u56e2\u5931\u8d25\u5355\u53f7{}\u53d1\u9001\u9000\u6b3e\u6210\u529f\u8425\u9500\u6d88\u606f={}", (Object)orderNo, (Object)sendJson);
        this.commonsMqService.sendSingleMessage(this.environment.resolvePlaceholders("${IMK_TRADE_UNIFIED_SYNC_TOPIC:IMK_TRADE_UNIFIED_SYNC_TOPIC}"), "IMK_TRADE_UNIFIED_SYNC_TAG", (Object)sendJson);
    }
}

