/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.scheduler.task;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.DeliveryStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.EnableEnum;
import com.dtyunxi.yundt.cube.center.scheduler.api.ITaskApi;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.AppBizQueryReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskAndBizCreateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskQueryReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskUpdateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.AppBizQueryRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.TaskQueryRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.query.IAppBizQueryApi;
import com.dtyunxi.yundt.cube.center.scheduler.api.query.ITaskQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.TradeSchedulerEnum;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IDeliveryRouterService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IDeliveryService;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderDeliveryDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderDeliveryEo;
import com.github.pagehelper.PageInfo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class DeliveryConfirmTask {
    private static final Logger logger = LoggerFactory.getLogger(DeliveryConfirmTask.class);
    @Resource
    private ITaskQueryApi taskQueryApi;
    @Resource
    private ITaskApi taskApi;
    @Resource
    private IAppBizQueryApi appBizQueryApi;
    @Resource
    private IDeliveryRouterService deliveryRouterService;
    @Value(value="${scheduler.client.app_code}")
    private String appCode;
    @Value(value="${scheduler.delivery.confirm.expression:}")
    private String scheduleExpression;
    @Autowired
    private OrderDeliveryDas orderDeliveryDas;
    @Resource
    private IDeliveryService deliveryService;

    public void handleConfrim() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        int deliveryConfirmMin = this.deliveryRouterService.getDeliveryConfirmMin();
        Date date = DateUtil.addMinutes((Date)new Date(), (int)(-deliveryConfirmMin));
        OrderDeliveryEo orderDeliverySelect = OrderDeliveryEo.newInstance();
        orderDeliverySelect.setDeliveryStatus(DeliveryStatusEnum.TO_CONFIRM.getStatus());
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.le((String)"createTime", (Object)format.format(date)));
        orderDeliverySelect.setSqlFilters(sqlFilterList);
        ArrayList orderDeliverys = new ArrayList();
        Integer pageNum = 1;
        Integer pageSize = 5000;
        PageInfo pageInfo = this.orderDeliveryDas.selectPage((BaseEo)orderDeliverySelect, pageNum, pageSize);
        if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            orderDeliverys.addAll(pageInfo.getList());
        }
        int pages = pageInfo.getPages();
        while (pageNum < pages) {
            pageInfo = this.orderDeliveryDas.selectPage((BaseEo)orderDeliverySelect, Integer.valueOf(pageNum + 1), pageSize);
            List list = pageInfo.getList();
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                orderDeliverys.addAll(list);
            }
            Integer n = pageNum;
            Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
        }
        if (CollectionUtils.isEmpty(orderDeliverys)) {
            logger.info("\u65e0\u5f85\u786e\u8ba4\u72b6\u6001\u7684\u53d1\u8d27\u5355\u8fdb\u884c\u5904\u7406\u2026\u2026");
            return;
        }
        logger.info("\u5f00\u59cb\u5904\u7406\u5f85\u786e\u8ba4\u7684\u53d1\u8d27\u5355\uff0c\u603b\u6761\u6570\uff1a{}", (Object)orderDeliverys.size());
        orderDeliverys.forEach(e -> this.deliveryService.confirmDelivery((OrderDeliveryEo)e));
    }

    public void initTask() {
        logger.info("\u5f00\u59cb\u521d\u59cb\u5316\u3010\u53d1\u8d27\u5355\u786e\u8ba4\u72b6\u6001\u5904\u7406\u5b9a\u65f6\u4efb\u52a1\u3011,scheduleExpression:{}", (Object)this.scheduleExpression);
        if (StringUtils.isEmpty((CharSequence)this.scheduleExpression)) {
            logger.warn("\u521d\u59cb\u5316\u3010\u53d1\u8d27\u5355\u786e\u8ba4\u72b6\u6001\u5904\u7406\u5b9a\u65f6\u4efb\u52a1\u3011\u5931\u8d25,\u4ea4\u6613\u4e2d\u5fc3\u914d\u7f6e\u6587\u4ef6\u672a\u914d\u7f6e\u4efb\u52a1\u6267\u884c\u8868\u8fbe\u5f0f\uff01");
            return;
        }
        AppBizQueryReqDto appBizQueryReqDto = new AppBizQueryReqDto();
        appBizQueryReqDto.setAppCode(this.appCode);
        appBizQueryReqDto.setBizCode(TradeSchedulerEnum.DELIVERY_CONFIRM_EVENT.getBizCode());
        String filter = ObjectHelper.bean2Json((Object)appBizQueryReqDto);
        List appBizQueryRespDtos = ((PageInfo)this.appBizQueryApi.queryByPage(filter, Integer.valueOf(1), Integer.valueOf(1)).getData()).getList();
        if (CollectionUtils.isEmpty((Collection)appBizQueryRespDtos)) {
            logger.info("\u5b9a\u65f6\u4efb\u52a1\u3010\u53d1\u8d27\u5355\u786e\u8ba4\u72b6\u6001\u5904\u7406\u5b9a\u65f6\u4efb\u52a1\u3011\u4e0d\u5df2\u5b58\u5728\uff0c\u5f00\u59cb\u8fdb\u884c\u521d\u59cb\u5316\u2026\u2026");
            this.createTask();
            return;
        }
        logger.info("\u5b9a\u65f6\u4efb\u52a1\u3010\u53d1\u8d27\u5355\u786e\u8ba4\u72b6\u6001\u5904\u7406\u5b9a\u65f6\u4efb\u52a1\u3011\u5df2\u5b58\u5728\uff0c\u5f00\u59cb\u8fdb\u884c\u66f4\u65b0\u2026\u2026");
        AppBizQueryRespDto origAppBiz = (AppBizQueryRespDto)appBizQueryRespDtos.get(0);
        TaskQueryReqDto taskQueryReqDto = new TaskQueryReqDto();
        taskQueryReqDto.setTaskName(origAppBiz.getBizName());
        taskQueryReqDto.setAppBizId(origAppBiz.getId());
        String taskFilter = ObjectHelper.bean2Json((Object)taskQueryReqDto);
        PageInfo taskPageInfo = (PageInfo)this.taskQueryApi.queryByPage(taskFilter, Integer.valueOf(1), Integer.valueOf(1)).getData();
        if (null == taskPageInfo || CollectionUtils.isEmpty((Collection)taskPageInfo.getList())) {
            throw new BizException("\u3010\u53d1\u8d27\u5355\u786e\u8ba4\u72b6\u6001\u5904\u7406\u5b9a\u65f6\u4efb\u52a1\u3011\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38\uff01");
        }
        TaskQueryRespDto origTask = (TaskQueryRespDto)taskPageInfo.getList().get(0);
        String status = origTask.getStatus();
        if (this.scheduleExpression.equals(origTask.getScheduleExpression())) {
            logger.info("\u5b9a\u65f6\u4efb\u52a1\u3010\u53d1\u8d27\u5355\u786e\u8ba4\u72b6\u6001\u5904\u7406\u5b9a\u65f6\u4efb\u52a1\u3011\u914d\u7f6e\u4e0d\u53d8\uff0c\u4e0d\u8fdb\u884c\u66f4\u65b0\u64cd\u4f5c\u3002");
            if (EnableEnum.DISABLE.getCodeEn().equals(status)) {
                RestResponse enbaleResponse = this.taskApi.enableById(origTask.getId(), "{}");
                logger.info("\u539f\u5b9a\u65f6\u4efb\u52a1\u3010\u53d1\u8d27\u5355\u786e\u8ba4\u72b6\u6001\u5904\u7406\u5b9a\u65f6\u4efb\u52a1\u3011\u672a\u542f\u7528\uff0c\u542f\u7528\u5b8c\u6bd5\uff0c{}", (Object)JSON.toJSONString((Object)enbaleResponse));
            }
            return;
        }
        if (EnableEnum.ENABLE.getCodeEn().equals(status)) {
            RestResponse disableResponse = this.taskApi.disableById(origTask.getId(), "{}");
            logger.info("\u7981\u7528\u3010\u53d1\u8d27\u5355\u786e\u8ba4\u72b6\u6001\u5904\u7406\u5b9a\u65f6\u4efb\u52a1\u3011\u6210\u529f\uff0c{}", (Object)JSON.toJSONString((Object)disableResponse));
        }
        TaskUpdateReqDto taskUpate = new TaskUpdateReqDto();
        taskUpate.setScheduleExpression(this.scheduleExpression);
        taskUpate.setInstanceId(Long.valueOf(-1L));
        taskUpate.setTenantId(Long.valueOf(-1L));
        RestResponse updateResponse = this.taskApi.modifyById(origTask.getId(), taskUpate);
        logger.info("\u66f4\u65b0\u3010\u53d1\u8d27\u5355\u786e\u8ba4\u72b6\u6001\u5904\u7406\u5b9a\u65f6\u4efb\u52a1\u3011\u5b8c\u6bd5\uff0c{}", (Object)JSON.toJSONString((Object)updateResponse));
        RestResponse enbaleResponse = this.taskApi.enableById(origTask.getId(), "{}");
        logger.info("\u542f\u7528\u3010\u53d1\u8d27\u5355\u786e\u8ba4\u72b6\u6001\u5904\u7406\u5b9a\u65f6\u4efb\u52a1\u3011\u5b8c\u6bd5\uff0c{}", (Object)JSON.toJSONString((Object)enbaleResponse));
    }

    public void createTask() {
        logger.info("\u5f00\u59cb\u521b\u5efa\u3010\u53d1\u8d27\u5355\u786e\u8ba4\u72b6\u6001\u5904\u7406\u5b9a\u65f6\u4efb\u52a1\u3011\u2026\u2026");
        TaskAndBizCreateReqDto taskAndBizCreate = new TaskAndBizCreateReqDto();
        taskAndBizCreate.setAppCode(this.appCode);
        taskAndBizCreate.setBizCode(TradeSchedulerEnum.DELIVERY_CONFIRM_EVENT.getBizCode());
        taskAndBizCreate.setBizName(TradeSchedulerEnum.DELIVERY_CONFIRM_EVENT.getBizName());
        taskAndBizCreate.setParams("");
        taskAndBizCreate.setScheduleExpression(this.scheduleExpression);
        taskAndBizCreate.setShardType("SINGLE");
        taskAndBizCreate.setTaskName(TradeSchedulerEnum.DELIVERY_CONFIRM_EVENT.getBizName());
        taskAndBizCreate.setTaskDesc("\u53d1\u8d27\u5355\u786e\u8ba4\u72b6\u6001\u5904\u7406\u5b9a\u65f6\u4efb\u52a1");
        taskAndBizCreate.setInstanceId(Long.valueOf(-1L));
        taskAndBizCreate.setTenantId(Long.valueOf(-1L));
        RestResponse addResult = this.taskApi.addWithBiz(taskAndBizCreate);
        this.taskApi.enableById((Long)addResult.getData(), "{}");
        logger.info("\u53d1\u8d27\u5355\u786e\u8ba4\u72b6\u6001\u5904\u7406\u5b9a\u65f6\u4efb\u52a1\u521b\u5efa\u6210\u529f\uff01");
    }
}

